/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.attach;

import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.ResourceApplicabilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.ResourceAvailabilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachProjectResourcesOverrideData;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.ide.sdk.core.resource.processors.CopySdkResourceProcessor;
import com.nxp.s32ds.cle.ide.sdk.core.resource.processors.LinkSdkResourceProcessor;
import com.nxp.s32ds.cle.ide.sdk.core.resource.processors.SdkResourceProcessor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class SdkAttachResourcesProcessor {
    private static final int COPY = 0;
    private static final int MOVE = 1;
    private static final int LINK = 2;
    private SdkDescriptor sdk;
    private IConfiguration configuration;
    private Map<HolderModule, Set<ResourceSdkDescriptor>> resourcesToCopy;
    private Map<HolderModule, Set<ResourceSdkDescriptor>> resourcesToMove;
    private Map<HolderModule, Set<ResourceSdkDescriptor>> resourcesToLink;
    private Map<String, Set<ResourceSdkDescriptor>> resourcesToOverride;
    private final Map<String, Set<ResourceSdkDescriptor>> conflictingFiles;
    private boolean isBackupFiles;

    public SdkAttachResourcesProcessor(SdkDescriptor sdk, IConfiguration configuration, SdkAttachProjectResourcesOverrideData overrideData) {
        this.sdk = sdk;
        this.configuration = configuration;
        this.resourcesToCopy = new LinkedHashMap<HolderModule, Set<ResourceSdkDescriptor>>();
        this.resourcesToMove = new LinkedHashMap<HolderModule, Set<ResourceSdkDescriptor>>();
        this.resourcesToLink = new LinkedHashMap<HolderModule, Set<ResourceSdkDescriptor>>();
        this.resourcesToOverride = overrideData != null ? overrideData.getFilesToOverride() : Collections.emptyMap();
        this.conflictingFiles = overrideData != null ? overrideData.getConflictingFiles() : Collections.emptyMap();
        this.isBackupFiles = overrideData != null && overrideData.isBackupFiles();
    }

    public IStatus process() {
        String toolChainId = this.configuration.getToolChain().getBaseId();
        IProject project = this.configuration.getOwner().getProject();
        ProjectCompatibleSdksFilter sdkFilter = new ProjectCompatibleSdksFilter(project);
        List<SdkDescriptor> sdkRefModules = SdkModulesHelper.getRefModulesSdksDescriptors(this.sdk.getId(), (SdkFilter)sdkFilter);
        if (sdkRefModules.isEmpty()) {
            this.prepareSourcePaths(this.sdk, toolChainId, this.configuration, true);
        } else {
            sdkRefModules.forEach(refModuleSdk -> this.prepareSourcePaths((SdkDescriptor)refModuleSdk, toolChainId, this.configuration, false));
        }
        return this.processSourcePaths(project, (SdkFilter)sdkFilter) ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    private void prepareSourcePaths(SdkDescriptor sdkToProcess, String configToolChainId, IConfiguration configuration, boolean isFromHolderSdk) {
        Map resources = ResourceSdkDescriptors.getResourceSdkDescriptors((String)sdkToProcess.getId(), (String)configToolChainId, (boolean)true);
        for (Map.Entry e : resources.entrySet()) {
            ResourceSdkGroup resourceType = (ResourceSdkGroup)e.getKey();
            Map<Boolean, List<ResourceSdkDescriptor>> resourcesGroupByTargetType = ((List)e.getValue()).stream().filter(resource -> !SdkAttachResourcesProcessor.skipResource(resource, configuration)).collect(Collectors.partitioningBy(ResourceSdkDescriptor::isCopy));
            resourcesGroupByTargetType.getOrDefault(Boolean.TRUE, Collections.emptyList()).forEach(resource -> {
                if (resource.getCopyToProjectPath().isEmpty()) {
                    this.addResourceTo(0, (ResourceSdkDescriptor)resource, sdkToProcess, isFromHolderSdk);
                } else {
                    this.addResourceTo(1, (ResourceSdkDescriptor)resource, sdkToProcess, isFromHolderSdk);
                }
            });
            if (!SdkAttachResourcesProcessor.isResourceCanBeLinked(resourceType)) continue;
            resourcesGroupByTargetType.getOrDefault(Boolean.FALSE, Collections.emptyList()).forEach(resource -> this.addResourceTo(2, (ResourceSdkDescriptor)resource, sdkToProcess, isFromHolderSdk));
        }
    }

    private static boolean isResourceCanBeLinked(ResourceSdkGroup resourceType) {
        return ResourceSdkGroup.HEADER_RESOURCES != resourceType && ResourceSdkGroup.BINARY_RESOURCES != resourceType;
    }

    private static boolean skipResource(ResourceSdkDescriptor resource, IConfiguration configuration) {
        return !ResourceAvailabilityChecker.isResourceAvailable(resource, false) || !ResourceApplicabilityChecker.isApplicable(resource, configuration);
    }

    private boolean processSourcePaths(IProject project, SdkFilter filter) {
        boolean needCopy;
        CopySdkResourceProcessor copyProcessor = new CopySdkResourceProcessor(this.sdk, this.isBackupFiles, this.conflictingFiles);
        this.processSourcePaths(1, project, (SdkResourceProcessor)copyProcessor);
        boolean bl = needCopy = !this.resourcesToCopy.isEmpty();
        if (needCopy || !this.resourcesToLink.isEmpty()) {
            this.createSdkTargetFolders(project, filter, needCopy);
            this.processSourcePaths(0, project, (SdkResourceProcessor)copyProcessor);
            this.processSourcePaths(2, project, (SdkResourceProcessor)new LinkSdkResourceProcessor(this.sdk, this.isBackupFiles));
            return true;
        }
        return false;
    }

    private void createSdkTargetFolders(IProject project, SdkFilter filter, boolean needCopy) {
        String targetFolderName = SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)this.sdk, (IProject)project);
        IPath targetFolderPath = Path.fromOSString((String)targetFolderName);
        if (targetFolderPath.segmentCount() > 0) {
            IFolder projectFolder = project.getFolder(targetFolderPath.uptoSegment(1));
            SdkProjectResourcesUtils.createSdkTargetFolder((IFolder)projectFolder, (boolean)needCopy, null);
            int i = 1;
            while (i <= targetFolderPath.segmentCount() - 1) {
                projectFolder = projectFolder.getFolder(targetFolderPath.segment(i));
                SdkProjectResourcesUtils.createSdkTargetFolder((IFolder)projectFolder, (boolean)needCopy, null);
                ++i;
            }
        }
    }

    private void processSourcePaths(int resourcesGroup, IProject project, SdkResourceProcessor processor) {
        Map<HolderModule, Set<ResourceSdkDescriptor>> sourcePaths = this.getResourcesTo(resourcesGroup);
        for (Map.Entry<HolderModule, Set<ResourceSdkDescriptor>> e : sourcePaths.entrySet()) {
            HolderModule sdkModule = e.getKey();
            for (ResourceSdkDescriptor resource : e.getValue()) {
                boolean isResourceOveridden;
                boolean bl = isResourceOveridden = this.resourcesToOverride != null && !this.resourcesToOverride.isEmpty() && this.resourcesToOverride.values().stream().anyMatch(v -> v.contains(resource));
                if (sdkModule.isFromHolderSdk) {
                    SdkProjectResourcesUtils.processSdkTargetResource((ResourceSdkDescriptor)resource, (SdkDescriptor)sdkModule.sdkDescriptor, null, (boolean)isResourceOveridden, (IProject)project, (SdkResourceProcessor)processor);
                    continue;
                }
                SdkProjectResourcesUtils.processSdkTargetResource((ResourceSdkDescriptor)resource, (SdkDescriptor)sdkModule.sdkDescriptor, (SdkDescriptor)this.sdk, (boolean)isResourceOveridden, (IProject)project, (SdkResourceProcessor)processor);
            }
        }
    }

    private void addResourceTo(int resourcesGroup, ResourceSdkDescriptor resource, SdkDescriptor sdkDescriptor, boolean isFromHolderSdk) {
        ResourceSdkKind kind = resource.getKind();
        boolean isDirectory = Path.fromOSString((String)resource.getPath()).toFile().isDirectory();
        if (kind.isFolderKind() && isDirectory || kind.isFileKind() && !isDirectory) {
            HolderModule holderModule = new HolderModule(sdkDescriptor, isFromHolderSdk);
            this.getResourcesTo(resourcesGroup).computeIfAbsent(holderModule, s -> new LinkedHashSet()).add(resource);
        }
    }

    private Map<HolderModule, Set<ResourceSdkDescriptor>> getResourcesTo(int resourcesGroup) {
        switch (resourcesGroup) {
            case 0: {
                return this.resourcesToCopy;
            }
            case 1: {
                return this.resourcesToMove;
            }
            case 2: {
                return this.resourcesToLink;
            }
        }
        return Collections.emptyMap();
    }

    private static class HolderModule {
        private SdkDescriptor sdkDescriptor;
        private boolean isFromHolderSdk;

        private HolderModule(SdkDescriptor sdkDescriptor, boolean isFromHolderSdk) {
            this.sdkDescriptor = Objects.requireNonNull(sdkDescriptor);
            this.isFromHolderSdk = isFromHolderSdk;
        }
    }
}

