/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkBasePathValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkEnvironmentValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkTargetFolderNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkVersionValidator;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.w3c.dom.Element;

public class SdkManifestHeaderValidator
implements IValidator<Element> {
    private String sdkId;

    public SdkManifestHeaderValidator(String sdkId) {
        this.sdkId = sdkId;
    }

    public IStatus validate(Element headerElement) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, null, null);
        String sdkName = headerElement.getAttribute("name");
        IStatus validateNameStatus = new SdkNameValidator().validate(sdkName);
        this.addErrorStatus(validateNameStatus, result);
        String sdkTargetFolderName = headerElement.getAttribute("targetFolderName");
        if (validateNameStatus.isOK() || !sdkName.equals(sdkTargetFolderName)) {
            this.addErrorStatus(new SdkTargetFolderNameValidator().validate(sdkTargetFolderName), result);
        }
        String sdkVersion = headerElement.getAttribute("version");
        this.addErrorStatus(new SdkVersionValidator().validate(sdkVersion), result);
        String basePathValidator = headerElement.getAttribute("basePath");
        IStatus validateBasePathStatus = new SdkBasePathValidator().validate(basePathValidator);
        this.addErrorStatus(validateBasePathStatus, result);
        EnvironmentSdkDescriptor sdkEnvironment = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)this.sdkId);
        if (sdkEnvironment != null && validateBasePathStatus.isOK()) {
            this.addErrorStatus(new SdkEnvironmentValidator().validate(sdkEnvironment), result);
        }
        return result;
    }

    private void addErrorStatus(IStatus status, MultiStatus result) {
        if (!status.isOK()) {
            if (status.isMultiStatus()) {
                result.addAll((IStatus)((MultiStatus)status));
            } else {
                result.add(status);
            }
        }
    }
}

