/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkEnvironmentNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import java.io.File;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class SdkEnvironmentValidator
implements IValidator<EnvironmentSdkDescriptor> {
    public IStatus validate(EnvironmentSdkDescriptor environment) {
        IStatus validateIsSystemStatus;
        MultiStatus validationStatuses = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, null, null);
        String name = environment.getName();
        validationStatuses.add(new SdkEnvironmentNameValidator().validate(name));
        IStatus validateValueStatus = this.validateValue(environment.getValue());
        if (!validateValueStatus.isOK()) {
            validationStatuses.add(validateValueStatus);
        }
        if (!(validateIsSystemStatus = SdkEnvironmentValidator.validateIsSystem(name, environment.isSystem())).isOK()) {
            validationStatuses.add(validateIsSystemStatus);
        }
        return validationStatuses;
    }

    private IStatus validateValue(String path) {
        if (path != null && !path.isEmpty()) {
            try {
                path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
            }
            catch (CoreException coreException) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.SdkEnvironmentValidator_error_path_not_exist, (Object)path));
            }
        }
        if (path != null && !path.isEmpty()) {
            File file = new File(path);
            if (!file.exists()) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.SdkEnvironmentValidator_error_path_not_exist, (Object)path));
            }
            if (!file.isDirectory()) {
                return ValidationStatus.error((String)NLS.bind((String)Messages.SdkEnvironmentValidator_error_path_not_folder, (Object)path));
            }
        } else {
            return ValidationStatus.error((String)Messages.SdkEnvironmentValidator_error_path_not_set);
        }
        return Status.OK_STATUS;
    }

    private static IStatus validateIsSystem(String name, boolean isSystem) {
        if (isSystem && System.getenv().get(name) == null) {
            return ValidationStatus.error((String)Messages.SdkEnvironmentValidator_error_system_variable_not_exist);
        }
        return Status.OK_STATUS;
    }
}

