/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.utils;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.action.SdkActionsHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachProcessor;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatusesHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.condition.ConditionsHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.ResourcesHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkDescriptorUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkEnvironmentUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkSmartFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.ProjectSdkDescriptor;
import com.nxp.s32ds.cle.ide.sdk.core.ProjectSdkDescriptors;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkDescriptorsRegitsrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.buildstep.BuildStepSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.hardware.HardwareSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.platform.PlatformSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.symbol.SymbolSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SdkManagementUtils {
    private SdkManagementUtils() {
    }

    public static boolean isSdkExists(String sdkId) {
        return SdkDescriptors.getSdkDescriptors().stream().anyMatch(sdk -> sdk.getId().equalsIgnoreCase(sdkId));
    }

    public static boolean isSdkExists(String name, String version) {
        return SdkDescriptors.getSdkDescriptors().stream().anyMatch(sdk -> sdk.getName().equalsIgnoreCase(name) && sdk.getVersion().equalsIgnoreCase(version));
    }

    public static void removeSdksByFilter(SdkFilter filter) {
        SdkDescriptors.getSdkDescriptors().stream().filter(arg_0 -> ((SdkFilter)filter).accept(arg_0)).forEach(SdkDescriptors::removeSdkDescriptor);
    }

    public static IStatus removeSdk(SdkDescriptor sdkDescriptor) {
        if (SdkManagementUtils.isSdkRemovable(sdkDescriptor)) {
            String sdkId = sdkDescriptor.getId();
            SdkAttachProcessor.detachSdkFromAllProjects(sdkDescriptor);
            SdkModulesHelper.getRefModulesSdksDescriptors(sdkId).stream().filter(refSdk -> Objects.nonNull(refSdk) && SdkType.INTERNAL == refSdk.getType()).forEach(SdkManagementUtils::removeSdk);
            ConditionsHolder.INSTANCE.unregisterConditions(sdkId);
            SdkActionsHandler.INSTANCE.unregisterSdkActions(sdkId);
            SdkEnvironmentUtils.removeEnvironment(sdkId);
            SdkDescriptorsRegitsrationHelper.unregisterSdkDescriptors((String)sdkId);
            SdkEnvironmentUtils.cleanEnvironments();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public static List<SdkDescriptor> getFilteredSdks(SdkFilter sdkFilter) {
        ArrayList<SdkDescriptor> filteredSdkDescriptors = new ArrayList<SdkDescriptor>();
        for (SdkDescriptor sdkDescriptor : SdkDescriptors.getSdkDescriptors()) {
            if (sdkFilter instanceof SdkSmartFilter && !((SdkSmartFilter)sdkFilter).acceptOptions(sdkDescriptor) || !sdkFilter.accept(sdkDescriptor)) continue;
            filteredSdkDescriptors.add(sdkDescriptor);
        }
        return filteredSdkDescriptors;
    }

    public static void refreshSdksAttachStates(IProject project) {
        Map<String, List<IStatus>> sdksAttachStates = SdkAttachStatusesHolder.INSTANCE.getActualSDKsAttachStatesCopy();
        LinkedHashMap<String, List<IStatus>> selectedSdksAttachStates = new LinkedHashMap<String, List<IStatus>>();
        SdkManagementUtils.getLocalAndWorkspaceSdks().stream().forEach(sdkDescriptor -> {
            List list = selectedSdksAttachStates.put(sdkDescriptor.getId(), (List)sdksAttachStates.get(sdkDescriptor.getId()));
        });
        SdkManagementUtils.updateSdksAttachStates(selectedSdksAttachStates, project, false);
    }

    public static void updateSdksAttachStates(Map<String, List<IStatus>> sdksAttachStates, IProject project, boolean isAttach) {
        for (String sdkId : sdksAttachStates.keySet()) {
            List<IStatus> actualStates = SdkAttachStatusesHolder.INSTANCE.getSDKAttachStates(SdkDescriptors.getSdkDescriptor((String)sdkId), project);
            if (isAttach && SdkManagementUtils.isSdkLocationMissing(actualStates)) {
                sdksAttachStates.put(sdkId, actualStates);
                SdkAttachStatusesHolder.INSTANCE.addSDKAttachStates(sdkId, actualStates);
                continue;
            }
            if (isAttach || !SdkManagementUtils.isSdkLocationMissing(actualStates) && SdkManagementUtils.isSdkValid(sdkId)) continue;
            SdkAttachStatusesHolder.INSTANCE.addSDKAttachStates(sdkId, actualStates);
        }
    }

    public static Map<String, List<SdkDescriptor>> getSdksGrouppedByTag(List<SdkDescriptor> sdksList) {
        HashMap<String, List<SdkDescriptor>> sdksGroupByTags = new HashMap<String, List<SdkDescriptor>>();
        for (SdkDescriptor sdk : sdksList) {
            sdk.getTags().stream().forEach(sdkTag -> {
                boolean bl = sdksGroupByTags.computeIfAbsent((String)sdkTag, s -> new ArrayList()).add(sdk);
            });
        }
        return sdksGroupByTags;
    }

    public static Map<String, List<SdkDescriptor>> getSdksGrouppedByTargetProjectTemplateId(List<SdkDescriptor> sdksList, SdkFilter filter) {
        HashMap<String, List<SdkDescriptor>> result = new HashMap<String, List<SdkDescriptor>>();
        for (SdkDescriptor sdk : sdksList) {
            List<SdkDescriptor> refSdks = SdkModulesHelper.getRefModulesSdksDescriptors(sdk.getId(), filter);
            if (!refSdks.isEmpty()) {
                SdkModulesHelper.getRefModulesSdksDescriptors(sdk.getId(), filter).forEach(refSdk -> {
                    boolean bl = result.computeIfAbsent(refSdk.getTargetProjectTemplate(), s -> new ArrayList()).add(refSdk);
                });
                continue;
            }
            result.computeIfAbsent(sdk.getTargetProjectTemplate(), s -> new ArrayList()).add(sdk);
        }
        return result;
    }

    public static Map<String, List<SdkDescriptor>> getSdksGrouppedByPlatformId(List<SdkDescriptor> sdksList) {
        HashMap<String, List<SdkDescriptor>> sdksGroupByPlatformId = new HashMap<String, List<SdkDescriptor>>();
        sdksList.forEach(sdk -> {
            boolean bl = sdksGroupByPlatformId.computeIfAbsent(sdk.getPlatformTarget(), s -> new ArrayList()).add(sdk);
        });
        return sdksGroupByPlatformId;
    }

    public static List<IProject> getAvailableProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (SdkManagementUtils.isProjectValid(project)) {
                    result.add(project);
                }
            }
            catch (CoreException ce) {
                SdkCoreActivator.getInstance().logError("Unable to retrive list of available projects", ce);
            }
            ++n2;
        }
        return result;
    }

    public static boolean isProjectValid(IProject project) throws CoreException {
        return project.isAccessible() && !"RemoteSystemsTempFiles".equals(project.getName()) && (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) && project.hasNature(ManagedCProjectNature.MNG_NATURE_ID);
    }

    public static boolean openResources(SdkDescriptor sdk, IProject project) {
        String defaultToolChainId = ProjectConfigurationUtils.getDefaultToolChainId((IProject)project);
        if (defaultToolChainId != null) {
            return ResourcesHandler.openTargetResources(sdk, project, defaultToolChainId);
        }
        return false;
    }

    public static IStatus deleteFolder(File folder) {
        if (!folder.isDirectory()) {
            return SdkCoreActivator.getInstance().createError(NLS.bind((String)"Unable to delete {0}: not a folder", (Object)folder));
        }
        final MultiStatus result = SdkCoreActivator.getInstance().createMultiStatus();
        Path folderPath = folder.toPath();
        try {
            Files.walkFileTree(folderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes ba) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException ioe) throws IOException {
                    result.add(SdkCoreActivator.getInstance().createError(NLS.bind((String)"Unable to delete {0}: error occured", (Object)path), ioe));
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
        catch (IOException ioe) {
            return SdkCoreActivator.getInstance().createError(NLS.bind((String)"Unable to delete {0}: error occured", (Object)folder), ioe);
        }
        return result.getChildren().length == 0 ? Status.OK_STATUS : result;
    }

    public static String getSdksManifestXml(InputStream stream) {
        StringBuilder sb = new StringBuilder();
        AtomicReference<StringBuilder> aref = new AtomicReference<StringBuilder>(sb);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    aref.get().append(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            SdkCoreActivator.getInstance().logError("Unable to read input stream", ioe);
        }
        return aref.get().toString();
    }

    public static String getSdkBriefInfo(SdkDescriptor sdkDescriptor) {
        return SdkManagementUtils.getSdkBriefInfo(sdkDescriptor, true);
    }

    public static String getSdkBriefInfo(SdkDescriptor sdk, boolean isShowType) {
        if (sdk == null) {
            return "";
        }
        String name = sdk.getName();
        String version = sdk.getVersion();
        if (!isShowType) {
            return NLS.bind((String)Messages.SdkManagementUtils_common_sdk_brief_info_name_version_template, (Object)name, (Object)version);
        }
        SdkType sdkType = sdk.getType();
        String typeName = sdkType.getName();
        if (SdkType.PROJECT_LOCAL == sdkType) {
            ProjectSdkDescriptor projectLocalSdk = ProjectSdkDescriptors.getProjectSdkDescriptorBySdkId((String)sdk.getId());
            String projectName = projectLocalSdk == null ? "?" : projectLocalSdk.getProjectName();
            return NLS.bind((String)Messages.SdkManagementUtils_project_sdk_brief_info_name_version_type_template, (Object[])new String[]{name, version, typeName, projectName});
        }
        return NLS.bind((String)Messages.SdkManagementUtils_common_sdk_brief_info_name_version_type_template, (Object[])new String[]{name, version, typeName});
    }

    public static Comparator<SdkDescriptor> getSdksComparator() {
        return (sdkDescriptor1, sdkDescriptor2) -> {
            SdkType sdk2Type;
            SdkType sdk1Type = sdkDescriptor1.getType();
            if (sdk1Type == (sdk2Type = sdkDescriptor2.getType())) {
                if (sdkDescriptor1.getName().equals(sdkDescriptor2.getName())) {
                    return sdkDescriptor1.getVersion().compareToIgnoreCase(sdkDescriptor2.getVersion());
                }
                return sdkDescriptor1.getName().compareToIgnoreCase(sdkDescriptor2.getName());
            }
            return sdk1Type.getName().compareTo(sdk2Type.getName());
        };
    }

    public static Set<String> getSdkHardwareIds(String sdkId, String hardwarePrarmeterId) {
        Map hws = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds((String)sdkId);
        SdkModulesHelper.getRefModulesSdksDescriptors(sdkId).stream().map(EntityDescriptor::getId).forEach(refSdkId -> {
            Map refHws = HardwareSdkDescriptors.getHardwareSdkDescriptorsIds((String)refSdkId);
            refHws.entrySet().forEach(e -> {
                boolean bl = hws.computeIfAbsent((String)e.getKey(), s -> new HashSet()).addAll((Collection)e.getValue());
            });
        });
        return new TreeSet<String>(hws.getOrDefault(hardwarePrarmeterId, Collections.emptySet()));
    }

    public static SdkDescriptor convertProjectLocalSdkToWorkspaceSdk(SdkDescriptor sdkDescriptor) {
        if (SdkType.PROJECT_LOCAL != sdkDescriptor.getType()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.SdkManagementUtils_error_illegal_convert_sdk_type, (Object)SdkType.PROJECT_LOCAL.getName()));
        }
        try {
            Element sdkElement = SdkDescriptorUtils.convertSdkDescriptorToXml(sdkDescriptor);
            SdkDescriptorsRegitsrationHelper.unregisterSdkDescriptors((String)sdkDescriptor.getId());
            SdkManagementUtils.clearFilterOptions(sdkElement);
            IStatus registerSdkStatus = SdkDescriptorsRegitsrationHelper.registerSdkDescriptors((Element)sdkElement, (SdkType)SdkType.WORKSPACE);
            if (!registerSdkStatus.isOK()) {
                SdkCoreActivator.getInstance().log(registerSdkStatus);
                return sdkDescriptor;
            }
            return SdkDescriptors.getSdkDescriptor((String)sdkDescriptor.getId());
        }
        catch (ParserConfigurationException | CoreException e) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.SdkManagementUtils_error_cannot_convert_sdk, (Object)SdkManagementUtils.getSdkBriefInfo(sdkDescriptor), (Object)SdkType.WORKSPACE.getName()), e);
            return sdkDescriptor;
        }
    }

    private static void clearFilterOptions(Element sdkElement) {
        sdkElement.removeAttribute("cores");
        sdkElement.removeAttribute("toolchains");
    }

    public static String getSdksString(SdkFilter sdkFilter) {
        return SdkManagementUtils.getSdksString(SdkManagementUtils.getFilteredSdks(sdkFilter));
    }

    public static String getOrderedSdksString(SdkFilter sdkFilter) {
        return SdkManagementUtils.getSdksString(SdkDescriptors.sortSdkListByDependency(SdkManagementUtils.getFilteredSdks(sdkFilter)));
    }

    public static String getSdksString(List<SdkDescriptor> sdkDescriptors) {
        if (sdkDescriptors.isEmpty()) {
            return "";
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            SdkManagementUtils.convertToXml(sdkDescriptors, document);
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(document), new StreamResult(baos));
                return baos.toString(StandardCharsets.UTF_8.name());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException | CoreException e) {
            SdkCoreActivator.getInstance().logError("Error while convering SDKs to xml", e);
            return "";
        }
    }

    public static boolean isPex(List<String> sdksIds) {
        return false;
    }

    public static Map<String, List<SdkDescriptor>> getSdksGroupByTags(List<String> sdksIds) {
        return SdkManagementUtils.getSdksGrouppedByTag(sdksIds.stream().map(SdkDescriptors::getSdkDescriptor).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static Map<String, List<SdkDescriptor>> getSdksTargetProjectTemplateIds(List<String> sdksIds, SdkFilter sdkFilter) {
        return SdkManagementUtils.getSdksGrouppedByTargetProjectTemplateId(sdksIds.stream().map(SdkDescriptors::getSdkDescriptor).filter(Objects::nonNull).collect(Collectors.toList()), sdkFilter);
    }

    public static Map<String, List<SdkDescriptor>> getSdksGroupByPlatformId(List<String> sdksIds) {
        return SdkManagementUtils.getSdksGrouppedByPlatformId(sdksIds.stream().map(SdkDescriptors::getSdkDescriptor).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static String performStringSubstitution(String path, String name) {
        try {
            path = SdkManagementUtils.substituteSystemVars(path, name, false);
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
        }
        catch (CoreException e) {
            SdkCoreActivator.getInstance().log(e.getStatus());
            return "";
        }
    }

    private static List<SdkDescriptor> getLocalAndWorkspaceSdks() {
        return SdkDescriptors.getSdkDescriptors().stream().filter(sdkDescriptor -> sdkDescriptor.getType() == SdkType.PROJECT_LOCAL || sdkDescriptor.getType() == SdkType.WORKSPACE).collect(Collectors.toList());
    }

    private static Element convertToXml(List<SdkDescriptor> sdkDescriptors, Document document) throws CoreException {
        Element sdksElement = document.createElement("sdks");
        document.appendChild(sdksElement);
        for (SdkDescriptor descriptor : sdkDescriptors) {
            Element sdkElement = descriptor.convertToXml(document, sdksElement);
            String sdkId = descriptor.getId();
            EnvironmentSdkDescriptors.convertToXml((String)sdkId, (Document)document, (Element)sdkElement);
            PlatformSdkDescriptors.convertToXml((String)sdkId, (Document)document, (Element)sdkElement);
            ToolChainSdkDescriptor rootToolChain = ToolChainSdkDescriptors.getRootToolChainSdkDescriptor((String)sdkId);
            String rootToolChainId = rootToolChain != null ? rootToolChain.getToolChainId() : "";
            SdkActionsHandler.INSTANCE.convertToXml(sdkId, null, document, sdkElement);
            ConditionsHolder.INSTANCE.convertToXml(sdkId, null, document, sdkElement);
            SymbolSdkDescriptors.convertToXml((String)sdkId, (String)rootToolChainId, (Document)document, (Element)sdkElement);
            ResourceSdkDescriptors.convertToXml((String)sdkId, (String)rootToolChainId, (Document)document, (Element)sdkElement);
            String sdkBasePath = descriptor.getBasePath();
            SdkDescriptorUtils.relativizeResourcesPath(sdkBasePath, sdkElement);
            ToolChainSdkDescriptors.convertToXml((String)sdkId, (Document)document, (Element)sdkElement);
            NodeList nl = sdkElement.getElementsByTagName("toolchain");
            int i = 0;
            while (i < nl.getLength()) {
                Element toolChainElement = (Element)nl.item(i);
                SdkDescriptorUtils.relativizeResourcesPath(descriptor.getBasePath(), toolChainElement);
                String toolChainId = toolChainElement.getAttribute("id").trim();
                SdkActionsHandler.INSTANCE.convertToXml(sdkId, toolChainId, document, toolChainElement);
                ConditionsHolder.INSTANCE.convertToXml(sdkId, toolChainId, document, toolChainElement);
                ++i;
            }
            ModuleSdkDescriptors.convertToXml((String)sdkId, (Document)document, (Element)sdkElement);
            BuildStepSdkDescriptors.convertToXml((String)sdkId, (Document)document, (Element)sdkElement);
        }
        return sdksElement;
    }

    public static String substituteSystemVars(String stringToSubstitute, String variableName, boolean doThrow) throws CoreException {
        String startVariable = "${";
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        int index = stringToSubstitute.indexOf(startVariable);
        while (index >= 0) {
            int m = stringToSubstitute.indexOf(125, index);
            if (m > 0) {
                String key = stringToSubstitute.substring(index + startVariable.length(), m);
                if (variableName != null && key.equals(variableName) || keys.contains(key)) {
                    SdkManagementUtils.handleVariableSubstitutionError(NLS.bind((String)"Recursive declaration for variable {0}", (Object)(variableName != null ? variableName : key)), true);
                }
                keys.add(key);
                String txt = String.valueOf(startVariable) + key + '}';
                String val = System.getenv().get(key);
                if (val == null) {
                    IStringVariable[] iStringVariableArray = VariablesPlugin.getDefault().getStringVariableManager().getVariables();
                    int n = iStringVariableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStringVariable v = iStringVariableArray[n2];
                        if (v.getName().equals(key)) {
                            if (v instanceof IDynamicVariable) {
                                try {
                                    val = ((IDynamicVariable)v).getValue(null);
                                }
                                catch (CoreException e) {
                                    SdkCoreActivator.getInstance().logError("", e);
                                }
                                break;
                            }
                            if (v instanceof IValueVariable) {
                                val = ((IValueVariable)v).getValue();
                                break;
                            }
                            val = v.getName();
                            break;
                        }
                        ++n2;
                    }
                }
                if (val != null) {
                    stringToSubstitute = stringToSubstitute.replace(txt, val);
                } else {
                    SdkManagementUtils.handleVariableSubstitutionError(NLS.bind((String)"Reference to undefined variable: {0}", (Object)key), doThrow);
                    index += txt.length();
                }
            } else {
                SdkManagementUtils.handleVariableSubstitutionError(NLS.bind((String)"Incorrect syntax in variable reference: {0}", (Object)stringToSubstitute), doThrow);
                break;
            }
            index = stringToSubstitute.indexOf(startVariable, index);
        }
        return stringToSubstitute;
    }

    private static void handleVariableSubstitutionError(String errorMessage, boolean doThrow) throws CoreException {
        IStatus errorStatus = SdkCoreActivator.getInstance().createError(errorMessage);
        SdkCoreActivator.getInstance().log(errorStatus);
        if (doThrow) {
            throw new CoreException(errorStatus);
        }
    }

    private static boolean isSdkRemovable(SdkDescriptor sdkDescriptor) {
        SdkType type = sdkDescriptor.getType();
        return SdkType.WORKSPACE == type || SdkType.PROJECT_LOCAL == type || SdkType.IMPORTED == type || SdkType.EXTERNAL == type || SdkType.INTERNAL == type;
    }

    private static boolean isSdkLocationMissing(List<IStatus> actualStates) {
        return actualStates != null && !actualStates.isEmpty() && SdkAttachStatuses.ERROR_SDK_LOCATION.equals(actualStates.get(0));
    }

    private static boolean isSdkValid(String sdkId) {
        return SdkAttachStatusesHolder.INSTANCE.isSdkAttachable(SdkDescriptors.getSdkDescriptor((String)sdkId));
    }
}

