/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.utils;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.environment.SdkEnvironmentVariableChangeListener;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.IValueVariableListener;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class SdkEnvironmentUtils {
    private static final String PATH_SUFIX = "_PATH";
    public static final String NONE = "-NONE-";

    private SdkEnvironmentUtils() {
    }

    public static String getEnvironment(SdkDescriptor sdkDescriptor) {
        return SdkEnvironmentUtils.getEnvironmentValue(sdkDescriptor.getId().toUpperCase(), false);
    }

    public static String getEnvironment(String sdkName, String sdkVersion) {
        return SdkEnvironmentUtils.getEnvironmentValue(SdkEnvironmentUtils.getEnviromnentName(sdkName, sdkVersion), false);
    }

    public static String getEnvironmentValue(String name, boolean isSystem) {
        if (isSystem) {
            return System.getenv(name);
        }
        IValueVariable valueVariable = VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name);
        return valueVariable != null ? valueVariable.getValue() : NONE;
    }

    public static void createEnvironment(SdkDescriptor sdkDescriptor) {
        String sdkId = sdkDescriptor.getId();
        EnvironmentSdkDescriptor envSdkDescriptor = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkId);
        if (envSdkDescriptor != null) {
            String name = SdkEnvironmentUtils.getEnviromnentName(sdkDescriptor.getName(), sdkDescriptor.getVersion());
            SdkEnvironmentUtils.createEnvironment(name, sdkDescriptor.getBasePath(), sdkDescriptor.getDescription(), envSdkDescriptor.isSystem(), true);
        }
    }

    public static String getEnviromnentName(String sdkName, String sdkVersion) {
        return (String.valueOf(sdkName) + "_" + sdkVersion + PATH_SUFIX).toUpperCase();
    }

    public static void createEnvironment(String name, String value, String description, boolean isSystem, boolean isReadOnly) {
        IValueVariable valueVariable = VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name);
        if (valueVariable != null) {
            if (valueVariable.isReadOnly() != isReadOnly) {
                SdkEnvironmentUtils.removeEnvironment(name, isSystem);
                SdkEnvironmentUtils.addEnvironment(name, value, description, isReadOnly);
            } else {
                valueVariable.setValue(value);
            }
        } else {
            SdkEnvironmentUtils.addEnvironment(name, value, description, isReadOnly);
        }
        try {
            SdkEnvironmentUtils.setupPathVariable(name, value);
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError("Unable to setup environment variable", ce);
        }
    }

    public static void removeEnvironment(String sdkId) {
        EnvironmentSdkDescriptor envSdkDescriptor = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkId);
        if (envSdkDescriptor != null) {
            SdkEnvironmentUtils.removeEnvironment(envSdkDescriptor.getName(), envSdkDescriptor.isSystem());
        }
    }

    public static void createSdkSuffixEnvironment(Map<String, String> pathSuffixes, boolean isSystem, boolean isReadOnly) {
        for (Map.Entry<String, String> pathSuffix : pathSuffixes.entrySet()) {
            SdkEnvironmentUtils.createEnvironment(pathSuffix.getKey(), pathSuffix.getValue(), pathSuffix.getKey(), isSystem, isReadOnly);
        }
    }

    public static void removeEnvironment(String name, boolean isSystem) {
        if (isSystem) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Environment variable {0} cannot be removed", (Object)name));
            return;
        }
        IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        SdkEnvironmentVariableChangeListener sdkEnvironmentVariableChangeListener = SdkCoreActivator.getInstance().getSdkEnvironmentVariableChangeListener();
        stringVariableManager.removeValueVariableListener((IValueVariableListener)sdkEnvironmentVariableChangeListener);
        IValueVariable valueVariable = stringVariableManager.getValueVariable(name);
        if (valueVariable != null) {
            stringVariableManager.removeVariables(new IValueVariable[]{valueVariable});
        }
        stringVariableManager.addValueVariableListener((IValueVariableListener)sdkEnvironmentVariableChangeListener);
    }

    public static boolean isEnvironmentExists(String name, boolean isSystem) {
        return (isSystem ? System.getenv(name) : VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name)) != null;
    }

    public static String makePathVariableName(String envName) {
        return envName.replace(' ', '_').replace('.', '_');
    }

    public static void cleanEnvironments() {
        Set<String> usedEnvironments = SdkEnvironmentUtils.collectUsedEnvironments();
        IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        ArrayList<IValueVariable> toDelete = new ArrayList<IValueVariable>();
        IValueVariable[] iValueVariableArray = stringVariableManager.getValueVariables();
        int n = iValueVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IValueVariable valueVariable = iValueVariableArray[n2];
            if (!valueVariable.isContributed()) {
                EnvironmentSdkDescriptor envSdkDescriptor;
                String name = valueVariable.getName();
                if (!usedEnvironments.contains(valueVariable.getName()) && name.endsWith(PATH_SUFIX) && (envSdkDescriptor = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorByName((String)valueVariable.getName())) != null) {
                    SdkCoreActivator.getInstance().logInfo(NLS.bind((String)"Removing Environment {0}={1}", (Object)name, (Object)valueVariable.getValue()));
                    EnvironmentSdkDescriptors.removeEnvironmentSdkDescriptor((EnvironmentSdkDescriptor)envSdkDescriptor);
                    toDelete.add(valueVariable);
                }
            }
            ++n2;
        }
        stringVariableManager.removeVariables(toDelete.toArray(new IValueVariable[toDelete.size()]));
    }

    private static Set<String> collectUsedEnvironments() {
        TreeSet<String> usedEnvironments = new TreeSet<String>();
        for (SdkDescriptor sdkDescriptor : SdkDescriptors.getSdkDescriptors()) {
            String sdkId = sdkDescriptor.getId();
            EnvironmentSdkDescriptor environmentSdkDescriptor = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkId);
            if (environmentSdkDescriptor == null) {
                SdkCoreActivator.getInstance().logError(String.format("Corrupted SDK: %s - no ENV var !", sdkId));
                continue;
            }
            if (environmentSdkDescriptor.isSystem()) continue;
            String environmentSdkDescriptorName = environmentSdkDescriptor.getName();
            if (usedEnvironments.contains(environmentSdkDescriptorName)) {
                SdkCoreActivator.getInstance().logError(NLS.bind((String)"Duplicated environment with name {0}.", (Object)environmentSdkDescriptorName));
                continue;
            }
            usedEnvironments.add(environmentSdkDescriptorName);
        }
        return usedEnvironments;
    }

    private static void setupPathVariable(String name, String value) throws CoreException {
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        if (pathVariableManager.getURIValue(name) != null) {
            return;
        }
        String substitutedValue = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
        URI resolvedURI = pathVariableManager.resolveURI(URIUtil.toURI((String)substitutedValue));
        if (resolvedURI.toString().isEmpty() || NONE.endsWith(resolvedURI.toString())) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unresolved variable {0}", (Object)name));
        } else {
            try {
                pathVariableManager.setURIValue(SdkEnvironmentUtils.makePathVariableName(name), resolvedURI);
            }
            catch (CoreException ce) {
                SdkCoreActivator.getInstance().logError("Unable to setup environment variable", ce);
            }
        }
    }

    private static void addEnvironment(String name, String value, String description, boolean readOnly) {
        String existingValue;
        IStringVariableManager stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        IValueVariable existingValueVariable = stringVariableManager.getValueVariable(name);
        if (existingValueVariable != null && (existingValue = existingValueVariable.getValue()) != null && existingValue.equals(value)) {
            return;
        }
        IValueVariable valueVariable = stringVariableManager.newValueVariable(name, description, readOnly, value);
        try {
            stringVariableManager.addVariables(new IValueVariable[]{valueVariable});
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError("Unable to add value to environment variable", ce);
        }
    }
}

