/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.symbol;

import com.nxp.s32ds.cle.cdt.sdk.core.module.SdkModulesHelper;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.symbol.SymbolSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;

public class SdkSymbolsHelper {
    private SdkSymbolsHelper() {
    }

    public static List<String> getSymbolsNames(SdkDescriptor sdkDescriptor, SdkFilter filter, SymbolSdkKind type, String langId, IConfiguration configuration) {
        ArrayList<String> symbolNames = new ArrayList<String>();
        String sdkId = sdkDescriptor.getId();
        List<SdkDescriptor> refModuleSdks = SdkModulesHelper.getRefModulesSdksDescriptors(sdkId, filter);
        if (!refModuleSdks.isEmpty()) {
            for (SdkDescriptor refModuleSdk : refModuleSdks) {
                symbolNames.addAll(SdkSymbolsHelper.getSymbolsNames(refModuleSdk, filter, type, langId, configuration));
            }
            return symbolNames;
        }
        return SymbolSdkDescriptors.getSymbolSdkDescriptorsBySdkId((String)sdkId).stream().filter(symbol -> type == symbol.getKind() && SdkSymbolsHelper.isAppliedForConfiguration(symbol, configuration) && symbol.getLangId().equals(langId)).map(SymbolSdkDescriptor::getName).collect(Collectors.toList());
    }

    private static boolean isAppliedForConfiguration(SymbolSdkDescriptor symbol, IConfiguration configuration) {
        Set relatedConfigurations = symbol.getConfigurations();
        return relatedConfigurations == null || relatedConfigurations.isEmpty() || configuration == null || relatedConfigurations.contains(configuration.getBaseId()) || relatedConfigurations.contains(configuration.getName());
    }
}

