/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.checkers;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.ext.cdt.core.checker.IResourceChecker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkProjectPreferencesChecker
implements IResourceChecker {
    private static final String NEW_SDK_PROJECT_PREFERENCES_FILE_PATH = "/.settings/com.nxp.s32ds.cle.runtime.sdk.prefs";
    private static final String OLD_SDK_PROJECT_PREFERENCES_FILE_PATH = "/.settings/com.freescale.s32ds.cross.sdk.support.prefs";

    public IStatus check(IResource resource, IProgressMonitor monitor) {
        if (!(resource instanceof IProject)) {
            return Status.OK_STATUS;
        }
        IProject project = (IProject)resource;
        IResource newProjectSettings = project.findMember(NEW_SDK_PROJECT_PREFERENCES_FILE_PATH);
        if (newProjectSettings != null) {
            return Status.OK_STATUS;
        }
        IResource oldProjectSettings = project.findMember(OLD_SDK_PROJECT_PREFERENCES_FILE_PATH);
        if (oldProjectSettings == null) {
            return Status.CANCEL_STATUS;
        }
        try {
            oldProjectSettings.move(project.getFile(NEW_SDK_PROJECT_PREFERENCES_FILE_PATH).getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            SdkAttachDataHelper.checkStatusOfSdksAttachedToProject(project);
        }
        catch (CoreException ce) {
            IStatus errorStatus = SdkCoreActivator.getInstance().createError(NLS.bind((String)"Unable to rename file {0} to {1} due to error.", (Object)OLD_SDK_PROJECT_PREFERENCES_FILE_PATH, (Object)NEW_SDK_PROJECT_PREFERENCES_FILE_PATH), ce);
            SdkCoreActivator.getInstance().log(errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }
}

