/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.SettingsUpdateData;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.OptionUpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.UpdateStatus;
import com.nxp.s32ds.cle.cdt.project.configuration.internal.core.updaters.OptionUpdater;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachProjectOptionUpdateOperationData;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.attach.SdkAttachProjectOptionUpdateOperationDataHelper;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.buildstep.BuildStepSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.buildstep.BuildStepSdkDescriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkProjectConfigurationUpdater {
    private static List<SdkProjectConfigurationUpdater> updaters = null;
    private static ProjectSettingsUpdater optionUpdater;
    private static ProjectSettingsUpdater preBuildStepsUpdater;
    private static ProjectSettingsUpdater postBuildStepsUpdater;
    private Identifier identifier;
    private String[] toolChainsIds;
    private List<SdkAttachProjectOptionUpdateOperationData> sdkProjectOptionUpdateOperationsData = new ArrayList<SdkAttachProjectOptionUpdateOperationData>();

    private static synchronized List<SdkProjectConfigurationUpdater> getUpdaters() {
        optionUpdater = ProjectSettingsUpdaters.getOptionUpdater();
        preBuildStepsUpdater = ProjectSettingsUpdaters.getPreBuildStepUpdater();
        postBuildStepsUpdater = ProjectSettingsUpdaters.getPostBuildStepUpdater();
        if (updaters == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.nxp.s32ds.cle.cdt.sdk.core.updater");
            updaters = extensionPoint == null ? Collections.emptyList() : new ArrayList(Arrays.stream(extensionPoint.getExtensions()).flatMap(extension -> Arrays.stream(extension.getConfigurationElements())).filter(configElement -> "updater".equals(configElement.getName())).map(SdkProjectConfigurationUpdater::new).filter(SdkProjectConfigurationUpdater::isValid).collect(Collectors.toMap(p -> p.identifier.toString(), Function.identity())).values());
        }
        return updaters != null ? Collections.unmodifiableList(updaters) : Collections.emptyList();
    }

    private SdkProjectConfigurationUpdater(IConfigurationElement ce) {
        this.identifier = new Identifier(ce.getAttribute("name"), ce.getDeclaringExtension().getContributor().getName());
        this.initSdkResourcesCollectors(ce);
        this.initRelatedToolChainsIds(ce);
    }

    private void initSdkResourcesCollectors(IConfigurationElement ce) {
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("comInclude", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("cppInclude", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("asmInclude", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("comIncludeFiles", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("cppIncludeFiles", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("linkLib", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("linkPath", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("linkLD", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("comDefine", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("cppDefine", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("asmDefine", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("comUndefine", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("cppUndefine", ce));
        this.sdkProjectOptionUpdateOperationsData.add(SdkAttachProjectOptionUpdateOperationDataHelper.create("asmUndefine", ce));
    }

    private void initRelatedToolChainsIds(IConfigurationElement ce) {
        String toolChainsAttributeValue = ce.getAttribute("toolchains");
        this.toolChainsIds = toolChainsAttributeValue == null || toolChainsAttributeValue.trim().isEmpty() ? new String[0] : (String[])Arrays.stream(toolChainsAttributeValue.split(",")).filter(Objects::nonNull).map(String::trim).filter(tc -> !tc.isEmpty()).toArray(String[]::new);
    }

    private boolean isValid() {
        return this.toolChainsIds.length > 0 && this.sdkProjectOptionUpdateOperationsData.stream().anyMatch(c -> !c.isDummy());
    }

    private boolean accept(IToolChain toolChain) {
        String[] stringArray = this.toolChainsIds;
        int n = this.toolChainsIds.length;
        int n2 = 0;
        while (n2 < n) {
            String toolChainId = stringArray[n2];
            IToolChain tmpToolChain = toolChain;
            while (tmpToolChain != null) {
                if (toolChainId.equalsIgnoreCase(tmpToolChain.getId()) || toolChainId.equalsIgnoreCase(tmpToolChain.getBaseId())) {
                    return true;
                }
                tmpToolChain = tmpToolChain.getSuperClass();
            }
            ++n2;
        }
        return false;
    }

    private boolean update(IProject project, IConfiguration configuration, SdkDescriptor sdkDescriptor, boolean remove, MultiStatus result) {
        ProjectCompatibleSdksFilter filter = new ProjectCompatibleSdksFilter(project);
        UpdateOperation operation = remove ? UpdateOperation.REMOVE : UpdateOperation.ADD;
        Set<SettingsUpdateData> optionsUpdateData = this.prepareOptionsUpdateData(configuration, sdkDescriptor, (SdkFilter)filter, operation);
        result.addAll(optionUpdater.update(configuration, optionsUpdateData));
        SdkProjectConfigurationUpdater.updateBuildSteps(configuration, sdkDescriptor, operation);
        return true;
    }

    private boolean restore(IProject project, IConfiguration configuration, SdkDescriptor sdkDescriptor, Set<UpdateStatus> sdkAttachUpdateStatuses, MultiStatus result) {
        ProjectCompatibleSdksFilter filter = new ProjectCompatibleSdksFilter(project);
        Set<SettingsUpdateData> optionsUpdateData = this.prepareOptionsUpdateData(configuration, sdkDescriptor, (SdkFilter)filter, UpdateOperation.REMOVE);
        SdkProjectConfigurationUpdater.filterOutSkippedValues(optionsUpdateData, sdkAttachUpdateStatuses);
        result.addAll(optionUpdater.update(configuration, optionsUpdateData));
        SdkProjectConfigurationUpdater.updateBuildSteps(configuration, sdkDescriptor, UpdateOperation.REMOVE);
        return true;
    }

    private static void filterOutSkippedValues(Set<SettingsUpdateData> optionsUpdateData, Set<UpdateStatus> sdkAttachUpdateStatuses) {
        if (sdkAttachUpdateStatuses == null || sdkAttachUpdateStatuses.isEmpty()) {
            return;
        }
        for (SettingsUpdateData optionUpdateData : optionsUpdateData) {
            String optionId = optionUpdateData.getName();
            if (optionId == null) continue;
            sdkAttachUpdateStatuses.stream().filter(updateStatus -> updateStatus instanceof OptionUpdateStatus).map(updateStatus -> (OptionUpdateStatus)updateStatus).filter(updateStatus -> updateStatus.getOptionId().matches(optionId)).map(UpdateStatus::getSkippedValues).filter(skippedValues -> skippedValues != null && !skippedValues.isEmpty()).forEach(optionUpdateData.getValues()::removeAll);
        }
    }

    private Set<SettingsUpdateData> prepareOptionsUpdateData(IConfiguration configuration, SdkDescriptor sdk, SdkFilter filter, UpdateOperation operation) {
        LinkedHashSet<SettingsUpdateData> optionsUpdateData = new LinkedHashSet<SettingsUpdateData>();
        this.sdkProjectOptionUpdateOperationsData.stream().filter(data -> !data.isDummy()).map(data -> data.getOptionUpdateOperationData(sdk, filter, configuration, operation)).forEach(optionUpdateData -> SdkProjectConfigurationUpdater.addOptionUpdateOperation(optionUpdateData, operation, optionsUpdateData));
        return optionsUpdateData;
    }

    private boolean cleanup(IConfiguration configuration, String sdkId, MultiStatus result) {
        LinkedHashSet optionsUpdateData = new LinkedHashSet();
        SdkOptionsCleaner optionsCleaner = new SdkOptionsCleaner();
        this.sdkProjectOptionUpdateOperationsData.stream().filter(data -> !data.isDummy()).forEach(data -> {
            boolean bl = optionsUpdateData.addAll(data.getOptionUpdateOperationDataForCleanup(sdkId));
        });
        result.addAll(optionsCleaner.update(configuration, optionsUpdateData));
        return true;
    }

    private static void addOptionUpdateOperation(SettingsUpdateData optionUpdateData, UpdateOperation operation, Set<SettingsUpdateData> optionsUpdateData) {
        if (operation.isEmptyValuesAllowed() || !optionUpdateData.getValues().isEmpty()) {
            optionsUpdateData.add(optionUpdateData);
        }
    }

    private static void updateBuildSteps(IConfiguration cfg, SdkDescriptor sdkDescriptor, UpdateOperation operation) {
        if (sdkDescriptor != null) {
            List buildSteps = BuildStepSdkDescriptors.getBuildStepSdkDescriptorsBySdkId((String)sdkDescriptor.getId());
            buildSteps.stream().filter(BuildStepSdkDescriptor::isPreBuildStep).forEach(pbs -> {
                IStatus iStatus = preBuildStepsUpdater.update(cfg, pbs.getCommand(), pbs.getDescription(), operation);
            });
            buildSteps.stream().filter(buildStep -> !buildStep.isPreBuildStep()).forEach(pbs -> {
                IStatus iStatus = postBuildStepsUpdater.update(cfg, pbs.getCommand(), pbs.getDescription(), operation);
            });
        }
    }

    private static boolean validateParameters(IConfiguration configuration, SdkDescriptor sdk) {
        if (configuration == null || sdk == null) {
            SdkCoreActivator.getInstance().logError("Unable to start project updater: invalid parameters passed.");
            return false;
        }
        return true;
    }

    private static IStatus handleUpdateResult(List<Identifier> usedUpdaters, String projectName, String configuration, SdkDescriptor sdk, boolean isRemove, MultiStatus result) {
        String sdkIdentifier = NLS.bind((String)"{0} v {1}", (Object)sdk.getName(), (Object)sdk.getVersion());
        String operation = NLS.bind((String)"{0} SDK {1}", (Object)(isRemove ? "DETACH" : "ATTACH"), (Object)sdkIdentifier);
        String updateInfo = NLS.bind((String)"{0}, config. {1}", (Object)projectName, (Object)configuration);
        IStatus status = usedUpdaters.isEmpty() ? SdkCoreActivator.getInstance().createError(NLS.bind((String)"{0}: no project updaters found for project {1}.", (Object)operation, (Object)updateInfo)) : (usedUpdaters.size() > 1 ? SdkCoreActivator.getInstance().createWarning(NLS.bind((String)"{0}: more than one project updater found for project {1}.", (Object)operation, (Object)updateInfo)) : SdkCoreActivator.getInstance().createStatus(0, NLS.bind((String)"{0}: project {1} was successfully updated by project updater {2}.", (Object[])new String[]{operation, updateInfo, usedUpdaters.get(0).toString()})));
        SdkCoreActivator.getInstance().log(status);
        result.add(status);
        return result;
    }

    public static IStatus updateOptions(IConfiguration configuration, SdkDescriptor sdkDescriptor, boolean isRemove) {
        if (SdkProjectConfigurationUpdater.validateParameters(configuration, sdkDescriptor)) {
            MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, null, null);
            IProject project = configuration.getOwner().getProject();
            IToolChain toolChain = configuration.getToolChain();
            ArrayList<Identifier> usedUpdaters = new ArrayList<Identifier>();
            SdkProjectConfigurationUpdater.getUpdaters().stream().filter(updater -> updater.accept(toolChain)).forEach(updater -> {
                updater.update(project, configuration, sdkDescriptor, isRemove, result);
                usedUpdaters.add(updater.identifier);
            });
            return SdkProjectConfigurationUpdater.handleUpdateResult(usedUpdaters, project.getName(), configuration.getName(), sdkDescriptor, isRemove, result);
        }
        return Status.CANCEL_STATUS;
    }

    public static IStatus restoreOptions(IConfiguration configuration, SdkDescriptor sdkDescriptor, Set<UpdateStatus> sdkAttachUpdateStatuses) {
        if (SdkProjectConfigurationUpdater.validateParameters(configuration, sdkDescriptor)) {
            MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, null, null);
            IProject project = configuration.getOwner().getProject();
            IToolChain toolChain = configuration.getToolChain();
            ArrayList<Identifier> usedUpdaters = new ArrayList<Identifier>();
            SdkProjectConfigurationUpdater.getUpdaters().stream().filter(updater -> updater.accept(toolChain)).forEach(updater -> {
                updater.restore(project, configuration, sdkDescriptor, sdkAttachUpdateStatuses, result);
                usedUpdaters.add(updater.identifier);
            });
            return SdkProjectConfigurationUpdater.handleUpdateResult(usedUpdaters, project.getName(), configuration.getName(), sdkDescriptor, true, result);
        }
        return Status.CANCEL_STATUS;
    }

    public static IStatus cleanupOptions(IConfiguration configuration, SdkDescriptor sdkDescriptor) {
        if (SdkProjectConfigurationUpdater.validateParameters(configuration, sdkDescriptor)) {
            MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, null, null);
            IProject project = configuration.getOwner().getProject();
            IToolChain toolChain = configuration.getToolChain();
            ArrayList<Identifier> usedUpdaters = new ArrayList<Identifier>();
            SdkProjectConfigurationUpdater.getUpdaters().stream().filter(updater -> updater.accept(toolChain)).forEach(updater -> {
                updater.cleanup(configuration, sdkDescriptor.getId(), result);
                usedUpdaters.add(updater.identifier);
            });
            return SdkProjectConfigurationUpdater.handleUpdateResult(usedUpdaters, project.getName(), configuration.getName(), sdkDescriptor, true, result);
        }
        return Status.CANCEL_STATUS;
    }

    private static class Identifier {
        private final String name;
        private final String contributor;

        private Identifier(String name, String contributor) {
            this.name = Objects.requireNonNull(name);
            this.contributor = Objects.requireNonNull(contributor);
        }

        public String toString() {
            return NLS.bind((String)"{0} [{1}]", (Object)this.name, (Object)this.contributor);
        }
    }

    private static class SdkOptionsCleaner
    extends OptionUpdater {
        private SdkOptionsCleaner() {
        }

        protected void removeOptionValues(Set<String> currentOptionValues, List<String> optionValues) {
            String optionValuesMask;
            if (optionValues != null && !optionValues.isEmpty() && (optionValuesMask = optionValues.get(0)) != null && !optionValuesMask.isEmpty()) {
                currentOptionValues.removeIf(cov -> cov.contains(optionValuesMask));
            }
        }
    }
}

