/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.attach;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SdkAttachListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (32 != event.getType()) {
            return;
        }
        IResource resource = event.getResource();
        if (!(resource instanceof IProject)) {
            return;
        }
        IProject project = (IProject)resource;
        if (!project.isAccessible() || !SdkAttachDataHolder.hasProjectAttachedSdks(project.getName())) {
            return;
        }
        SdkAttachListener.validateSdkAttach(project);
    }

    private static void validateSdkAttach(final IProject project) {
        WorkspaceJob wj = new WorkspaceJob("Validate SDK(s) attach statuses"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SdkAttachDataHelper.checkStatusOfSdksAttachedToProject(project);
                return Status.OK_STATUS;
            }
        };
        wj.schedule();
    }
}

