/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.view;

import com.nxp.swtools.bootimage.settings.ImageSegment;
import com.nxp.swtools.bootimage.utils.BinaryTablePreview;
import com.nxp.swtools.bootimage.utils.ColorAndTooltip;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.sources.ISWToolsSourceViewerFactory;
import com.nxp.swtools.utils.swt.dialogs.ExportCodePreviewDialog;
import com.nxp.swtools.utils.swt.dialogs.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javafx.collections.ObservableList;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class BootCodePreviewDialog
extends ExportCodePreviewDialog {
    @Nullable
    protected Control tableViewCanvas = null;
    private @NonNull List<@NonNull ImageSegment> segments;
    protected static final Map<String, Color> segColorMap = new HashMap<String, Color>();
    protected ScrolledComposite codeViewerComposite;

    protected BootCodePreviewDialog(@NonNull Shell parent) {
        super(parent);
        this.codeViewerComposite = new ScrolledComposite((Composite)parent, 768);
        this.segments = this.getSegmentsList();
        this.createSegmentColorScheme();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setData("boot-id", (Object)Boolean.TRUE);
    }

    private NavigableMap<Integer, ColorAndTooltip> getColorAndTooltipMap() {
        int addr = 1;
        TreeMap<Integer, ColorAndTooltip> colorAndTooltipMap = new TreeMap<Integer, ColorAndTooltip>();
        for (ImageSegment imageSegment : this.segments) {
            String segName = imageSegment.getName().contains("reserved") ? "reserved" : (imageSegment.getName().contains("image_header") ? "image_header" : imageSegment.getName().toLowerCase());
            ColorAndTooltip colorAndTooltipForSegment = new ColorAndTooltip(imageSegment.getName(), segColorMap.get(segName));
            colorAndTooltipMap.put(addr, colorAndTooltipForSegment);
            addr += imageSegment.getSize();
        }
        return colorAndTooltipMap;
    }

    protected FXCanvas createTableViewCanvas(Composite parent, TableView<ObservableList<String>> tableView) {
        FXCanvas canvas = new FXCanvas((Composite)this.codeViewerComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(10, 1).applyTo((Control)canvas);
        BorderPane layout = new BorderPane();
        Scene scene = new Scene((Parent)layout, (Paint)Color.rgb((int)parent.getShell().getBackground().getRed(), (int)parent.getShell().getBackground().getGreen(), (int)parent.getShell().getBackground().getBlue()));
        canvas.setScene(scene);
        layout.setCenter(tableView);
        return canvas;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = super.createDialogAreaControl(parent);
        Composite dialogComposite = new Composite(parentComposite, 0);
        dialogComposite.setLayout((Layout)new GridLayout(2, false));
        dialogComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Group formatGroup = new Group(dialogComposite, 0);
        formatGroup.setText(Messages.SupportedFormats);
        formatGroup.setLayout((Layout)new GridLayout(1, false));
        formatGroup.setLayoutData((Object)new GridData(4, 4, false, true));
        ScrolledComposite formatGroupComposite = new ScrolledComposite((Composite)formatGroup, 768);
        formatGroupComposite.setLayout((Layout)new GridLayout(1, false));
        formatGroupComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final org.eclipse.swt.widgets.List formatList = new org.eclipse.swt.widgets.List((Composite)formatGroupComposite, 2048);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)formatList, "ExportCodePreviewFormatList");
        formatList.setLayoutData((Object)new GridData(4, 4, true, true));
        formatList.add(Messages.CFormat);
        formatList.add(Messages.BinaryFormat);
        formatList.select(0);
        formatGroupComposite.setContent((Control)formatList);
        formatGroupComposite.setExpandHorizontal(true);
        formatGroupComposite.setExpandVertical(true);
        formatGroupComposite.setMinSize(formatList.computeSize(-1, -1));
        this.codeViewerComposite = new ScrolledComposite(dialogComposite, 768);
        this.codeViewerComposite.setLayout((Layout)new GridLayout(1, false));
        this.codeViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setSelectedFormat(UtilsText.safeString((String)formatList.getItem(0)));
        assert (this.codeViewerComposite != null);
        final ISWToolsSourceViewerFactory.ISWToolsSourceViewer codeViewer = this.checkListSelection(formatList, (Composite)this.codeViewerComposite);
        BinaryTablePreview binaryTablePreview = new BinaryTablePreview();
        this.tableViewCanvas = this.createTableViewCanvas(parent, binaryTablePreview.createTableView(this.formatBinaryCode(), "export_binary_table_id", 16, this.getColorAndTooltipMap()));
        formatList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                BootCodePreviewDialog.this.setSelectedFormat(UtilsText.safeString((String)formatList.getItem(formatList.getSelectionIndex())));
                if (UtilsText.safeString((String)formatList.getItem(formatList.getSelectionIndex())).equals(Messages.CFormat)) {
                    BootCodePreviewDialog.this.codeViewerComposite.setContent(codeViewer.getControl());
                } else {
                    BootCodePreviewDialog.this.codeViewerComposite.setContent(BootCodePreviewDialog.this.tableViewCanvas);
                }
            }

            public void widgetDefaultSelected(@Nullable SelectionEvent e) {
                BootCodePreviewDialog.this.setSelectedFormat(UtilsText.safeString((String)formatList.getItem(formatList.getSelectionIndex())));
                if (UtilsText.safeString((String)formatList.getItem(formatList.getSelectionIndex())).equals(Messages.CFormat)) {
                    BootCodePreviewDialog.this.codeViewerComposite.setContent(codeViewer.getControl());
                } else {
                    BootCodePreviewDialog.this.codeViewerComposite.setContent(BootCodePreviewDialog.this.tableViewCanvas);
                }
            }
        });
        this.codeViewerComposite.setContent(codeViewer.getControl());
        this.codeViewerComposite.setExpandHorizontal(true);
        this.codeViewerComposite.setExpandVertical(true);
        this.codeViewerComposite.setMinSize(formatList.computeSize(-1, -1));
        parentComposite.layout(true);
        return parentComposite;
    }

    protected abstract @NonNull List<@NonNull ImageSegment> getSegmentsList();

    protected void createSegmentColorScheme() {
        segColorMap.put("image_header", Color.RED);
        segColorMap.put("reserved", Color.LIGHTSLATEGRAY);
    }
}

