/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.validation;

import com.nxp.swtools.bootimage.utils.Messages;
import com.nxp.swtools.bootimage.validation.MultipleBaseAddressValidator;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.text.UtilsText;
import org.eclipse.core.runtime.Status;

public class OptionalValueValidator
extends MultipleBaseAddressValidator {
    private boolean isRequired;

    public OptionalValueValidator(int width, boolean isRequired) {
        super(width);
        this.isRequired = isRequired;
    }

    @Override
    public @NonNull Status validate(@NonNull String pluginId, @NonNull String value) {
        if (value.isEmpty() && this.isRequired) {
            return new Status(4, pluginId, UtilsText.safeString((String)Messages.EmptyTextfield));
        }
        Status status = this.isValidDecimal(pluginId, value);
        Status hexStatus = this.isValidHexadecimal(pluginId, value);
        if (!status.isOK() && hexStatus.isOK()) {
            return hexStatus;
        }
        if (!status.isOK() && !hexStatus.isOK() && NumberFormatValidator.isValidHexadecimal((String)value)) {
            status = hexStatus;
        }
        return status;
    }
}

