/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.validation;

import com.nxp.swtools.bootimage.utils.Messages;
import com.nxp.swtools.bootimage.validation.HexadecimalAddressValidator;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.util.logging.Level;
import org.eclipse.core.runtime.Status;

public class MultipleBaseAddressValidator
extends HexadecimalAddressValidator {
    public MultipleBaseAddressValidator(int width) {
        super(width);
    }

    public MultipleBaseAddressValidator(int width, boolean isZeroValueValid) {
        super(width, isZeroValueValid);
    }

    protected Status isValidDecimal(String pluginId, String value) {
        Status status = new Status(0, pluginId, "");
        if (NumberFormatValidator.isValidDecimal((String)value)) {
            try {
                if (!NumberFormatValidator.isValidDecimal((String)value) || Long.parseLong(value) > NumberFormatValidator.getHighDecimalLimit((int)this.width)) {
                    status = new Status(4, pluginId, Messages.InvalidWidthValue);
                } else if (!this.isZeroValueValid && Long.parseLong(value) == 0L) {
                    status = new Status(4, pluginId, Messages.InvalidTextfieldValueZero);
                }
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing ", err);
                status = new Status(4, pluginId, Messages.InvalidWidthValue);
            }
        } else {
            status = new Status(4, pluginId, Messages.DecimalHexadecimalInvalidValue);
        }
        return status;
    }

    @Override
    public Status validate(String pluginId, String value) {
        Status hexStatus = super.validate(pluginId, value);
        Status decimalStatus = this.isValidDecimal(pluginId, value);
        if (!decimalStatus.isOK() && hexStatus.isOK()) {
            return hexStatus;
        }
        if (!decimalStatus.isOK() && !hexStatus.isOK() && NumberFormatValidator.isValidHexadecimal((String)value)) {
            decimalStatus = hexStatus;
        }
        return decimalStatus;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

