/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.utils;

import com.nxp.swtools.common.ui.utils.Messages;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.stage.WindowEvent;

public class CustomContextMenu
extends ContextMenu {
    private MenuItem cutItem;
    private MenuItem copyItem;
    private MenuItem pasteItem;
    private MenuItem deleteItem;
    private MenuItem selectAllItem;
    private TextField textField;
    private static final String STYLE_STRING = "-fx-text-background-color: black; -fx-font-weight: bold";

    public CustomContextMenu(final TextField textField) {
        this.textField = textField;
        this.cutItem = new MenuItem(Messages.get().Label_CutItem);
        this.copyItem = new MenuItem(Messages.get().Label_CopyItem);
        this.pasteItem = new MenuItem(Messages.get().Label_PasteItem);
        this.deleteItem = new MenuItem(Messages.get().Label_DeleteItem);
        this.selectAllItem = new MenuItem(Messages.get().Label_SelectAllItem);
        this.cutItem.setStyle(STYLE_STRING);
        this.copyItem.setStyle(STYLE_STRING);
        this.pasteItem.setStyle(STYLE_STRING);
        this.deleteItem.setStyle(STYLE_STRING);
        this.selectAllItem.setStyle(STYLE_STRING);
        this.getItems().add((Object)this.cutItem);
        this.getItems().add((Object)this.copyItem);
        this.getItems().add((Object)this.pasteItem);
        this.getItems().add((Object)this.deleteItem);
        this.getItems().add((Object)new SeparatorMenuItem());
        this.getItems().add((Object)this.selectAllItem);
        this.setOnShowing((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent e) {
                CustomContextMenu.this.enableDisableItems(textField.getSelectedText().isEmpty());
                CustomContextMenu.this.getSelectAllItem().setDisable(textField.getText().isEmpty());
                Clipboard clip = Clipboard.getSystemClipboard();
                boolean pasteDisableStatus = true;
                if (clip.hasString() && !((String)clip.getContent(DataFormat.PLAIN_TEXT)).trim().isEmpty()) {
                    pasteDisableStatus = false;
                }
                CustomContextMenu.this.getPasteItem().setDisable(pasteDisableStatus);
            }
        });
        this.cutItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CustomContextMenu.this.getTextField().cut();
            }
        });
        this.copyItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CustomContextMenu.this.getTextField().copy();
            }
        });
        this.pasteItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CustomContextMenu.this.getTextField().paste();
            }
        });
        this.deleteItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String selectedTxt = CustomContextMenu.this.getTextField().getSelectedText();
                int startIndex = CustomContextMenu.this.getTextField().getText().indexOf(selectedTxt);
                CustomContextMenu.this.getTextField().deleteText(startIndex, startIndex + selectedTxt.length());
            }
        });
        this.selectAllItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CustomContextMenu.this.getTextField().selectAll();
            }
        });
    }

    void enableDisableItems(boolean status) {
        this.getCutItem().setDisable(status);
        this.getCopyItem().setDisable(status);
        this.getDeleteItem().setDisable(status);
    }

    public MenuItem getCutItem() {
        return this.cutItem;
    }

    public MenuItem getCopyItem() {
        return this.copyItem;
    }

    public MenuItem getPasteItem() {
        return this.pasteItem;
    }

    public MenuItem getDeleteItem() {
        return this.deleteItem;
    }

    public MenuItem getSelectAllItem() {
        return this.selectAllItem;
    }

    public TextField getTextField() {
        return this.textField;
    }
}

