/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.utils;

import com.nxp.swtools.bootimage.binders.ArrayDataBinder;
import com.nxp.swtools.bootimage.model.ArrayDataModel;
import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.ABaseCustomComponentSetting;
import com.nxp.swtools.bootimage.settings.AlignToValueSetting;
import com.nxp.swtools.bootimage.settings.ArraySetting;
import com.nxp.swtools.bootimage.settings.ArrayStructure;
import com.nxp.swtools.bootimage.settings.BoolSetting;
import com.nxp.swtools.bootimage.settings.ConstraintsRefs;
import com.nxp.swtools.bootimage.settings.ConstraintsSetting;
import com.nxp.swtools.bootimage.settings.EnableStateSetting;
import com.nxp.swtools.bootimage.settings.EnumSetting;
import com.nxp.swtools.bootimage.settings.ExpressionComponents;
import com.nxp.swtools.bootimage.settings.ImageHeader;
import com.nxp.swtools.bootimage.settings.ImageLengthSetting;
import com.nxp.swtools.bootimage.settings.ImageSegment;
import com.nxp.swtools.bootimage.settings.InputFileSetting;
import com.nxp.swtools.bootimage.settings.InputSetting;
import com.nxp.swtools.bootimage.settings.IntegerSetting;
import com.nxp.swtools.bootimage.settings.LimitValuesSetting;
import com.nxp.swtools.bootimage.settings.ReservedValuesSetting;
import com.nxp.swtools.bootimage.settings.StructSetting;
import com.nxp.swtools.bootimage.settings.TextSetting;
import com.nxp.swtools.bootimage.svd.utils.AccessMode;
import com.nxp.swtools.bootimage.svd.utils.BitFieldInfo;
import com.nxp.swtools.bootimage.utils.BootBinaryContentDialog;
import com.nxp.swtools.bootimage.utils.BootConstants;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.bootimage.utils.Messages;
import com.nxp.swtools.bootimage.validation.AValidatedTextField;
import com.nxp.swtools.bootimage.validation.IsFileValidResult;
import com.nxp.swtools.bootimage.validation.ValidatedComboBox;
import com.nxp.swtools.bootimage.view.ArrayDataView;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class BootUtils {
    private static final Logger LOGGER = LogManager.getLogger(BootUtils.class);
    private static boolean saveDialogOpenedFirstTime = true;

    public static String getInitialSaveDirectory(String initialDirectory) {
        if (saveDialogOpenedFirstTime) {
            if (OSDetect.isWindows()) {
                initialDirectory = "\\\\?\\" + initialDirectory;
            }
            saveDialogOpenedFirstTime = false;
        }
        return initialDirectory;
    }

    public static FileDialog createFileDialogChooser(int swtStyle, String fileDialogTitle, String filterPath, List<String> formatExtensions, List<String> filterNames, Shell shell, boolean showOverwrite) {
        FileDialog fileDialogChooser = new FileDialog(shell, swtStyle);
        fileDialogChooser.setFilterPath(filterPath);
        fileDialogChooser.setFilterExtensions(formatExtensions.toArray(new String[formatExtensions.size()]));
        fileDialogChooser.setText(fileDialogTitle);
        if (swtStyle == 8192) {
            fileDialogChooser.setFileName(Messages.DefaultExportFileName);
            fileDialogChooser.setFilterPath(BootUtils.getInitialSaveDirectory(UtilsText.safeString((String)System.getProperty("user.home"))));
        }
        fileDialogChooser.setOverwrite(showOverwrite);
        fileDialogChooser.setFilterNames(filterNames.toArray(new String[filterNames.size()]));
        return fileDialogChooser;
    }

    private static MessageBox createOverwriteDialog(String fileName, Shell shell) {
        MessageBox overwriteDialog = new MessageBox(shell, 200);
        String overwriteMessage = MessageFormat.format(Messages.Overwrite_Message, fileName);
        overwriteDialog.setMessage(overwriteMessage);
        overwriteDialog.setText(Messages.Confirm_SaveAs);
        return overwriteDialog;
    }

    public static @Nullable File selectFileToExportImage(List<String> formatExtensions, List<String> filterNames, Shell shell) {
        FileDialog fileDialogChooser = BootUtils.createFileDialogChooser(8192, com.nxp.swtools.utils.swt.dialogs.Messages.SavePanelTitle, BootUtils.getInitialSaveDirectory(UtilsText.safeString((String)System.getProperty("user.home"))), formatExtensions, filterNames, shell, false);
        String filePath = fileDialogChooser.open();
        if (filePath != null) {
            filePath = BootUtils.concatExtensionToFile(fileDialogChooser, filePath, "*.c");
            File selectedFile = new File(filePath);
            boolean exportFlag = false;
            if (selectedFile.exists()) {
                exportFlag = BootUtils.shouldOverwriteFile(shell, selectedFile);
            }
            try {
                if (selectedFile.createNewFile()) {
                    exportFlag = true;
                }
            }
            catch (IOException exception) {
                LOGGER.log(Level.WARNING, exception.getMessage(), exception);
            }
            if (exportFlag) {
                return selectedFile;
            }
        }
        return null;
    }

    public static boolean shouldOverwriteFile(Shell shell, File selectedFile) {
        if (OSDetect.isWindows()) {
            return true;
        }
        MessageBox overwriteDialog = BootUtils.createOverwriteDialog(selectedFile.getName(), shell);
        int buttonOption = overwriteDialog.open();
        return buttonOption == 64;
    }

    public static boolean isFileRaw(ImageHeader header, ByteBuffer byteImage) {
        int imageHeaderTag;
        return header.getTag().getSizeValue() > byteImage.capacity() || !BootUtils.imageHeadersTagMatch(header, imageHeaderTag = BootUtils.getIntValueFromByteArray(byteImage.array(), header.getTag().getOffsetValue(), header.getTag().getSizeValue()));
    }

    public static IsFileValidResult isFileValid(ImageHeader header, ByteBuffer byteImage, long fileSize, @Nullable Long minExpectedStructSize, int headerOffset, int customFieldsSize) {
        IsFileValidResult result = new IsFileValidResult();
        result.setBinaryFileRaw(BootUtils.isFileRaw(header, byteImage));
        if (minExpectedStructSize != null && (long)byteImage.array().length < minExpectedStructSize) {
            result.setFileValid(false);
            result.setExpectedValue(String.valueOf(minExpectedStructSize));
            result.setActualValue(String.valueOf(byteImage.array().length));
            result.setHeaderComponent(UtilsText.safeString((String)"structure size (bytes)"));
            return result;
        }
        byte[] fileHeaderArray = new byte[header.getSizeValueInBytes()];
        if (fileHeaderArray.length <= byteImage.capacity()) {
            int i = 0;
            while (i < header.getSizeValueInBytes()) {
                fileHeaderArray[i] = byteImage.get(headerOffset + i);
                ++i;
            }
            if (fileHeaderArray.length == 0) {
                return result;
            }
            fileHeaderArray = NumberFormatter.convertEndianness((byte[])fileHeaderArray, (int)header.getSizeValueInBytes(), (String)header.getByteOrder());
            if (!header.getInitValue().equals("")) {
                long headerValue = BootUtils.getLongValueFromByteArray(fileHeaderArray, headerOffset, header.getSizeValueInBytes());
                if (headerValue == header.getHeaderValue()) {
                    result.setFileValid(true);
                } else {
                    result.setFileValid(false);
                    result.setExpectedValue("0x" + Long.toHexString(header.getHeaderValue()).toUpperCase());
                    result.setActualValue("0x" + Long.toHexString(headerValue).toUpperCase());
                    result.setHeaderComponent(UtilsText.safeString((String)"image header tag"));
                }
                if (fileSize != (long)byteImage.array().length) {
                    result.setFileValid(false);
                    result.setExpectedValue(String.valueOf(fileSize));
                    result.setActualValue(String.valueOf(byteImage.array().length));
                    result.setHeaderComponent(UtilsText.safeString((String)"structure size (bytes)"));
                    return result;
                }
            } else {
                int imageHeaderTag = BootUtils.getIntValueFromByteArray(fileHeaderArray, header.getTag().getOffsetValue(), header.getTag().getSizeValue());
                if (BootUtils.imageHeadersTagMatch(header, imageHeaderTag)) {
                    ImageLengthSetting imageLengthSetting = header.getImageLength();
                    if (imageLengthSetting != null) {
                        int imageLength = BootUtils.getIntValueFromByteArray(fileHeaderArray, imageLengthSetting.getOffsetValue(), imageLengthSetting.getSizeValue());
                        if (!imageLengthSetting.getInitValue().equals("")) {
                            if (header.getImageLengthValue() == imageLength) {
                                if (byteImage.array().length == header.getImageLengthValue()) {
                                    BootUtils.checkHeaderVersion(header, result, fileHeaderArray);
                                } else {
                                    result.setFileValid(false);
                                    result.setExpectedValue(String.valueOf(imageLength));
                                    result.setActualValue(String.valueOf(byteImage.array().length));
                                    result.setHeaderComponent(UtilsText.safeString((String)"structure size (bytes)"));
                                }
                            } else {
                                result.setFileValid(false);
                                result.setExpectedValue("0x" + String.valueOf(header.getImageLengthValue()).toUpperCase());
                                result.setActualValue("0x" + String.valueOf(imageLength).toUpperCase());
                                result.setHeaderComponent(UtilsText.safeString((String)"image length"));
                            }
                        } else if (!imageLengthSetting.getMaxLength().equals("")) {
                            if (imageLength <= imageLengthSetting.getMaxLengthValue()) {
                                if ((long)imageLength == fileSize - (long)imageLengthSetting.getReservedSpaceValue() - (long)customFieldsSize) {
                                    BootUtils.checkHeaderVersion(header, result, fileHeaderArray);
                                } else {
                                    result.setFileValid(false);
                                    if (!imageLengthSetting.getReservedSpace().equals("")) {
                                        result.setExpectedValue(String.valueOf(MessageFormat.format(UtilsText.safeString((String)Messages.Msg_InvalidHeaderValue_FileSize), imageLengthSetting.getReservedSpace(), Messages.Msg_Reserved)) + "0x" + Long.toHexString(fileSize - (long)imageLengthSetting.getReservedSpaceValue() - (long)customFieldsSize) + " " + "(" + String.valueOf(fileSize - (long)imageLengthSetting.getReservedSpaceValue() - (long)customFieldsSize) + ")");
                                    } else {
                                        result.setExpectedValue(String.valueOf(Messages.Msg_FileSize) + "0x" + Long.toHexString(fileSize) + " " + "(" + String.valueOf(fileSize) + ")");
                                    }
                                    result.setActualValue("0x" + Long.toHexString(imageLength) + " " + "(" + String.valueOf(imageLength) + ")");
                                    result.setHeaderComponent(UtilsText.safeString((String)"image length"));
                                }
                            } else {
                                result.setFileValid(false);
                                result.setExpectedValue(String.valueOf(Messages.Msg_InvalidHeaderValue_ValueUnder) + "0x" + Integer.toHexString(imageLengthSetting.getMaxLengthValue()) + " " + "(" + imageLengthSetting.getMaxLengthValue() + ")");
                                result.setActualValue("0x" + Integer.toHexString(imageLength) + " " + "(" + String.valueOf(imageLength) + ")");
                                result.setHeaderComponent(UtilsText.safeString((String)"image length"));
                            }
                        }
                    } else {
                        BootUtils.checkHeaderVersion(header, result, fileHeaderArray);
                    }
                } else {
                    result.setFileValid(false);
                    if (!header.getPossibleTagValues().isEmpty()) {
                        StringBuilder possibleValues = new StringBuilder();
                        int i2 = 0;
                        while (i2 < header.getPossibleTagValues().size()) {
                            possibleValues.append("0x" + Long.toHexString(header.getPossibleTagValues().get(i2)).toUpperCase());
                            if (i2 != header.getPossibleTagValues().size() - 1) {
                                possibleValues.append(", ");
                            }
                            ++i2;
                        }
                        result.setExpectedValue(possibleValues.toString());
                    } else {
                        result.setExpectedValue("0x" + Long.toHexString(header.getTagValue()).toUpperCase());
                    }
                    result.setActualValue("0x" + Long.toHexString(imageHeaderTag).toUpperCase());
                    result.setHeaderComponent(UtilsText.safeString((String)"image header tag"));
                }
            }
        } else {
            result.setFileValid(false);
            result.setExpectedValue(String.valueOf(fileSize));
            result.setActualValue(String.valueOf(byteImage.array().length));
            result.setHeaderComponent(UtilsText.safeString((String)"structure size (bytes)"));
        }
        return result;
    }

    public static boolean imageHeadersTagMatch(ImageHeader header, int imageHeaderTagValue) {
        ArrayList<Long> possibleTagValues = new ArrayList<Long>();
        if (!header.getPossibleTagValues().isEmpty()) {
            header.getPossibleTagValues().stream().forEach(tagValue -> {
                boolean bl = possibleTagValues.add((Long)tagValue);
            });
        } else {
            possibleTagValues.add(new Long(header.getTagValue()));
        }
        return possibleTagValues.stream().anyMatch(value -> value == (long)imageHeaderTagValue);
    }

    private static void checkHeaderVersion(ImageHeader header, IsFileValidResult result, byte[] fileHeaderArray) {
        int imageVersion = BootUtils.getIntValueFromByteArray(fileHeaderArray, header.getVersion().getOffsetValue(), header.getVersion().getSizeValue());
        if ((long)imageVersion == header.getVersionValue()) {
            result.setFileValid(true);
        } else {
            result.setFileValid(false);
            result.setExpectedValue("0x" + Long.toHexString(header.getVersionValue()).toUpperCase());
            result.setActualValue("0x" + Long.toHexString(imageVersion).toUpperCase());
            result.setHeaderComponent(UtilsText.safeString((String)"image version"));
        }
    }

    public static void showFileContent(String filepath) {
        Shell activeShell;
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null && (activeShell = currentDisplay.getActiveShell()) != null) {
            if (filepath.equals("N/A")) {
                MessageDialog.openInformation((Shell)activeShell, (String)Messages.BinaryContentTitle, (String)Messages.ErrorNoFileLoaded);
            } else if (BootConstants.FILE_REGEX.matcher(filepath).matches()) {
                File file = new File(filepath);
                if (file.exists()) {
                    if (file.length() <= 17000000L) {
                        try {
                            byte[] fileContent = Files.readAllBytes(file.toPath());
                            if (fileContent == null) {
                                MessageDialog.openError((Shell)activeShell, (String)Messages.BinaryContentTitle, (String)Messages.ErrorCorruptFile);
                                return;
                            }
                            BootBinaryContentDialog dialog = new BootBinaryContentDialog(activeShell, fileContent);
                            dialog.open();
                        }
                        catch (IOException readException) {
                            LOGGER.log(Level.WARNING, "Error while reading into the file", readException);
                        }
                    } else {
                        MessageDialog.openInformation((Shell)activeShell, (String)Messages.BinaryContentTitle, (String)Messages.ErrorBinaryFileToLarge);
                    }
                } else {
                    MessageDialog.openInformation((Shell)activeShell, (String)Messages.BinaryContentTitle, (String)Messages.ErrMsg_FileCannotBeFound);
                }
            }
        }
    }

    public static boolean isValueReserved(long valueToTest, ReservedValuesSetting reservedValuesSetting) {
        boolean currentStatus = false;
        long startValue = reservedValuesSetting.getStartReservedValue();
        long endValue = reservedValuesSetting.getEndReservedValue();
        currentStatus = endValue > startValue ? startValue <= valueToTest && endValue >= valueToTest : startValue == valueToTest;
        return currentStatus;
    }

    public static boolean isValueAligned(long valueToTest, AlignToValueSetting alignToValueSetting) {
        boolean currentStatus = true;
        long valueInBytes = alignToValueSetting.getValueInBytes();
        if (valueInBytes != 0L) {
            if (valueToTest % valueInBytes != 0L) {
                currentStatus = false;
            }
        } else {
            long valueInBits = alignToValueSetting.getValueInBits();
            if (valueInBits != 0L && valueToTest % valueInBits != 0L) {
                currentStatus = false;
            }
        }
        return currentStatus;
    }

    public static boolean isValueInRange(long valueToTest, LimitValuesSetting limitValuesSetting) {
        boolean currentStatus = true;
        if (!limitValuesSetting.getMinValue().isEmpty() && !limitValuesSetting.getMaxValue().isEmpty()) {
            long minValue = limitValuesSetting.getMinLimitValue();
            long maxValue = limitValuesSetting.getMaxLimitValue();
            if (minValue > valueToTest || valueToTest > maxValue) {
                currentStatus = false;
            }
        } else if (!limitValuesSetting.getMinValue().isEmpty() && limitValuesSetting.getMaxValue().isEmpty()) {
            long minValue = limitValuesSetting.getMinLimitValue();
            currentStatus = valueToTest >= minValue;
        } else if (limitValuesSetting.getMinValue().isEmpty() && !limitValuesSetting.getMaxValue().isEmpty()) {
            long maxValue = limitValuesSetting.getMaxLimitValue();
            currentStatus = valueToTest <= maxValue;
        }
        return currentStatus;
    }

    public static boolean isFilePathInRange(@Nullable ConstraintsSetting constraintsSetting, @Nullable ConstraintsRefs constraintsRefs, long valueToTest) {
        boolean currentStatus = true;
        if (constraintsRefs != null) {
            for (ConstraintsRefs.LimitValuesRef limitValuesRef : constraintsRefs.getLimitValuesRefList()) {
                LimitValuesSetting limitRange;
                if (constraintsSetting == null || (limitRange = constraintsSetting.getLimitValuesById(limitValuesRef.getLimitValuesReference())) == null || limitRange.getCurrentDisableState().get()) continue;
                currentStatus = BootUtils.isValueInRange(valueToTest, limitRange);
            }
        }
        return currentStatus;
    }

    public static int getIntValueFromByteArray(byte[] buffer, int offset, int size) {
        int value = 0;
        int i = 0;
        while (i < size) {
            value = (value << 8) + (buffer[offset + i] & 0xFF);
            ++i;
        }
        return value;
    }

    public static long getLongValueFromByteArray(byte[] buffer, int offset, int size) {
        long value = 0L;
        int i = 0;
        while (i < size) {
            value = (value << 8) + (long)(buffer[offset + i] & 0xFF);
            ++i;
        }
        return value;
    }

    public static long getBitsMaskValue(int offset, int bitsLength) {
        byte[] maskBuffer = new byte[64];
        int i = 0;
        while (i < bitsLength) {
            maskBuffer[63 - offset + i] = 1;
            ++i;
        }
        long maskValue = 0L;
        int i2 = 0;
        while (i2 < 64) {
            maskValue = (maskValue << 1) + (long)maskBuffer[i2];
            ++i2;
        }
        return maskValue;
    }

    public static long getBytesMaskValue(int offset, int bytesLength, int bufferLen) {
        byte[] maskBuffer = new byte[bufferLen];
        int i = 0;
        while (i < bytesLength) {
            maskBuffer[offset + i] = -1;
            ++i;
        }
        long maskValue = BootUtils.getLongValueFromByteArray(maskBuffer, 0, bufferLen);
        return maskValue;
    }

    public static Long getLongFromHexString(String value) {
        if (value.endsWith("h")) {
            value = UtilsText.safeString((String)value.substring(0, value.length() - 1));
        }
        if (!value.startsWith("0x")) {
            value = "0x" + value;
        }
        Long hexValue = Long.decode(value);
        assert (hexValue != null);
        return hexValue;
    }

    public static Long getLongFromBinaryString(String value) {
        if (NumberFormatValidator.isValidXmlBinaryFormat((String)value)) {
            value = UtilsText.safeString((String)value.substring(0, value.length() - 1));
        }
        if (value.startsWith("0b")) {
            value = UtilsText.safeString((String)value.substring(2));
        }
        Long decimalValue = Long.valueOf(value, 2);
        assert (decimalValue != null);
        return decimalValue;
    }

    public static String getBinaryStringFromLongValue(long value, int width) {
        StringBuilder binaryStringBuff = new StringBuilder();
        String binaryStr = Long.toBinaryString(value);
        int i = 0;
        while (i < width - binaryStr.length()) {
            binaryStringBuff.append(Long.toString(0L));
            ++i;
        }
        binaryStringBuff.append(Long.toBinaryString(value));
        return binaryStringBuff.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static @Nullable ByteBuffer getBytesFromString(String dataStr) {
        block3: {
            if (dataStr.equals("")) break block3;
            newData = new ArrayList<String>();
            pattern = Pattern.compile("(0x[A-Fa-f0-9]+)\\s*", 8);
            matcher = pattern.matcher(dataStr);
            if (BootUtils.$assertionsDisabled || matcher != null) ** GOTO lbl13
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                i = 1;
                while (i <= matcher.groupCount()) {
                    newData.add(Objects.requireNonNull(matcher.group(i)));
                    ++i;
                }
lbl13:
                // 2 sources

                ** while (matcher.find())
            }
lbl14:
            // 1 sources

            bytesBuffer = ByteBuffer.allocate(newData.size());
            i = 0;
            while (i < newData.size()) {
                value = Integer.decode((String)newData.get(i));
                bytesBuffer.put(i, (byte)value);
                ++i;
            }
            return bytesBuffer;
        }
        return null;
    }

    public static byte[] getBytesFromBuffer(ByteBuffer bytesBuffer, int offset, int size) {
        byte[] bytes = new byte[size];
        if (bytesBuffer.hasArray()) {
            System.arraycopy(bytesBuffer.array(), offset, bytes, 0, size);
        }
        return bytes;
    }

    public static void fillBitfieldValueBasedOnEndianness(StringBuilder binaryValue, int bitfieldWidth) {
        while (binaryValue.length() < bitfieldWidth) {
            binaryValue.insert(0, "0");
        }
    }

    public static ArrayDataBinder createNewArrayDataBinder(int index, ArraySetting arraySetting) {
        ArrayDataModel dataModel = new ArrayDataModel(index);
        ArrayDataBinder dataBinder = new ArrayDataBinder(dataModel);
        ArrayStructure arrayStruct = arraySetting.getArrayStructure();
        if (arrayStruct != null) {
            for (ArraySetting.ArrayItemReference itemRef : arraySetting.getItemsList()) {
                for (StructSetting structSetting : arrayStruct.getStructSettingsList()) {
                    BoolSetting boolSetting = structSetting.getBoolSettingById(itemRef.getValue());
                    if (boolSetting != null) {
                        boolSetting.setCurrentSelection("true".equals(boolSetting.getInitValue()));
                        dataBinder.addBoolSetting(boolSetting);
                        continue;
                    }
                    EnumSetting enumSetting = structSetting.getEnumSettingById(itemRef.getValue());
                    if (enumSetting != null) {
                        EnumSetting.ItemSetting defaultSelectedItem = enumSetting.getItemById(enumSetting.getInitValue());
                        if (defaultSelectedItem != null) {
                            enumSetting.setCurrentSelection(defaultSelectedItem.getLabel());
                        }
                        dataBinder.addEnumSetting(enumSetting);
                        continue;
                    }
                    IntegerSetting integerSetting = structSetting.getIntegerSettingById(itemRef.getValue());
                    if (integerSetting != null) {
                        if (NumberFormatValidator.isValidXmlHexFormat((String)integerSetting.getInitValue())) {
                            long valueToWrite = NumberFormatValidator.getDecimalLongFromXmlHex((String)integerSetting.getInitValue());
                            integerSetting.setValueToWrite(valueToWrite);
                        } else if (NumberFormatValidator.isValidDecimal((String)integerSetting.getInitValue())) {
                            long valueToWrite = NumberFormatValidator.getLongFromStringDecimal((String)integerSetting.getInitValue());
                            integerSetting.setValueToWrite(valueToWrite);
                        }
                        dataBinder.addIntegerSetting(integerSetting);
                        continue;
                    }
                    TextSetting textSetting = structSetting.getTextSettingById(itemRef.getValue());
                    if (textSetting == null) continue;
                    dataBinder.addTextSetting(textSetting);
                }
            }
        }
        return dataBinder;
    }

    public static byte[] getArrayItemBufferToWrite(ArraySetting arraySetting, ArrayDataBinder arrayItem, byte defaultMemValue) {
        byte[] bufferToWrite = new byte[]{};
        ArrayStructure arrayStruct = arraySetting.getArrayStructure();
        if (arrayStruct != null) {
            bufferToWrite = new byte[arrayStruct.getArrayStructSizeInBytes()];
            Arrays.fill(bufferToWrite, defaultMemValue);
            for (StructSetting structSetting : arrayStruct.getStructSettingsList()) {
                int sizeInBytes = structSetting.getSizeValueInBytes();
                ByteBuffer structBuffer = ByteBuffer.allocate(sizeInBytes);
                Arrays.fill(structBuffer.array(), defaultMemValue);
                if (sizeInBytes <= 8) {
                    long currentValueToWrite = 0L;
                    for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
                        BoolSetting arrayItemBool = arrayItem.getBoolSettingById(boolSetting.getId());
                        if (arrayItemBool == null) continue;
                        long boolSettingValue = 0L;
                        if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(boolSetting.getSize()).matches()) {
                            boolSettingValue = arrayItemBool.getValueToWrite() << boolSetting.getOffsetValue();
                        } else if (BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(boolSetting.getSize()).matches()) {
                            boolSettingValue = arrayItemBool.getValueToWrite() << (structSetting.getSizeValueInBytes() - (boolSetting.getOffsetValue() + boolSetting.getSizeValueInBytes())) * 8;
                        }
                        currentValueToWrite = currentValueToWrite + boolSettingValue & 0xFFFFFFFFFFFFFFFFL;
                    }
                    for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
                        EnumSetting arrayItemEnum = arrayItem.getEnumSettingById(enumSetting.getId());
                        if (arrayItemEnum == null) continue;
                        long enumSettingValue = 0L;
                        if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(enumSetting.getSize()).matches()) {
                            enumSettingValue = arrayItemEnum.getValueToWrite() << enumSetting.getOffsetValue() - enumSetting.getSizeValueInBits() + 1;
                        } else if (BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(enumSetting.getSize()).matches()) {
                            enumSettingValue = arrayItemEnum.getValueToWrite() << (structSetting.getSizeValueInBytes() - (enumSetting.getOffsetValue() + enumSetting.getSizeValueInBytes())) * 8;
                        }
                        currentValueToWrite = currentValueToWrite + enumSettingValue & 0xFFFFFFFFFFFFFFFFL;
                    }
                    for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
                        IntegerSetting arrayItemInteger = arrayItem.getIntegerSettingById(integerSetting.getId());
                        if (arrayItemInteger == null) continue;
                        long integerSettingValue = 0L;
                        if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(integerSetting.getSize()).matches()) {
                            integerSettingValue = arrayItemInteger.getValueToWrite() << integerSetting.getOffsetValue() - integerSetting.getSizeValueInBits() + 1;
                        } else if (BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(integerSetting.getSize()).matches()) {
                            integerSettingValue = arrayItemInteger.getValueToWrite() << (structSetting.getSizeValueInBytes() - (integerSetting.getOffsetValue() + integerSetting.getSizeValueInBytes())) * 8;
                        }
                        currentValueToWrite = currentValueToWrite + integerSettingValue & 0xFFFFFFFFFFFFFFFFL;
                    }
                    for (TextSetting textSetting : structSetting.getTextSettingList()) {
                        TextSetting arrayItemText = arrayItem.getTextSettingById(textSetting.getId());
                        if (arrayItemText == null) continue;
                        long textSettingValue = 0L;
                        ByteBuffer bytesFromMessage = BootUtils.getBytesFromString(arrayItemText.getMessage());
                        if (bytesFromMessage != null) {
                            textSettingValue = BootUtils.getLongValueFromByteArray(bytesFromMessage.array(), 0, textSetting.getSizeValueInBytes()) << (structSetting.getSizeValueInBytes() - (textSetting.getOffsetValue() + textSetting.getSizeValueInBytes())) * 8;
                        }
                        currentValueToWrite = currentValueToWrite + textSettingValue & 0xFFFFFFFFFFFFFFFFL;
                    }
                    structBuffer.put(NumberFormatter.getValueBytes((BigInteger)BigInteger.valueOf(currentValueToWrite), (int)sizeInBytes));
                } else {
                    int i;
                    for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
                        BoolSetting arrayItemBool = arrayItem.getBoolSettingById(boolSetting.getId());
                        if (arrayItemBool == null) continue;
                        int boolSettingOffset = arrayItemBool.getOffsetValue();
                        int boolSettingSize = arrayItemBool.getSizeValueInBytes();
                        ByteBuffer boolBufferToWrite = ByteBuffer.allocate(boolSettingSize);
                        Arrays.fill(boolBufferToWrite.array(), defaultMemValue);
                        boolBufferToWrite.put(NumberFormatter.getValueBytes((BigInteger)BigInteger.valueOf(arrayItemBool.getValueToWrite()), (int)boolSettingSize));
                        i = 0;
                        while (i < boolSettingSize) {
                            structBuffer.put(i + boolSettingOffset, boolBufferToWrite.get(i));
                            ++i;
                        }
                    }
                    for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
                        EnumSetting arrayItemEnum = arrayItem.getEnumSettingById(enumSetting.getId());
                        if (arrayItemEnum == null) continue;
                        int enumSettingOffset = arrayItemEnum.getOffsetValue();
                        int enumSettingSize = arrayItemEnum.getSizeValueInBytes();
                        ByteBuffer enumBufferToWrite = ByteBuffer.allocate(enumSettingSize);
                        Arrays.fill(enumBufferToWrite.array(), defaultMemValue);
                        enumBufferToWrite.put(NumberFormatter.getValueBytes((BigInteger)BigInteger.valueOf(arrayItemEnum.getValueToWrite()), (int)enumSettingSize));
                        i = 0;
                        while (i < enumSettingSize) {
                            structBuffer.put(i + enumSettingOffset, enumBufferToWrite.get(i));
                            ++i;
                        }
                    }
                    for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
                        IntegerSetting arrayItemInteger = arrayItem.getIntegerSettingById(integerSetting.getId());
                        if (arrayItemInteger == null) continue;
                        int integerSettingOffset = arrayItemInteger.getOffsetValue();
                        int integerSettingSize = arrayItemInteger.getSizeValueInBytes();
                        ByteBuffer integerBufferToWrite = ByteBuffer.allocate(integerSettingSize);
                        Arrays.fill(integerBufferToWrite.array(), defaultMemValue);
                        integerBufferToWrite.put(NumberFormatter.getValueBytes((BigInteger)BigInteger.valueOf(arrayItemInteger.getValueToWrite()), (int)integerSettingSize));
                        i = 0;
                        while (i < integerSettingSize) {
                            structBuffer.put(i + integerSettingOffset, integerBufferToWrite.get(i));
                            ++i;
                        }
                    }
                    for (TextSetting textSetting : structSetting.getTextSettingList()) {
                        TextSetting arrayItemText = arrayItem.getTextSettingById(textSetting.getId());
                        if (arrayItemText == null) continue;
                        ByteBuffer textBufferToWrite = ByteBuffer.allocate(arrayItemText.getSizeValueInBytes());
                        Arrays.fill(textBufferToWrite.array(), defaultMemValue);
                        ByteBuffer bytesFromMessage = BootUtils.getBytesFromString(arrayItemText.getMessage());
                        if (bytesFromMessage == null) continue;
                        textBufferToWrite.put(bytesFromMessage);
                        int textSettingOffset = textSetting.getOffsetValue();
                        int textSettingSize = textSetting.getSizeValueInBytes();
                        int i2 = 0;
                        while (i2 < textSettingSize) {
                            structBuffer.put(i2 + textSettingOffset, textBufferToWrite.get(i2));
                            ++i2;
                        }
                    }
                }
                byte[] newBuffer = NumberFormatter.convertEndianness((byte[])structBuffer.array(), (int)sizeInBytes, (String)structSetting.getByteOrder());
                int offset = structSetting.getOffsetValue();
                int i = 0;
                while (i < sizeInBytes) {
                    bufferToWrite[i + offset] = newBuffer[i];
                    ++i;
                }
            }
        }
        return bufferToWrite;
    }

    public static void updateStructSettingFromBinary(StructSetting structSetting, byte[] structImageBuffer) {
        for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
            BootUtils.updateScalarSettingFromBinary(boolSetting, structImageBuffer);
        }
        for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
            BootUtils.updateScalarSettingFromBinary(enumSetting, structImageBuffer);
        }
        for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
            BootUtils.updateScalarSettingFromBinary(integerSetting, structImageBuffer);
        }
        for (TextSetting textSetting : structSetting.getTextSettingList()) {
            BootUtils.updateScalarSettingFromBinary(textSetting, structImageBuffer);
        }
    }

    public static void updateArrayTableDataFromBinary(ArraySetting arraySetting, String dataStr, byte defaultMemValue) {
        ByteBuffer arrayDataBuffer = BootUtils.getBytesFromString(dataStr);
        if (arrayDataBuffer != null) {
            BootUtils.updateArrayTableDataFromBinary(arraySetting, arrayDataBuffer, defaultMemValue);
        }
    }

    public static void updateArrayTableDataFromBinary(ArraySetting arraySetting, ByteBuffer arrayDataBuffer, byte defaultMemValue) {
        arraySetting.getTableData().clear();
        int arrayItemSizeInBytes = BootUtils.getArrayItemSizeInBytes(arraySetting);
        int arrayItemIndex = 0;
        int currentOffset = 0;
        while (currentOffset + arrayItemSizeInBytes <= arrayDataBuffer.capacity()) {
            ByteBuffer arrayItemBuffer = ByteBuffer.allocate(arrayItemSizeInBytes);
            arrayItemBuffer.put(BootUtils.getBufferFromByteImage(arrayDataBuffer, currentOffset, arrayItemSizeInBytes));
            if (!BootUtils.isReservedBuffer(arrayItemBuffer.array(), defaultMemValue)) {
                ArrayDataBinder dataBinder = BootUtils.createNewArrayDataBinder(arrayItemIndex, arraySetting);
                ArrayStructure arrayStruct = arraySetting.getArrayStructure();
                if (arrayStruct != null) {
                    for (StructSetting structSetting : arrayStruct.getStructSettingsList()) {
                        int structOffset = structSetting.getOffsetValue();
                        int structSizeInBytes = structSetting.getSizeValueInBytes();
                        byte[] structBuffer = BootUtils.getBufferFromByteImage(arrayItemBuffer, structOffset, structSizeInBytes);
                        structBuffer = NumberFormatter.convertEndianness((byte[])structBuffer, (int)structSizeInBytes, (String)structSetting.getByteOrder());
                        for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
                            BoolSetting arrayItemBool = dataBinder.getBoolSettingById(boolSetting.getId());
                            if (arrayItemBool == null) continue;
                            BootUtils.updateScalarSettingFromBinary(arrayItemBool, structBuffer);
                        }
                        for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
                            EnumSetting arrayItemEnum = dataBinder.getEnumSettingById(enumSetting.getId());
                            if (arrayItemEnum == null) continue;
                            BootUtils.updateScalarSettingFromBinary(arrayItemEnum, structBuffer);
                        }
                        for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
                            IntegerSetting arrayItemInteger = dataBinder.getIntegerSettingById(integerSetting.getId());
                            if (arrayItemInteger == null) continue;
                            BootUtils.updateScalarSettingFromBinary(arrayItemInteger, structBuffer);
                        }
                        for (TextSetting textSetting : structSetting.getTextSettingList()) {
                            TextSetting arrayItemText = dataBinder.getTextSettingById(textSetting.getId());
                            if (arrayItemText == null) continue;
                            BootUtils.updateScalarSettingFromBinary(arrayItemText, structBuffer);
                        }
                    }
                }
                arraySetting.getTableData().add((Object)dataBinder);
                ++arrayItemIndex;
            }
            currentOffset += arrayItemSizeInBytes;
        }
    }

    public static void updateScalarSettingFromBinary(ABaseCustomComponentSetting scalarSetting, byte[] structImageBuffer) {
        if (structImageBuffer.length <= 8) {
            long structValue = BootUtils.getLongValueFromByteArray(structImageBuffer, 0, structImageBuffer.length);
            if (!scalarSetting.getOffset().equals("") && !scalarSetting.getSize().equals("")) {
                if (scalarSetting instanceof BoolSetting) {
                    BoolSetting boolSetting = (BoolSetting)scalarSetting;
                    long boolValue = 0L;
                    int boolOffset = boolSetting.getOffsetValue();
                    if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(boolSetting.getSize()).matches()) {
                        int boolSizeInBits = boolSetting.getSizeValueInBits();
                        long maskValue = BootUtils.getBitsMaskValue(boolOffset, boolSizeInBits);
                        boolValue = (structValue & maskValue) >> boolOffset;
                    } else if (BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(boolSetting.getSize()).matches()) {
                        int boolSizeInBytes = boolSetting.getSizeValueInBytes();
                        long maskValue = BootUtils.getBytesMaskValue(boolOffset, boolSizeInBytes, structImageBuffer.length);
                        boolValue = (structValue & maskValue) >> (structImageBuffer.length - (boolOffset + boolSizeInBytes)) * 8;
                    }
                    boolSetting.setValueToWrite(boolValue);
                    boolSetting.setCurrentSelection(1L == boolValue);
                } else if (scalarSetting instanceof EnumSetting) {
                    long maskValue;
                    EnumSetting enumSetting = (EnumSetting)scalarSetting;
                    long enumValue = 0L;
                    int enumOffset = enumSetting.getOffsetValue();
                    if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(enumSetting.getSize()).matches()) {
                        int enumSizeInBits = enumSetting.getSizeValueInBits();
                        maskValue = BootUtils.getBitsMaskValue(enumOffset, enumSizeInBits);
                        enumValue = (structValue & maskValue) >> enumOffset - enumSizeInBits + 1;
                    } else if (BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(enumSetting.getSize()).matches()) {
                        int enumSizeInBytes = enumSetting.getSizeValueInBytes();
                        maskValue = BootUtils.getBytesMaskValue(enumOffset, enumSizeInBytes, structImageBuffer.length);
                        enumValue = (structValue & maskValue) >> (structImageBuffer.length - (enumOffset + enumSizeInBytes)) * 8;
                    }
                    enumSetting.setValueToWrite(enumValue);
                    for (EnumSetting.ItemSetting item : enumSetting.getItems()) {
                        if (item.getItemValue() != enumValue) continue;
                        enumSetting.setCurrentSelection(item.getLabel());
                    }
                } else if (scalarSetting instanceof IntegerSetting) {
                    IntegerSetting integerSetting = (IntegerSetting)scalarSetting;
                    long integerValue = 0L;
                    int integerOffset = integerSetting.getOffsetValue();
                    if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(integerSetting.getSize()).matches()) {
                        int integerSizeInBits = integerSetting.getSizeValueInBits();
                        long maskValue = BootUtils.getBitsMaskValue(integerOffset, integerSizeInBits);
                        integerValue = (structValue & maskValue) >> integerOffset - integerSizeInBits + 1;
                    } else if (BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(integerSetting.getSize()).matches()) {
                        int integerSizeInBytes = integerSetting.getSizeValueInBytes();
                        long maskValue = BootUtils.getBytesMaskValue(integerOffset, integerSizeInBytes, structImageBuffer.length);
                        integerValue = (structValue & maskValue) >> (structImageBuffer.length - (integerOffset + integerSizeInBytes)) * 8;
                    }
                    integerSetting.setValueToWrite(integerValue);
                } else if (scalarSetting instanceof TextSetting) {
                    long maskValue;
                    TextSetting textSetting = (TextSetting)scalarSetting;
                    long textValue = 0L;
                    int textOffset = textSetting.getOffsetValue();
                    if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(textSetting.getSize()).matches()) {
                        int textSizeInBits = textSetting.getSizeValueInBits();
                        maskValue = BootUtils.getBitsMaskValue(textOffset, textSizeInBits);
                        textValue = (structValue & maskValue) >> textOffset - textSizeInBits + 1;
                    } else if (BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(textSetting.getSize()).matches()) {
                        int textSizeInBytes = textSetting.getSizeValueInBytes();
                        maskValue = BootUtils.getBytesMaskValue(textOffset, textSizeInBytes, structImageBuffer.length);
                        textValue = (structValue & maskValue) >> (structImageBuffer.length - (textOffset + textSizeInBytes)) * 8;
                    }
                    ByteBuffer intermediateBuff = ByteBuffer.allocate(8).putLong(textValue);
                    StringBuilder textMessage = new StringBuilder();
                    int i = 0;
                    while (i < intermediateBuff.capacity()) {
                        textMessage.append("0x" + Long.toHexString(intermediateBuff.get(i) & 0xFF));
                        textMessage.append(" ");
                        ++i;
                    }
                    textSetting.setMessage(textMessage.toString());
                }
            } else {
                BootUtils.resetScalarSettingToDefault(scalarSetting);
            }
        } else {
            ByteBuffer structSettingBuffer = ByteBuffer.allocate(structImageBuffer.length);
            structSettingBuffer.put(structImageBuffer);
            byte[] scalarSettingBuffer = BootUtils.getBufferFromByteImage(structSettingBuffer, scalarSetting.getOffsetValue(), scalarSetting.getSizeValueInBytes());
            if (scalarSetting instanceof BoolSetting) {
                BoolSetting boolSetting = (BoolSetting)scalarSetting;
                long boolValue = BootUtils.getLongValueFromByteArray(scalarSettingBuffer, 0, scalarSettingBuffer.length);
                boolSetting.setValueToWrite(boolValue);
                boolSetting.setCurrentSelection(1L == boolValue);
            } else if (scalarSetting instanceof EnumSetting) {
                EnumSetting enumSetting = (EnumSetting)scalarSetting;
                long enumValue = BootUtils.getLongValueFromByteArray(scalarSettingBuffer, 0, scalarSettingBuffer.length);
                enumSetting.setValueToWrite(enumValue);
                for (EnumSetting.ItemSetting item : enumSetting.getItems()) {
                    if (item.getItemValue() != enumValue) continue;
                    enumSetting.setCurrentSelection(item.getLabel());
                }
            } else if (scalarSetting instanceof IntegerSetting) {
                IntegerSetting integerSetting = (IntegerSetting)scalarSetting;
                long integerValue = BootUtils.getLongValueFromByteArray(scalarSettingBuffer, 0, scalarSettingBuffer.length);
                integerSetting.setValueToWrite(integerValue);
            } else if (scalarSetting instanceof TextSetting) {
                TextSetting txtSetting = (TextSetting)scalarSetting;
                StringBuilder txtMessage = new StringBuilder();
                int i = 0;
                while (i < scalarSettingBuffer.length) {
                    txtMessage.append("0x" + Long.toHexString(scalarSettingBuffer[i] & 0xFF));
                    txtMessage.append(" ");
                    ++i;
                }
                txtSetting.setMessage(txtMessage.toString());
            }
        }
    }

    public static void resetStructSettingToDefault(StructSetting structSetting) {
        for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
            BootUtils.resetScalarSettingToDefault(boolSetting);
        }
        for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
            BootUtils.resetScalarSettingToDefault(enumSetting);
        }
        for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
            BootUtils.resetScalarSettingToDefault(integerSetting);
        }
        for (TextSetting textSetting : structSetting.getTextSettingList()) {
            BootUtils.resetScalarSettingToDefault(textSetting);
        }
    }

    public static void resetScalarSettingToDefault(ABaseCustomComponentSetting componentSetting) {
        if (componentSetting instanceof BoolSetting) {
            BoolSetting boolSetting = (BoolSetting)componentSetting;
            boolSetting.setCurrentSelection("true".equals(boolSetting.getInitValue()));
            boolSetting.setValueToWrite(boolSetting.getCurrentSelection() ? 1 : 0);
        } else if (componentSetting instanceof EnumSetting) {
            EnumSetting enumSetting = (EnumSetting)componentSetting;
            enumSetting.setCurrentSelection(enumSetting.getInitValue());
            for (EnumSetting.ItemSetting item : enumSetting.getItems()) {
                if (!item.getId().equalsIgnoreCase(enumSetting.getInitValue())) continue;
                enumSetting.setCurrentSelection(item.getLabel());
                enumSetting.setValueToWrite(item.getValueToWrite());
            }
        } else if (componentSetting instanceof IntegerSetting) {
            IntegerSetting integerSetting = (IntegerSetting)componentSetting;
            long initValue = 0L;
            if (NumberFormatValidator.isValidXmlHexFormat((String)integerSetting.getInitValue())) {
                initValue = NumberFormatValidator.getDecimalLongFromXmlHex((String)integerSetting.getInitValue());
            } else if (NumberFormatValidator.isValidDecimal((String)integerSetting.getInitValue())) {
                initValue = NumberFormatValidator.getIntFromStringDecimal((String)integerSetting.getInitValue());
            }
            integerSetting.setValueToWrite(initValue);
        } else if (componentSetting instanceof TextSetting) {
            TextSetting textSetting = (TextSetting)componentSetting;
            textSetting.setMessage(textSetting.getInitValue());
        }
    }

    public static byte[] getStructSettingBytesFromByteImage(StructSetting structSetting, ByteBuffer byteImage) {
        int structOffset = structSetting.getOffsetValue();
        int structSize = structSetting.getSizeValueInBytes();
        byte[] structBuffer = BootUtils.getBufferFromByteImage(byteImage, structOffset, structSize);
        structBuffer = NumberFormatter.convertEndianness((byte[])structBuffer, (int)structSize, (String)structSetting.getByteOrder());
        return structBuffer;
    }

    public static byte[] getBufferFromByteImage(ByteBuffer byteImage, int offset, int length) {
        byte[] buffer = new byte[length];
        if (byteImage.array().length >= offset + length) {
            int i = 0;
            while (i < length) {
                buffer[i] = byteImage.get(offset + i);
                ++i;
            }
        }
        return buffer;
    }

    private static int getArrayItemSizeInBytes(ArraySetting arraySetting) {
        int size = 0;
        ArrayStructure arrayStruct = arraySetting.getArrayStructure();
        if (arrayStruct != null) {
            for (StructSetting structSetting : arrayStruct.getStructSettingsList()) {
                size += structSetting.getSizeValueInBytes();
            }
        }
        return size;
    }

    private static boolean isReservedBuffer(byte[] buffer, byte defaultMemValue) {
        boolean state = true;
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] != defaultMemValue) {
                state = false;
            }
            ++i;
        }
        return state;
    }

    public static boolean isEnabledArrayItemComponent(ArrayDataBinder arrayItem, ABaseComponentSetting component) {
        boolean enabled = true;
        long valueToWrite = 0L;
        for (EnableStateSetting enableState : component.getEnableStatesList()) {
            String conditionField = enableState.getConditionField();
            List<String> possibleConditionValues = enableState.getConditionPossibleValues();
            BoolSetting conditionBool = arrayItem.getBoolSettingById(conditionField);
            if (conditionBool != null) {
                String currentBoolValue;
                String string = currentBoolValue = conditionBool.getCurrentSelection() ? "true" : "false";
                enabled = BootUtils.isConditionStateAvailable(possibleConditionValues, currentBoolValue) ? enabled & enableState.getState() : enabled & !enableState.getState();
            } else {
                EnumSetting conditionEnum = arrayItem.getEnumSettingById(conditionField);
                if (conditionEnum != null) {
                    enabled = BootUtils.isConditionStateAvailable(possibleConditionValues, conditionEnum.getCurrentSelection()) ? enabled & enableState.getState() : enabled & !enableState.getState();
                } else {
                    IntegerSetting conditionInteger = arrayItem.getIntegerSettingById(conditionField);
                    if (conditionInteger != null) {
                        String currentIntegerValue = String.valueOf(Long.toHexString(conditionInteger.getValueToWrite())) + "h";
                        enabled = BootUtils.isConditionStateAvailable(possibleConditionValues, currentIntegerValue) ? enabled & enableState.getState() : enabled & !enableState.getState();
                    } else {
                        TextSetting conditionText = arrayItem.getTextSettingById(conditionField);
                        if (conditionText != null) {
                            enabled = BootUtils.isConditionStateAvailable(possibleConditionValues, conditionText.getMessage()) ? enabled & enableState.getState() : enabled & !enableState.getState();
                        }
                    }
                }
            }
            String componentValue = enableState.getComponentValue();
            if (enabled != enableState.getState() || componentValue == null || !(component instanceof ABaseCustomComponentSetting)) continue;
            valueToWrite = Long.decode(Objects.requireNonNull(componentValue));
            ((ABaseCustomComponentSetting)component).setValueToWrite(valueToWrite);
        }
        return enabled;
    }

    public static boolean isConditionStateAvailable(List<String> possibleValues, String currentFieldValue) {
        for (String value : possibleValues) {
            if (!value.equalsIgnoreCase(currentFieldValue)) continue;
            return true;
        }
        return false;
    }

    public static void updateTableViewItemComponentsState(ArrayDataView tableItem) {
        ArrayDataBinder dataBinder = tableItem.getDataBinder();
        for (BoolSetting boolSetting : dataBinder.getBoolSettings()) {
            CheckBox boolCk = tableItem.getCheckBoxById(boolSetting.getId());
            if (boolCk == null) continue;
            boolCk.setDisable(boolSetting.getCurrentDisableState().get());
        }
        for (EnumSetting enumSetting : dataBinder.getEnumSettings()) {
            ValidatedComboBox<String> enumCmb = tableItem.getComboBoxById(enumSetting.getId());
            if (enumCmb == null) continue;
            enumCmb.setDisable(enumSetting.getCurrentDisableState().get());
            ArrayList<String> itemsToBeRemoved = new ArrayList<String>();
            ArrayList<String> itemsToBeAdded = new ArrayList<String>();
            for (EnumSetting.ItemSetting itemSetting : enumSetting.getItems()) {
                if (itemSetting.getCurrentDisableState().get()) {
                    itemsToBeRemoved.add(itemSetting.getLabel());
                    continue;
                }
                itemsToBeAdded.add(itemSetting.getLabel());
            }
            enumCmb.getItems().removeAll(itemsToBeRemoved);
            for (String item : itemsToBeAdded) {
                if (enumCmb.getItems().contains((Object)item)) continue;
                enumCmb.getItems().add((Object)item);
            }
            if (enumCmb.getItems().size() != 1) continue;
            enumCmb.getSelectionModel().selectFirst();
        }
        for (IntegerSetting integerSetting : dataBinder.getIntegerSettings()) {
            AValidatedTextField integerTxt = tableItem.getTextFieldById(integerSetting.getId());
            if (integerTxt == null) continue;
            integerTxt.setDisable(integerSetting.getCurrentDisableState().get());
        }
        for (TextSetting textSetting : dataBinder.getTextSettings()) {
            GridPane textPane = tableItem.getGridPaneById(textSetting.getId());
            if (textPane == null) continue;
            textPane.setDisable(textSetting.getCurrentDisableState().get());
        }
    }

    public static boolean isIntegerValueInRange(@Nullable ConstraintsSetting constraints, IntegerSetting integerSetting, long valueToTest) {
        boolean currentStatus = true;
        boolean isLimitRangeEnabled = false;
        if (constraints != null && !integerSetting.getLimitValuesRefs().isEmpty()) {
            currentStatus = false;
            for (ConstraintsRefs.LimitValuesRef limitValuesRef : integerSetting.getLimitValuesRefs()) {
                LimitValuesSetting limitRange = constraints.getLimitValuesById(limitValuesRef.getLimitValuesReference());
                if (limitRange == null || limitRange.getCurrentDisableState().get()) continue;
                isLimitRangeEnabled = true;
                currentStatus |= BootUtils.isValueInRange(valueToTest, limitRange);
            }
            if (!isLimitRangeEnabled) {
                currentStatus = true;
            }
        }
        return currentStatus;
    }

    public static boolean isIntegerValueAligned(@Nullable ConstraintsSetting constraints, IntegerSetting integerSetting, long valueToTest) {
        boolean currentStatus = true;
        if (constraints != null && !integerSetting.getAlignToValueRefs().isEmpty()) {
            for (ConstraintsRefs.AlignToValueRef reference : integerSetting.getAlignToValueRefs()) {
                AlignToValueSetting alignToSetting = constraints.getAlignToValueSettingById(reference.getAlignToValueReference());
                if (alignToSetting == null || alignToSetting.getCurrentDisableState().get()) continue;
                currentStatus = BootUtils.isValueAligned(valueToTest, alignToSetting);
            }
        }
        return currentStatus;
    }

    public static @Nullable LimitValuesSetting getEnabledLimitValuesConstraint(ArrayDataBinder arrayItem, IntegerSetting integerSetting) {
        for (ConstraintsRefs.LimitValuesRef limitValuesRef : integerSetting.getLimitValuesRefs()) {
            LimitValuesSetting limitRange = arrayItem.getLimitValuesConstraintById(limitValuesRef.getLimitValuesReference());
            if (limitRange == null || limitRange.getCurrentDisableState().get()) continue;
            return limitRange;
        }
        return null;
    }

    public static boolean isIntegerValueInRange(ArrayDataBinder arrayItem, IntegerSetting integerSetting, long valueToTest) {
        boolean currentStatus = true;
        LimitValuesSetting limitRange = BootUtils.getEnabledLimitValuesConstraint(arrayItem, integerSetting);
        if (limitRange != null) {
            currentStatus = BootUtils.isValueInRange(valueToTest, limitRange);
        }
        return currentStatus;
    }

    public static @Nullable AlignToValueSetting getEnabledAlignToConstraint(ArrayDataBinder arrayItem, IntegerSetting integerSetting) {
        for (ConstraintsRefs.AlignToValueRef reference : integerSetting.getAlignToValueRefs()) {
            AlignToValueSetting constraint = arrayItem.getAlignToValueConstraintById(reference.getAlignToValueReference());
            if (constraint == null || constraint.getCurrentDisableState().get()) continue;
            return constraint;
        }
        return null;
    }

    public static boolean isIntegerValueAligned(ArrayDataBinder arrayItem, IntegerSetting integerSetting, long valueToTest) {
        boolean currentStatus = true;
        AlignToValueSetting alignToValue = BootUtils.getEnabledAlignToConstraint(arrayItem, integerSetting);
        if (alignToValue != null) {
            currentStatus = BootUtils.isValueAligned(valueToTest, alignToValue);
        }
        return currentStatus;
    }

    public static void checkComponentOptions(ArrayDataBinder arrayItem, ABaseComponentSetting componentSetting) {
        if (!componentSetting.getOptions().isEmpty()) {
            Pattern OPTION_PATTERN = Pattern.compile("(\\w*)(=)'(\\w*)'");
            for (String option : componentSetting.getOptionsList()) {
                Matcher matcher = OPTION_PATTERN.matcher(option);
                assert (matcher != null);
                if (!matcher.matches() || matcher.groupCount() <= 2) continue;
                String optionComponentId = matcher.group(1);
                String optionComponentValue = matcher.group(3);
                if (optionComponentId == null || optionComponentValue == null) continue;
                BoolSetting optionBool = arrayItem.getBoolSettingById(optionComponentId);
                if (optionBool != null) {
                    boolean boolValue = "true".equalsIgnoreCase(optionComponentValue);
                    optionBool.setCurrentSelection(boolValue);
                    optionBool.setValueToWrite(boolValue ? 1 : 0);
                    continue;
                }
                EnumSetting optionEnum = arrayItem.getEnumSettingById(optionComponentId);
                if (optionEnum != null) {
                    EnumSetting.ItemSetting selectedItem = optionEnum.getItemById(optionComponentValue);
                    if (selectedItem == null) continue;
                    optionEnum.setCurrentSelection(selectedItem.getLabel());
                    optionEnum.setValueToWrite(selectedItem.getItemValue());
                    continue;
                }
                IntegerSetting optionInteger = arrayItem.getIntegerSettingById(optionComponentId);
                if (optionInteger == null) continue;
                optionInteger.setValueToWrite(Long.decode(optionComponentValue));
            }
        }
    }

    public static void updateArrayDataView(ArrayDataView dataView) {
        ArrayDataBinder dataBinder = dataView.getDataBinder();
        for (BoolSetting boolSetting : dataBinder.getBoolSettings()) {
            CheckBox boolCk = dataView.getCheckBoxById(boolSetting.getId());
            if (boolCk == null) continue;
            boolCk.setSelected(boolSetting.getCurrentSelection());
        }
        for (EnumSetting enumSetting : dataBinder.getEnumSettings()) {
            ValidatedComboBox<String> enumCmb = dataView.getComboBoxById(enumSetting.getId());
            if (enumCmb == null) continue;
            enumCmb.getSelectionModel().select((Object)enumSetting.getCurrentSelection());
        }
        for (IntegerSetting integerSetting : dataBinder.getIntegerSettings()) {
            AValidatedTextField integerTxt = dataView.getTextFieldById(integerSetting.getId());
            if (integerTxt == null) continue;
            integerTxt.setText("0x" + Long.toHexString(integerSetting.getValueToWrite()));
        }
    }

    public static void resetComboBoxStyle(ComboBox<String> comboBox) {
        comboBox.getStyleClass().clear();
        comboBox.getStyleClass().add((Object)"combo-box-base");
        comboBox.getStyleClass().add((Object)"combo-box");
    }

    public static int getMaximumSizeOfInputFileSetting(InputFileSetting inputFile, @Nullable ConstraintsSetting constraints) {
        int inputFileMaxSize = 0;
        ConstraintsRefs constraintsRefs = inputFile.getConstraintsRefs();
        if (constraintsRefs != null && constraints != null) {
            for (ConstraintsRefs.LimitValuesRef limitValuesRef : constraintsRefs.getLimitValuesRefList()) {
                LimitValuesSetting limitValues = constraints.getLimitValuesById(limitValuesRef.getLimitValuesReference());
                if (limitValues == null || (long)inputFileMaxSize >= limitValues.getMaxLimitValue()) continue;
                inputFileMaxSize = (int)limitValues.getMaxLimitValue();
            }
        }
        return inputFileMaxSize;
    }

    public static @Nullable BoolSetting getBoolSettingById(StructSetting parentStructure, String id) {
        for (BoolSetting boolSetting : parentStructure.getBoolSettingList()) {
            if (!boolSetting.getId().equals(id)) continue;
            return boolSetting;
        }
        for (StructSetting childStructSetting : parentStructure.getStructSettingList()) {
            BoolSetting boolSetting = BootUtils.getBoolSettingById(childStructSetting, id);
            if (boolSetting == null) continue;
            return boolSetting;
        }
        return null;
    }

    public static @Nullable EnumSetting getEnumSettingById(StructSetting parentStructure, String id) {
        for (EnumSetting enumSetting : parentStructure.getEnumSettingList()) {
            if (!enumSetting.getId().equals(id)) continue;
            return enumSetting;
        }
        for (StructSetting childStructSetting : parentStructure.getStructSettingList()) {
            EnumSetting enumSetting = BootUtils.getEnumSettingById(childStructSetting, id);
            if (enumSetting == null) continue;
            return enumSetting;
        }
        return null;
    }

    public static @Nullable IntegerSetting getIntegerSettingById(StructSetting parentStructure, String id) {
        for (IntegerSetting integerSetting : parentStructure.getIntegerSettingList()) {
            if (!integerSetting.getId().equals(id)) continue;
            return integerSetting;
        }
        for (StructSetting childStructSetting : parentStructure.getStructSettingList()) {
            IntegerSetting integerSetting = BootUtils.getIntegerSettingById(childStructSetting, id);
            if (integerSetting == null) continue;
            return integerSetting;
        }
        return null;
    }

    public static @Nullable InputSetting getInputSettingById(StructSetting parentStructure, String id) {
        for (InputSetting inputSetting : parentStructure.getInputSettingList()) {
            if (!inputSetting.getId().equals(id)) continue;
            return inputSetting;
        }
        for (StructSetting childStructSetting : parentStructure.getStructSettingList()) {
            InputSetting inputSetting = BootUtils.getInputSettingById(childStructSetting, id);
            if (inputSetting == null) continue;
            return inputSetting;
        }
        return null;
    }

    public static @Nullable InputFileSetting getInputFileSettingById(StructSetting parentStructure, String id) {
        for (InputFileSetting inputSetting : parentStructure.getInputFiles()) {
            if (!inputSetting.getId().equals(id)) continue;
            return inputSetting;
        }
        for (StructSetting childStructSetting : parentStructure.getStructSettingList()) {
            InputFileSetting inputSetting = BootUtils.getInputFileSettingById(childStructSetting, id);
            if (inputSetting == null) continue;
            return inputSetting;
        }
        return null;
    }

    public static @Nullable ABaseCustomComponentSetting getCustomComponentSettingById(StructSetting parentStructure, String id) {
        BoolSetting boolSetting = BootUtils.getBoolSettingById(parentStructure, id);
        if (boolSetting != null) {
            return boolSetting;
        }
        EnumSetting enumSetting = BootUtils.getEnumSettingById(parentStructure, id);
        if (enumSetting != null) {
            return enumSetting;
        }
        IntegerSetting integerSetting = BootUtils.getIntegerSettingById(parentStructure, id);
        if (integerSetting != null) {
            return integerSetting;
        }
        return null;
    }

    public static void resetStructToInitialValues(StructSetting structSetting) {
        for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
            enumSetting.setCurrentSelection(enumSetting.getInitValue());
            for (EnumSetting.ItemSetting item : enumSetting.getItems()) {
                if (!item.getId().equalsIgnoreCase(enumSetting.getInitValue())) continue;
                enumSetting.setCurrentSelection(item.getLabel());
            }
        }
        for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
            boolSetting.setCurrentSelection("true".equals(boolSetting.getInitValue()));
        }
        for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
            long initValue = 0L;
            if (NumberFormatValidator.isValidXmlHexFormat((String)integerSetting.getInitValue())) {
                initValue = NumberFormatValidator.getDecimalLongFromXmlHex((String)integerSetting.getInitValue());
            } else if (NumberFormatValidator.isValidDecimal((String)integerSetting.getInitValue())) {
                initValue = NumberFormatValidator.getIntFromStringDecimal((String)integerSetting.getInitValue());
            }
            integerSetting.setValueToWrite(initValue);
        }
        for (InputFileSetting inputFile : structSetting.getInputFiles()) {
            inputFile.setCurrentValue(inputFile.getInitValue());
            ImageSegment cleanImageSegment = new ImageSegment(inputFile.getId(), 0, 0, null);
            inputFile.setImageSegment(cleanImageSegment);
        }
        for (StructSetting childStructSetting : structSetting.getStructSettingList()) {
            BootUtils.resetStructToInitialValues(childStructSetting);
        }
    }

    public static long resolveComponentExpression(ExpressionComponents expressionComponents, String expression) {
        long expressionResult = -1L;
        if (!expression.equals("")) {
            String[] valueExpressionElements = expression.split("[-+*/]");
            String localValueExpression = expression;
            ArrayList<@NonNull ExpressionComponents.ExpressionComponent> expressionComponentsList = expressionComponents.getExpressionComponentsList();
            int i = 0;
            while (i < valueExpressionElements.length) {
                for (ExpressionComponents.ExpressionComponent expressionComponent : expressionComponentsList) {
                    if (!expressionComponent.getId().equals(valueExpressionElements[i])) continue;
                    localValueExpression = localValueExpression.replace(expressionComponent.getId(), String.valueOf(expressionComponent.getValue()));
                }
                ++i;
            }
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine engine = mgr.getEngineByName("JavaScript");
            if (engine != null) {
                try {
                    String valueResult = String.valueOf(engine.eval(localValueExpression));
                    if (NumberFormatValidator.isValidDecimal((String)valueResult)) {
                        expressionResult = Long.parseLong(valueResult);
                    }
                }
                catch (NumberFormatException | ScriptException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        return expressionResult;
    }

    public static void processStructSettings(List<@NonNull StructSetting> structSettingList, ByteBuffer byteImage) {
        for (StructSetting structSetting : structSettingList) {
            BootUtils.processStructSetting(structSetting, byteImage, 0);
            BootUtils.processStructSettings(structSetting.getStructSettingList(), byteImage);
        }
    }

    public static void processStructSetting(StructSetting structSetting, ByteBuffer byteImage, int parentComponentOffset) {
        if (!structSetting.getOffset().equals("") && !structSetting.getSize().equals("")) {
            byte[] structBuffer = new byte[structSetting.getSizeValueInBytes()];
            int i = 0;
            while (i < structSetting.getSizeValueInBytes()) {
                structBuffer[i] = byteImage.get(parentComponentOffset + structSetting.getOffsetValue() + i);
                ++i;
            }
            structBuffer = NumberFormatter.convertEndianness((byte[])structBuffer, (int)structSetting.getSizeValueInBytes(), (String)structSetting.getByteOrder());
            long structValueToWrite = BootUtils.getLongValueFromByteArray(structBuffer, 0, structBuffer.length);
            BootUtils.processEnumSettings(structSetting, structBuffer, structValueToWrite);
            BootUtils.processBoolSettings(structSetting, structBuffer, structValueToWrite);
            BootUtils.processIntegerSettings(structSetting, structBuffer, structValueToWrite);
            BootUtils.processInputFileSettings(structSetting, byteImage);
        } else {
            BootUtils.resetStructToInitialValues(structSetting);
        }
    }

    private static void processIntegerSettings(StructSetting structSetting, byte[] structBuffer, long structValueToWrite) {
        for (IntegerSetting integerSetting : structSetting.getIntegerSettingList()) {
            if (integerSetting.getOffset().equals("") || integerSetting.getSize().equals("")) continue;
            long integerValueToWrite = 0L;
            if (BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(integerSetting.getSize()).matches()) {
                integerValueToWrite = BootUtils.getLongValueFromByteArray(structBuffer, integerSetting.getOffsetValue(), integerSetting.getSizeValueInBytes());
            } else if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(integerSetting.getSize()).matches()) {
                long maskValue = BootUtils.getBitsMaskValue(integerSetting.getOffsetValue(), integerSetting.getSizeValueInBits());
                integerValueToWrite = (structValueToWrite & maskValue) >> integerSetting.getOffsetValue() - integerSetting.getSizeValueInBits() + 1;
            }
            integerSetting.setValueToWrite(integerValueToWrite);
        }
    }

    private static void processEnumSettings(StructSetting structSetting, byte[] structBuffer, long structValueToWrite) {
        for (EnumSetting enumSetting : structSetting.getEnumSettingList()) {
            if (enumSetting.getOffset().equals("") || enumSetting.getSize().equals("")) continue;
            long enumValueToWrite = 0L;
            if (BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(enumSetting.getSize()).matches()) {
                enumValueToWrite = BootUtils.getLongValueFromByteArray(structBuffer, enumSetting.getOffsetValue(), enumSetting.getSizeValueInBytes());
            } else if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(enumSetting.getSize()).matches()) {
                long maskValue = BootUtils.getBitsMaskValue(enumSetting.getOffsetValue(), enumSetting.getSizeValueInBits());
                enumValueToWrite = (structValueToWrite & maskValue) >> enumSetting.getOffsetValue() - enumSetting.getSizeValueInBits() + 1;
            }
            enumSetting.setValueToWrite(enumValueToWrite);
            for (EnumSetting.ItemSetting item : enumSetting.getItems()) {
                if (item.getItemValue() != enumValueToWrite) continue;
                enumSetting.setCurrentSelection(item.getLabel());
            }
        }
    }

    private static void processBoolSettings(StructSetting structSetting, byte[] structBuffer, long structValueToWrite) {
        for (BoolSetting boolSetting : structSetting.getBoolSettingList()) {
            long longValue;
            if (boolSetting.getOffset().equals("") || boolSetting.getSize().equals("")) continue;
            long boolValueToWrite = 0L;
            if (BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(boolSetting.getSize()).matches()) {
                boolValueToWrite = BootUtils.getLongValueFromByteArray(structBuffer, boolSetting.getOffsetValue(), boolSetting.getSizeValueInBytes());
            } else if (BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(boolSetting.getSize()).matches()) {
                long maskValue = BootUtils.getBitsMaskValue(boolSetting.getOffsetValue(), boolSetting.getSizeValueInBits());
                boolValueToWrite = (structValueToWrite & maskValue) >> boolSetting.getOffsetValue();
            }
            boolSetting.setValueToWrite(boolValueToWrite);
            String currentStValue = "";
            ByteBuffer boolByteBuffer = boolSetting.getBytesToWrite();
            currentStValue = boolByteBuffer != null ? ((longValue = new BigInteger(1, boolByteBuffer.array()).longValue()) == boolValueToWrite ? "true" : "false") : (boolValueToWrite == 1L ? "true" : "false");
            boolSetting.setCurrentSelection("true".equals(currentStValue));
        }
    }

    private static void processInputFileSettings(StructSetting structSetting, ByteBuffer byteImage) {
        for (InputFileSetting inputFile : structSetting.getInputFiles()) {
            IsFileValidResult result;
            byte[] inputFileBytes;
            ByteBuffer inputFileBuffer;
            if (inputFile.getOffset().equals("")) continue;
            int inputFileOffset = structSetting.getOffsetValue() + inputFile.getOffsetValue();
            if (!inputFile.getSize().equals("")) {
                inputFile.setSize(inputFile.getSizeValueInBytes());
            }
            if (byteImage.capacity() < inputFileOffset + inputFile.getSizeProperty().get() || (inputFileBuffer = ByteBuffer.wrap(inputFileBytes = BootUtils.getBytesFromBuffer(byteImage, inputFileOffset, inputFile.getSizeProperty().get()))) == null || !(result = BootUtils.isFileValid(inputFile.getImageHeader(), inputFileBuffer, inputFileBytes.length, null, inputFile.getImageHeader().getOffsetValue(), 0)).isFileValid()) continue;
            BootUtils.exportSettingImageToTempLocation(inputFile, inputFileBytes);
            ImageSegment inputFileImgSeg = inputFile.getImageSegment();
            if (inputFileImgSeg == null) {
                inputFileImgSeg = new ImageSegment(inputFile.getId(), inputFileOffset, inputFile.getSizeProperty().get(), ByteBuffer.wrap(inputFileBytes));
                inputFile.setImageSegment(inputFileImgSeg);
            } else {
                ByteBuffer bytes = ByteBuffer.wrap(inputFileBytes);
                if (bytes != null) {
                    inputFileImgSeg.setBufferToWrite(bytes);
                }
            }
            inputFile.setCurrentDisableState(false);
        }
    }

    public static void updateBoolSettingValueToWrite(BoolSetting boolSetting) {
        if (boolSetting.getCurrentDisableState().get()) {
            boolSetting.updateValueToWrite(false);
        } else {
            boolSetting.updateValueToWrite(boolSetting.getCurrentSelection());
        }
    }

    public static void updateEnumSettingValueToWrite(EnumSetting enumSetting, long defaultMemValue) {
        if (enumSetting.getCurrentDisableState().get()) {
            for (ABaseComponentSetting.DisableCondition disableCondition : enumSetting.getDisableConditionsList()) {
                String componentValue = disableCondition.getComponentValue();
                if (componentValue != null) {
                    enumSetting.setValueToWrite(Long.decode(Objects.requireNonNull(componentValue)));
                    continue;
                }
                enumSetting.setValueToWrite(defaultMemValue);
            }
        } else {
            EnumSetting.ItemSetting selectedItem = enumSetting.getItemByLabel(enumSetting.getCurrentSelection());
            if (selectedItem != null) {
                enumSetting.setValueToWrite(selectedItem.getItemValue());
            }
        }
    }

    public static void updateIntegerSettingValueToWrite(IntegerSetting integerSetting, long defaultMemValue) {
        if (integerSetting.getCurrentDisableState().get()) {
            for (ABaseComponentSetting.DisableCondition disableCondition : integerSetting.getDisableConditionsList()) {
                String componentValue = disableCondition.getComponentValue();
                if (componentValue != null) {
                    integerSetting.setValueToWrite(Long.decode(Objects.requireNonNull(componentValue)));
                    continue;
                }
                integerSetting.setValueToWrite(defaultMemValue);
            }
        }
    }

    public static long getTextfieldValue(TextField textfield) {
        String textFieldValue = UtilsText.safeString((String)textfield.getText().replaceAll("\\s+", ""));
        long value = -1L;
        if (NumberFormatValidator.isValidDecimal((String)textFieldValue)) {
            try {
                value = Long.parseLong(textFieldValue);
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
                value = 0L;
            }
        } else if (NumberFormatValidator.isValidHexadecimal((String)textFieldValue)) {
            value = NumberFormatter.hexadecimalToDec((String)textFieldValue);
        }
        return value;
    }

    public static BitFieldInfo createReservedBitField(int offset, int width) {
        BitFieldInfo newBitFieldInfo = new BitFieldInfo();
        newBitFieldInfo.setAccess(AccessMode.MODE_RO);
        newBitFieldInfo.setName(UtilsText.safeString((String)Messages.Lbl_Reserved));
        newBitFieldInfo.setOffset(Integer.toString(offset));
        newBitFieldInfo.setWidth(Integer.toString(width));
        newBitFieldInfo.setDescription(UtilsText.safeString((String)Messages.Msg_ReservedBitField));
        return newBitFieldInfo;
    }

    private static void exportSettingImageToTempLocation(ABaseComponentSetting setting, byte[] settingBytes) {
        File tmpDir = UtilsFile.createTempSubDirectory((String)"boot_settings");
        if (tmpDir.exists()) {
            String filePath = UtilsFile.convertToOSPathFormat((String)(String.valueOf(tmpDir.getAbsolutePath()) + "\\temporary_" + setting.getId()));
            File selectedFile = new File(filePath);
            try {
                if (selectedFile.exists() || selectedFile.createNewFile()) {
                    selectedFile.deleteOnExit();
                    BootUtils.exportToFile(selectedFile, settingBytes);
                    InputFileSetting inputFileSetting = (InputFileSetting)setting;
                    inputFileSetting.setCurrentValue(selectedFile.getAbsolutePath());
                }
            }
            catch (IOException exception) {
                LOGGER.log(Level.WARNING, "Error while creating a new file ", exception);
            }
        }
    }

    public static void exportToFile(File selectedFile, byte[] bytesToWrite) {
        try {
            if (!selectedFile.exists() && !selectedFile.createNewFile()) {
                LOGGER.log(Level.WARNING, "Error creating new file ");
            }
            try {
                Throwable throwable = null;
                Object var3_6 = null;
                try (FileOutputStream outputStream = new FileOutputStream(selectedFile);){
                    outputStream.write(bytesToWrite);
                    outputStream.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException err) {
                LOGGER.log(Level.WARNING, "Error writing to file ", err);
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Error in the process of creating a file and writing bytes ", exception);
        }
    }

    public static List<@NonNull String> createBinaryFormatNamesList() {
        ArrayList<@NonNull String> filterNames = new ArrayList<String>();
        filterNames.add(Messages.BinaryFile);
        filterNames.add(Messages.AllTypes);
        return filterNames;
    }

    public static List<@NonNull String> createBinaryFormatExtensionsList() {
        ArrayList<@NonNull String> formatExtensions = new ArrayList<String>();
        formatExtensions.add("*.bin");
        formatExtensions.add(BootConstants.ALL_TYPES_EXTENSION);
        return formatExtensions;
    }

    public static boolean isCurrentShellModal() {
        boolean result = false;
        Display d = Display.getCurrent();
        if (d == null) {
            return result;
        }
        Shell shell = d.getActiveShell();
        if (shell == null) {
            return result;
        }
        Object data = shell.getData("boot-id");
        if (data instanceof Boolean) {
            result = (Boolean)data;
        }
        return !result && (shell.getStyle() & 0x38000) != 0;
    }

    public static String concatExtensionToFile(FileDialog fileDialogChooser, String filePath, String defaultExtension) {
        int extensionStartIndex;
        String chosenFilterExtension;
        String fileExtension;
        int filterExtensionIndex = fileDialogChooser.getFilterIndex();
        String[] filterExtensions = fileDialogChooser.getFilterExtensions();
        String chosenExtensionByUser = "";
        if (filterExtensions != null) {
            if (filterExtensionIndex == -1) {
                Optional<String> filteredExtension = Arrays.asList(filterExtensions).stream().filter(e -> defaultExtension.equals(e)).findFirst();
                if (filteredExtension.isPresent()) {
                    chosenExtensionByUser = filteredExtension.get();
                }
            } else {
                chosenExtensionByUser = filterExtensions[filterExtensionIndex];
            }
        }
        if (!(fileExtension = UtilsFile.getFileExtensionWithDot((String)filePath)).equalsIgnoreCase(chosenFilterExtension = UtilsFile.getFileExtensionWithDot((String)chosenExtensionByUser))) {
            fileExtension = "";
        }
        if (UtilsText.isEmpty((String)fileExtension) && !chosenExtensionByUser.equals(BootConstants.ALL_TYPES_EXTENSION) && (extensionStartIndex = chosenFilterExtension.lastIndexOf(".") + 1) != -1 && extensionStartIndex < chosenFilterExtension.length()) {
            chosenFilterExtension = chosenFilterExtension.substring(extensionStartIndex);
            filePath = UtilsFile.addFileExtension((String)filePath, (String)chosenFilterExtension);
        }
        return filePath;
    }

    public static int getVersionComponentValue(String version, String componentType) {
        block13: {
            Pattern versionRegex = Pattern.compile("(\\d*).(\\d*).(\\d*)");
            Matcher versionMatcher = versionRegex.matcher(version);
            if (!versionMatcher.find() || versionMatcher.groupCount() < 3) break block13;
            switch (componentType) {
                case "major": {
                    String majorValue = versionMatcher.group(1);
                    if (majorValue == null) break;
                    return Integer.parseInt(majorValue);
                }
                case "minor": {
                    String minorValue = versionMatcher.group(2);
                    if (minorValue == null) break;
                    return Integer.parseInt(minorValue);
                }
                case "patch": {
                    String patchValue = versionMatcher.group(3);
                    if (patchValue == null) break;
                    return Integer.parseInt(patchValue);
                }
                default: {
                    return 0;
                }
            }
        }
        return 0;
    }

    public static boolean canComponentBeRandomGenerated(ABaseComponentSetting componentSetting) {
        boolean state = false;
        if (!componentSetting.getOptions().isEmpty()) {
            Pattern OPTION_PATTERN = Pattern.compile("(\\w*)(=)'(\\w*)'");
            for (String option : componentSetting.getOptionsList()) {
                Matcher matcher = OPTION_PATTERN.matcher(option);
                assert (matcher != null);
                if (!matcher.matches() || matcher.groupCount() <= 2) continue;
                String optionId = matcher.group(1);
                String optionValue = matcher.group(3);
                if (optionId == null || !"random_generation".equals(optionId) || optionValue == null) continue;
                state = "true".equalsIgnoreCase(optionValue);
            }
        }
        return state;
    }

    public static void runAndWait(Runnable runnable) {
        try {
            if (Platform.isFxApplicationThread()) {
                runnable.run();
            } else {
                FutureTask<Boolean> futureTask = new FutureTask<Boolean>(runnable, true);
                Platform.runLater(futureTask);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static @Nullable File exportImageToTempLocation(byte[] imageBytes, String fileName, @Nullable File directory) {
        File selectedFile = null;
        try {
            selectedFile = directory != null ? File.createTempFile("temporary_", fileName, directory) : File.createTempFile("temporary_", fileName);
            if (selectedFile.exists() || selectedFile.createNewFile()) {
                selectedFile.deleteOnExit();
                BootUtils.exportToFile(selectedFile, imageBytes);
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "[TOOL] Error while creating the temporary file ", exception);
        }
        return selectedFile;
    }
}

