/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.utils;

import com.nxp.swtools.bootimage.utils.Messages;
import com.nxp.swtools.utils.documentation.EnumDocSection;
import com.nxp.swtools.utils.resources.IToolsImages;
import java.net.URL;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class BootDocUtils {
    public static final String HELP_ICON = "org.eclipse.ui/icons/full/etool16/help_contents.png";

    public static HBox createHelpButton(EnumDocSection docSection) {
        Button docBtn = new Button();
        URL helpIconURL = IToolsImages.getPluginIconUrl((String)HELP_ICON);
        if (helpIconURL != null) {
            Image docBtnImg = new Image(helpIconURL.toExternalForm());
            docBtn.setGraphic((Node)new ImageView(docBtnImg));
        }
        docBtn.setTooltip(new Tooltip(Messages.Help_Message_ToolTip));
        docBtn.setOnAction(e -> BootDocUtils.openDocumentation(docSection));
        docBtn.setStyle("-fx-background-color: transparent;");
        HBox hBox = new HBox();
        hBox.getChildren().add((Object)docBtn);
        hBox.setAlignment(Pos.BASELINE_RIGHT);
        return hBox;
    }

    public static void openDocumentation(EnumDocSection docSection) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IContext context = HelpSystem.getContext((String)("HREF_CONTEXT_PREFIX." + docSection.getContextId()));
        if (context != null) {
            workbench.getHelpSystem().displayHelp(context);
        }
    }
}

