/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.utils;

import com.nxp.swtools.bootimage.utils.BinaryTablePreview;
import com.nxp.swtools.bootimage.utils.Messages;
import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.utils.swt.dialogs.BinaryContentDialog;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class BootBinaryContentDialog
extends BinaryContentDialog {
    public BootBinaryContentDialog(Shell parent, byte[] binaryContent) {
        super(parent, binaryContent);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(@NonNull Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.BinaryContentTitle);
        shell.layout(true);
        Display display = Display.getCurrent();
        if (display != null) {
            ShellProvider.setShellSize((Shell)shell, (double)0.51, (double)0.6);
            ShellProvider.centerShell((Shell)shell, (Shell)display.getActiveShell());
        }
    }

    protected Control createDialogArea(@NonNull Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        dialogComposite.setLayout((Layout)new GridLayout(2, false));
        dialogComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite codeViewerComposite = new ScrolledComposite(dialogComposite, 768);
        codeViewerComposite.setLayout((Layout)new GridLayout(2, false));
        codeViewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        FXCanvas canvas = new FXCanvas((Composite)codeViewerComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(10, 1).applyTo((Control)canvas);
        BorderPane layout = new BorderPane();
        BinaryTablePreview binaryTablePreview = new BinaryTablePreview();
        layout.setCenter(binaryTablePreview.createTableView(this.binaryContent, "binary_content_table_id", 16, null));
        Scene scene = new Scene((Parent)layout);
        canvas.setScene(scene);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)canvas, "ivt_binary_code_viewer");
        codeViewerComposite.setContent((Control)canvas);
        codeViewerComposite.setExpandHorizontal(true);
        codeViewerComposite.setExpandVertical(true);
        parent.layout(true);
        return parent;
    }
}

