/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.utils;

import com.nxp.swtools.bootimage.binders.ArrayDataBinder;
import com.nxp.swtools.bootimage.utils.ABootProblem;
import com.nxp.swtools.bootimage.validation.IProblemSource;
import com.nxp.swtools.bootimage.validation.IProblemUIContainer;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import com.nxp.swtools.validation.utils.AProblemsManager;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javafx.scene.control.Control;

public abstract class ABootProblemsManager<@NonNull T extends ABootProblem>
extends AProblemsManager<T> {
    public void clearProblems(IProblemSource source) {
        this.clearProblems(source, null);
    }

    public void clearProblems(ArrayDataBinder item, @Nullable IProblemUIContainer control) {
        ArrayList<ABootProblem> problemsList = new ArrayList<ABootProblem>();
        for (ABootProblem problem : this.getProblemsList()) {
            IProblemSource problemSource = problem.getProblemSource();
            assert (problemSource != null);
            if (!(problemSource instanceof ArrayDataBinder)) continue;
            ArrayDataBinder arrayItemProblemSource = (ArrayDataBinder)problemSource;
            if (control == null) {
                if (!arrayItemProblemSource.equals(item)) continue;
                problemsList.add(problem);
                continue;
            }
            IProblemUIContainer sourceContainer = problem.getSourceContainer();
            String sourceContainerId = "";
            if (sourceContainer instanceof Control) {
                sourceContainerId = sourceContainer.getId();
            }
            if (arrayItemProblemSource.getIndex().intValue() != item.getIndex().intValue() || !sourceContainerId.equals(control.getId())) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public void clearProblems(IProblemSource source, @Nullable ABootProblem.Type type) {
        ArrayList<ABootProblem> problemsList = new ArrayList<ABootProblem>();
        for (ABootProblem problem : this.getProblemsList()) {
            if (type != null) {
                if (!problem.getType().name().equals(type.name()) || !this.shouldRemove(problem, source)) continue;
                problemsList.add(problem);
                continue;
            }
            if (!this.shouldRemove(problem, source)) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public void clearProblemsForContainer(IProblemUIContainer container) {
        this.clearProblemsForContainer(container, null);
    }

    public void clearProblemsForContainer(IProblemUIContainer container, @Nullable ABootProblem.Type type) {
        ArrayList<ABootProblem> problemsList = new ArrayList<ABootProblem>();
        for (ABootProblem problem : this.getProblemsList()) {
            if (type != null) {
                if (!problem.getType().name().equals(type.name()) || !this.shouldRemove(problem, container)) continue;
                problemsList.add(problem);
                continue;
            }
            if (!this.shouldRemove(problem, container)) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public void clearProblems(ABootProblem.Type type) {
        ArrayList<@NonNull ABootProblem> problemsList = new ArrayList<ABootProblem>();
        for (ABootProblem problem : this.getProblemsList()) {
            if (!problem.getType().name().equals(type.name())) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }

    public List<@NonNull T> getProblemListForSource(IProblemSource source) {
        ArrayList<@NonNull ABootProblem> problemsFound = new ArrayList<ABootProblem>();
        for (ABootProblem problem : this.getProblemsList()) {
            IProblemSource problemSource = problem.getProblemSource();
            if (!source.equals(problemSource)) continue;
            problemsFound.add(problem);
        }
        return problemsFound;
    }

    public List<@NonNull T> getProblemListForContainer(IProblemUIContainer container) {
        ArrayList<@NonNull ABootProblem> problemsFound = new ArrayList<ABootProblem>();
        for (ABootProblem problem : this.getProblemsList()) {
            IProblemUIContainer problemContainer = problem.getSourceContainer();
            if (!container.equals(problemContainer)) continue;
            problemsFound.add(problem);
        }
        return problemsFound;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<@NonNull T> getProblemsListOfLevelError() {
        @NonNull List errorProblems = this.getProblemsList();
        errorProblems.removeIf(p -> p.getProblemLevel() != 2);
        return errorProblems;
    }

    public boolean hasSourceProblemOfType(IProblemSource source, ABootProblem.Type type) {
        for (ABootProblem problem : this.getProblemsList()) {
            if (!problem.getType().equals((Object)type) || !problem.getProblemSource().equals(source)) continue;
            return true;
        }
        return false;
    }

    protected void removeProblems(List<@NonNull T> problemsList) {
        if (!problemsList.isEmpty()) {
            ValidationEngineFactory.addAndRemoveProblems(null, problemsList, null);
            this.getProblemsList().removeAll(problemsList);
        }
    }

    private boolean shouldRemove(T problem, IProblemSource source) {
        return ((ABootProblem)((Object)problem)).getProblemSource().equals(source);
    }

    private boolean shouldRemove(T problem, IProblemUIContainer container) {
        IProblemUIContainer sourceContainer = ((ABootProblem)((Object)problem)).getSourceContainer();
        return sourceContainer != null && sourceContainer.equals(container);
    }

    public void clearAllProblemsForResource(String resourceId) {
        ArrayList<ABootProblem> problemsList = new ArrayList<ABootProblem>();
        for (ABootProblem problem : this.getProblemsList()) {
            if (!problem.getResource().matches(String.format("(?i).*\\b%s\\b.*", Pattern.quote(resourceId)))) continue;
            problemsList.add(problem);
        }
        this.removeProblems(problemsList);
    }
}

