/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.toolbar;

import com.nxp.swtools.bootimage.controller.ABootController;
import com.nxp.swtools.bootimage.mcu.EmptyMcu;
import com.nxp.swtools.bootimage.mcu.IMcu;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.dialog.ToolFunctionModification;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.toolbar.AFunctionManager;
import com.nxp.swtools.utils.tools.IToolFunction;
import java.util.ArrayList;
import java.util.List;

public abstract class ABootFunctionManager
extends AFunctionManager {
    protected ABootController bootController;
    protected IToolFunction toolFunction;

    public ABootFunctionManager(ABootController bootController, int eventType, String disableMessage) {
        this.bootController = bootController;
        this.toolFunction = new BootToolFunction(this.bootController, disableMessage);
        bootController.addListener(eventType, new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                ABootFunctionManager.this.updateFunctionBar();
            }
        });
    }

    public int getMaxToolFunctions() {
        return 0;
    }

    public @NonNull List<? extends @NonNull IToolFunction> getFunctions() {
        return new ArrayList();
    }

    public @NonNull IToolFunction getWorkingFunction() {
        return this.toolFunction;
    }

    public boolean removeFunction(@NonNull IToolFunction function) {
        return false;
    }

    public void setWorkingFunction(@NonNull IToolFunction function) {
    }

    public void update(@NonNull List<@NonNull ToolFunctionModification> toolFunctions) {
    }

    public void setCalledFromDefaultInit(@NonNull IToolFunction function, boolean called) {
    }

    public boolean allowMultipleCallFromInit() {
        return false;
    }

    public boolean isToolSpecificPropertiesValid(@NonNull ToolFunctionModification function, @NonNull List<@NonNull ToolFunctionModification> functions) {
        return false;
    }

    public @NonNull String getReservedFunctionName() {
        return "";
    }

    public @NonNull IToolFunction createNewFunction(@NonNull String functionName) {
        return this.toolFunction;
    }

    public @NonNull String getDefaultFunctionName() {
        return "";
    }

    public @NonNull IToolFunction copyFunction(@NonNull ToolFunctionModification functionToCopy) {
        return this.toolFunction;
    }

    public void setBootController(ABootController bootController) {
        this.bootController = bootController;
        ((BootToolFunction)this.toolFunction).setBootController(bootController);
    }

    private static class BootToolFunction
    implements IToolFunction {
        private ABootController bootController;
        private String disableMessage;

        public BootToolFunction(ABootController bootController, String disableMessage) {
            this.bootController = bootController;
            this.disableMessage = disableMessage;
        }

        public @NonNull String getName() {
            return this.getMessage();
        }

        public @NonNull String getDescription() {
            return this.getMessage();
        }

        public void setCalledFromDefaultInit(boolean calledFromDefault) {
        }

        public @Nullable String getError() {
            String status = this.getMessage();
            if (status.isEmpty()) {
                return null;
            }
            return status;
        }

        public @Nullable String getWarning() {
            return null;
        }

        public boolean isRemovable() {
            return false;
        }

        public boolean isCalledFromDefaultInit() {
            return false;
        }

        public boolean canBeCalledFromDefaultInit() {
            return false;
        }

        public @Nullable String getSettingsSummary() {
            return null;
        }

        String getMessage() {
            IMcu mcu = this.bootController.getMcu();
            if (mcu instanceof EmptyMcu) {
                return ((EmptyMcu)mcu).getReason();
            }
            if (!this.bootController.isToolEnabled().get()) {
                return UtilsText.safeString((String)this.disableMessage);
            }
            return "";
        }

        public void setName(String name) {
        }

        public void setDescription(String description) {
        }

        public void setBootController(ABootController controller) {
            this.bootController = controller;
        }
    }
}

