/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseCustomComponentSetting;
import com.nxp.swtools.bootimage.settings.ConstraintsRefs;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.ExpressionComponents;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.settings.ValueLockedSetting;
import com.nxp.swtools.bootimage.utils.BootUtils;
import com.nxp.swtools.bootimage.validation.IProblemSource;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="integer", strict=false)
public class IntegerSetting
extends ABaseCustomComponentSetting
implements IProblemSource {
    @Element(name="constraints_refs", required=false)
    @Nullable
    private @Element(name="constraints_refs", required=false) @Nullable ConstraintsRefs constraintsRefs;
    @Element(name="locked", required=false)
    @Nullable
    private @Element(name="locked", required=false) @Nullable ValueLockedSetting locked;
    @Attribute(name="read_only", required=false)
    @Nullable
    private @Attribute(name="read_only", required=false) @Nullable Boolean readOnly;
    @Attribute(name="zero_value_allowed", required=false)
    @Nullable
    private @Attribute(name="zero_value_allowed", required=false) @Nullable Boolean zeroValueAllowed;

    public IntegerSetting(String id, String label, @Nullable Description description, String offset, String size, String initValue, @Nullable ConstraintsRefs constraintsRefs, String options, @Nullable ValueLockedSetting locked, String valueExpression, @Nullable MessagesSetting messages, @Nullable Boolean readOnly, @Nullable Boolean zeroValueAllowed) {
        super(id, label, description, offset, size, initValue, -1L, options, messages, null, valueExpression);
        this.constraintsRefs = constraintsRefs;
        this.locked = locked;
        this.readOnly = readOnly;
        this.zeroValueAllowed = zeroValueAllowed;
    }

    public IntegerSetting() {
        this.constraintsRefs = null;
        this.locked = null;
        this.readOnly = null;
        this.zeroValueAllowed = null;
    }

    public @Nullable ConstraintsRefs getConstraintsRefs() {
        return this.constraintsRefs;
    }

    public List<ConstraintsRefs.AlignToValueRef> getAlignToValueRefs() {
        return this.constraintsRefs != null ? this.constraintsRefs.getAlignToValueRefList() : new ArrayList();
    }

    public List<ConstraintsRefs.LimitValuesRef> getLimitValuesRefs() {
        return this.constraintsRefs != null ? this.constraintsRefs.getLimitValuesRefList() : new ArrayList();
    }

    public List<ConstraintsRefs.ReservedValuesRef> getReservedValuesRefs() {
        return this.constraintsRefs != null ? this.constraintsRefs.getReservedValuesRefList() : new ArrayList();
    }

    public @Nullable Boolean getReadOnlyAttribute() {
        return this.readOnly;
    }

    public @Nullable Boolean getZeroValueAllowedAttribute() {
        return this.zeroValueAllowed;
    }

    public @Nullable ValueLockedSetting getLockedSetting() {
        return this.locked;
    }

    public boolean isValueLocked() {
        if (this.locked != null) {
            return this.locked.getInitialState();
        }
        return false;
    }

    public boolean hasValueExpression() {
        return !this.getValueExpression().equals("");
    }

    public long getValueExpressionResult(ExpressionComponents valueExpressionComponents) {
        return BootUtils.resolveComponentExpression(valueExpressionComponents, this.getValueExpression());
    }
}

