/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.bootimage.settings;

import com.nxp.swtools.bootimage.settings.ABaseComponentSetting;
import com.nxp.swtools.bootimage.settings.Description;
import com.nxp.swtools.bootimage.settings.MessagesSetting;
import com.nxp.swtools.bootimage.utils.BootUtils;
import com.nxp.swtools.bootimage.utils.BootXmlConstants;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.simpleframework.xml.Attribute;

public abstract class ABaseCustomComponentSetting
extends ABaseComponentSetting {
    private static final Logger LOGGER = LogManager.getLogger(ABaseCustomComponentSetting.class);
    @Attribute(name="offset", required=false)
    private String offset;
    @Attribute(name="size", required=false)
    private String size;
    @Attribute(name="bytes_to_write", required=false)
    @Nullable
    private @Attribute(name="bytes_to_write", required=false) @Nullable String bytesToWrite;
    @Attribute(name="image_component", required=false)
    @Nullable
    private @Attribute(name="image_component", required=false) @Nullable String imageComponent;

    public ABaseCustomComponentSetting(String id, String label, @Nullable Description description, String offset, String size, String initValue, long valueToWrite, String options, @Nullable MessagesSetting messages, @Nullable String imageComponent, String valueExpression) {
        super(id, label, description, initValue, options, messages, valueToWrite, valueExpression);
        this.offset = offset;
        this.size = size;
        this.bytesToWrite = null;
        this.imageComponent = imageComponent;
    }

    public ABaseCustomComponentSetting() {
        this.bytesToWrite = null;
        this.offset = "";
        this.size = "";
        this.imageComponent = null;
    }

    public String getOffset() {
        return this.offset;
    }

    public String getSize() {
        return this.size;
    }

    public int getOffsetValue() {
        int offsetVal = 0;
        if (NumberFormatValidator.isValidXmlHexFormat((String)this.offset)) {
            offsetVal = NumberFormatValidator.getDecimalIntegerFromXmlHex((String)this.offset);
        } else if (NumberFormatValidator.isValidDecimal((String)this.offset)) {
            offsetVal = NumberFormatValidator.getIntFromStringDecimal((String)this.offset);
        }
        return offsetVal;
    }

    public int getSizeValueInBytes() {
        int sizeVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BYTE_UNIT_VALUE_REGEXP.matcher(this.size);
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                sizeVal = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
            }
        }
        return sizeVal;
    }

    public int getSizeValueInBits() {
        int sizeVal = 0;
        Matcher matcher = BootXmlConstants.SIZE_BIT_UNIT_VALUE_REGEXP.matcher(this.size);
        if (matcher.matches() && matcher.groupCount() > 1) {
            try {
                sizeVal = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException err) {
                LOGGER.log(Level.WARNING, "Error parsing  ", err);
            }
        }
        if (sizeVal == 0 && this.getSizeValueInBytes() != 0) {
            sizeVal = this.getSizeValueInBytes() * 8;
        }
        return sizeVal;
    }

    public @Nullable ByteBuffer getBytesToWrite() {
        ByteBuffer bufferToWrite = null;
        if (this.bytesToWrite != null) {
            String[] tempValuesBuffer = this.bytesToWrite.split("\\,");
            bufferToWrite = ByteBuffer.allocate(tempValuesBuffer.length);
            int i = 0;
            while (i < tempValuesBuffer.length) {
                bufferToWrite.put(i, BootUtils.getLongFromHexString(tempValuesBuffer[i]).byteValue());
                ++i;
            }
        }
        return bufferToWrite;
    }

    public @Nullable String getImageComponent() {
        return this.imageComponent;
    }
}

