/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.modular.installer.core.utils;

import com.nxp.s32ds.rcp.modular.HWDevice;
import com.nxp.s32ds.rcp.modular.HWFamily;
import com.nxp.s32ds.rcp.modular.installer.core.MIPackAgregator;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class HWUtils {
    private HWUtils() {
    }

    public static Collection<HWFamily> resolveCollisionOfHWFamilies(Collection<MIPackAgregator> modularAgregatorsPacks) {
        TreeSet<HWFamily> families = new TreeSet<HWFamily>((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        for (MIPackAgregator packAgregator : modularAgregatorsPacks) {
            HashSet<HWFamily> hwFamilies = new HashSet<HWFamily>();
            HWUtils.findHwFamily(packAgregator, hwFamilies);
            for (HWFamily family : hwFamilies) {
                if (HWUtils.isDublicate(families, family)) {
                    HWFamily tempF = families.stream().filter(hwFamily -> hwFamily.equals((Object)family)).findAny().orElseThrow(NoSuchElementException::new);
                    HWFamily copyFamily = new HWFamily(family.getName());
                    for (HWDevice hWdevice : tempF.getHWDevices()) {
                        copyFamily.addHWdevice(hWdevice);
                    }
                    families.remove(family);
                    families.add(copyFamily);
                    HWUtils.addedHWDeviceToOriginalFamily(families, family);
                    continue;
                }
                families.add(family);
            }
        }
        return families;
    }

    private static void addedHWDeviceToOriginalFamily(Collection<HWFamily> families, HWFamily family) {
        for (HWFamily hwFamily : families) {
            if (!hwFamily.equals((Object)family)) continue;
            for (HWDevice hWdevice : family.getHWDevices()) {
                hwFamily.addHWdevice(hWdevice);
            }
        }
    }

    private static boolean isDublicate(Collection<HWFamily> families, HWFamily dublicateFamily) {
        return families.contains(dublicateFamily);
    }

    public static void findHwFamily(MIPackAgregator packAgregator, Collection<HWFamily> familys) {
        if (packAgregator.getAvailablePack() != null && !packAgregator.getAvailablePack().getHWFamilies().isEmpty()) {
            familys.addAll(packAgregator.getAvailablePack().getHWFamilies());
        }
        if (packAgregator.getInstalledPack() != null && !packAgregator.getInstalledPack().getHWFamilies().isEmpty()) {
            familys.addAll(packAgregator.getInstalledPack().getHWFamilies());
        }
        if (packAgregator.getUpdatePack() != null && !packAgregator.getUpdatePack().getHWFamilies().isEmpty()) {
            familys.addAll(packAgregator.getUpdatePack().getHWFamilies());
        }
    }
}

