/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.zephyrrtos.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.nxp.s32ds.tad.common.model.TadModel;
import com.nxp.s32ds.tad.common.rtos.Rtos;
import com.nxp.s32ds.tad.common.rtos.RtosAvailability;
import com.nxp.s32ds.tad.zephyrrtos.Activator;
import com.nxp.s32ds.tad.zephyrrtos.Messages;
import com.nxp.s32ds.tad.zephyrrtos.controller.ZephyrThreadsFactory;
import com.nxp.s32ds.tad.zephyrrtos.logger.ZephyrLogger;
import com.nxp.s32ds.tad.zephyrrtos.model.zephyr.ZephyrRTOS;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.MessageConsole;

public class ZephyrTadModel
extends TadModel {
    public static final String THREADS = Messages.ViewName_Threads;
    public static final ImageDescriptor ZEPHYR_IMG = Activator.getDefault().getImageDescriptor("com.nxp.s32ds.tad.zephyrrtos.image.zephyr");
    private static final String JSON_START = "{";
    private static final String JSON_END = "}";
    private static final String GET_OS_GDB_COMMAND = "thread-aware-list-supported-os --json";
    private static final String DETECTED_OS_OUTPUT_MODEL_REGEX = ".*\\{.*\\\"DetectedOS\\\":.*\\}.*";
    protected ZephyrRTOS zephyrRTOS = new ZephyrRTOS();

    public ZephyrTadModel() {
        String tadVersion = Activator.getDefault().getVersionAsString();
        this.tadConsole = new MessageConsole(String.format(Messages.Log_TadConsole, tadVersion), ZEPHYR_IMG);
        this.tadLogger = new ZephyrLogger(this.tadConsole);
        this.getLogger().clear();
        this.factories = new HashMap();
        this.factories.put(THREADS, new ZephyrThreadsFactory(this, this.memoryReader, this.variableReader, this.zephyrRTOS, this.dataCache));
    }

    protected synchronized RtosAvailability isRTOSAvailable() {
        MIConsoleStreamOutput output = this.getGdbManager().filteredSyncQueueCommand(GET_OS_GDB_COMMAND, DETECTED_OS_OUTPUT_MODEL_REGEX);
        if (output == null) {
            return RtosAvailability.NOT_USED;
        }
        String outputString = output.getCString();
        String jsonFormated = outputString.substring(outputString.indexOf(JSON_START), outputString.indexOf(JSON_END) + 1).replaceAll("\\s(?=([^\\\"]*\\\"[^\\\"]*\\\")*[^\\\"]*$)", "").replaceAll("\\\\n", "");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        SupportedOSJson json = (SupportedOSJson)gson.fromJson(jsonFormated, SupportedOSJson.class);
        boolean isZephyrSupported = json.detectedOS != null && json.detectedOS.equals("Zephyr");
        return isZephyrSupported ? RtosAvailability.AVAILABLE : RtosAvailability.NOT_USED;
    }

    protected synchronized double getRTOSVersion() {
        return 0.0;
    }

    public Rtos getRTOS() {
        return this.zephyrRTOS;
    }

    protected void initRTOS(DsfSession session) {
        this.zephyrRTOS.init();
        this.zephyrRTOS.loadConfigMacros(session);
    }

    protected void configureFromPreferences() {
        int readTimeout = Activator.getDefault().getPreferenceStore().getInt("zephyrRtosTimeout");
        this.factories.forEach((name, factory) -> factory.setReadTimeout(readTimeout));
    }

    private class SupportedOSJson {
        @SerializedName(value="DetectedOS")
        private String detectedOS;
        @SerializedName(value="SupportedOS")
        private List<String> supportedOS;

        private SupportedOSJson() {
        }

        public String getDetectedOS() {
            return this.detectedOS;
        }

        public void setDetectedOS(String detectedOS) {
            this.detectedOS = detectedOS;
        }

        public List<String> getSupportedOS() {
            return this.supportedOS;
        }

        public void setSupportedOS(List<String> supportedOS) {
            this.supportedOS = supportedOS;
        }
    }
}

