/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.utils.register;

import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkActionsRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkConditionsRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkResourcesRegistrationHelper;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkSymbolsRegistrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.toolchain.ToolChainSdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SdkToolChainsRegistrationHelper {
    private SdkToolChainsRegistrationHelper() {
    }

    static void registerToolChains(Element sdkElement, String sdkId) {
        Document document = sdkElement.getOwnerDocument();
        String toolChainsAttributeValue = sdkElement.getAttribute("toolchains");
        Set rootToolChainsIds = Arrays.stream(toolChainsAttributeValue.split(",")).map(String::trim).collect(Collectors.toSet());
        rootToolChainsIds = !rootToolChainsIds.isEmpty() ? rootToolChainsIds : Collections.singleton("");
        for (String rootToolChainId : rootToolChainsIds) {
            Element rootToolChainElement = document.createElement("toolchain");
            rootToolChainElement.setAttribute("id", rootToolChainId);
            ToolChainSdkDescriptorImplementation toolChainDescriptor = new ToolChainSdkDescriptorImplementation(rootToolChainElement, sdkId, true);
            ToolChainSdkDescriptors.addToolChainSdkDescriptor((ToolChainSdkDescriptor)toolChainDescriptor);
            SdkToolChainsRegistrationHelper.registerToolChainComponentsDescriptors(rootToolChainId, sdkElement, sdkId);
        }
        NodeList toolChainNodes = sdkElement.getElementsByTagName("toolchain");
        int i = 0;
        while (i < toolChainNodes.getLength()) {
            Node toolChainNode = toolChainNodes.item(i);
            if (sdkElement.equals(toolChainNode.getParentNode())) {
                Element toolChainElement = (Element)toolChainNode;
                String toolChainId = toolChainElement.getAttribute("id");
                ToolChainSdkDescriptorImplementation toolChainDescriptor = new ToolChainSdkDescriptorImplementation(toolChainElement, sdkId);
                ToolChainSdkDescriptors.addToolChainSdkDescriptor((ToolChainSdkDescriptor)toolChainDescriptor);
                SdkToolChainsRegistrationHelper.registerToolChainComponentsDescriptors(toolChainId, toolChainElement, sdkId);
            }
            ++i;
        }
    }

    static void unregisterToolChains(String sdkId) {
        if (!ToolChainSdkDescriptors.getToolChainSdkDescriptorsBySdkId((String)sdkId).isEmpty()) {
            ToolChainSdkDescriptors.removeToolChainSdkDescriptors((String)sdkId);
        }
    }

    private static void registerToolChainComponentsDescriptors(String toolChainId, Element holderElement, String sdkId) {
        SdkConditionsRegistrationHelper.registerConditions(holderElement, sdkId, toolChainId);
        SdkActionsRegistrationHelper.registerActions(holderElement, sdkId, toolChainId);
        SdkSymbolsRegistrationHelper.registerSymbols(holderElement, sdkId, toolChainId);
        SdkResourcesRegistrationHelper.registerResources(holderElement, sdkId, toolChainId);
    }
}

