/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.utils;

import com.nxp.s32ds.cle.ide.internal.sdk.core.IdeSdkCoreActivator;
import com.nxp.s32ds.cle.ide.internal.sdk.core.Messages;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class SdkPreferencesHelper {
    private static final String SDK_PREFERENCE_OLD_QUALIFIER = "com.freescale.s32ds.cross.sdk.support";
    private static final String SDK_PREFERENCE_OLD_KEY_PROJECT_LOCAL_SDKS = "com.freescale.s32ds.cross.sdk.support.projectLocalSDKs";

    private SdkPreferencesHelper() {
    }

    public static String getPersistedSdksXml(SdkType sdkType) {
        return ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.cle.runtime.sdk").get(SdkPreferencesHelper.getQualifiedKey(sdkType), "");
    }

    public static String getPersistedSdksXml(SdkType sdkType, String qualifier, String key) {
        return ConfigurationScope.INSTANCE.getNode(qualifier).get(SdkPreferencesHelper.getQualifiedKey(qualifier, key), "");
    }

    public static void updatePersistedSdks(SdkType sdkType) {
        try {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode("com.nxp.s32ds.cle.runtime.sdk");
            prefs.put(SdkPreferencesHelper.getQualifiedKey(sdkType), SdkDescriptors.getSdksXmlString((SdkType)sdkType));
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.SdkPreferencesHelper_error_persist_sdks, (Object)sdkType.getName()), bse);
        }
    }

    public static void updatePersistedSdks(SdkType sdkType, String qualifier, String key) {
        try {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(qualifier);
            prefs.put(SdkPreferencesHelper.getQualifiedKey(qualifier, key), SdkDescriptors.getSdksXmlString((SdkType)sdkType));
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.SdkPreferencesHelper_error_persist_sdks, (Object)sdkType.getName()), bse);
        }
    }

    public static String getPersistedProjectLocalSdksXml(IProject project) {
        return new ProjectScope(project).getNode("com.nxp.s32ds.cle.runtime.sdk").get("com.nxp.s32ds.cle.runtime.sdk.project.local.sdks", "");
    }

    public static String getPersistedProjectLocalSdksXml(IProject project, String qualifier, String key) {
        return new ProjectScope(project).getNode(qualifier).get(SdkPreferencesHelper.getQualifiedKey(qualifier, key), "");
    }

    public static void updatePersistedProjectLocalSdks(IProject project) {
        try {
            IEclipsePreferences prefs = new ProjectScope(project).getNode("com.nxp.s32ds.cle.runtime.sdk");
            String xmlConvertedToString = SdkDescriptors.getSdksXmlString((SdkType)SdkType.PROJECT_LOCAL);
            prefs.put("com.nxp.s32ds.cle.runtime.sdk.project.local.sdks", xmlConvertedToString);
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.SdkPreferencesHelper_error_persist_local_sdks, (Object)project.getName()), bse);
        }
    }

    public static void updatePersistedProjectLocalSdks(IProject project, String qualifier, String key) {
        try {
            IEclipsePreferences prefs = new ProjectScope(project).getNode(qualifier);
            String xmlConvertedToString = SdkDescriptors.getSdksXmlString((SdkType)SdkType.PROJECT_LOCAL);
            prefs.put(SdkPreferencesHelper.getQualifiedKey(qualifier, key), xmlConvertedToString);
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.SdkPreferencesHelper_error_persist_local_sdks, (Object)project.getName()), bse);
        }
    }

    public static void migratePersistedProjectLocalSdks(IProject project) {
        try {
            IEclipsePreferences oldPrefs = new ProjectScope(project).getNode(SDK_PREFERENCE_OLD_QUALIFIER);
            String sdksXmlString = oldPrefs.get(SDK_PREFERENCE_OLD_KEY_PROJECT_LOCAL_SDKS, "");
            if (sdksXmlString.isEmpty()) {
                return;
            }
            IEclipsePreferences newPrefs = new ProjectScope(project).getNode("com.nxp.s32ds.cle.runtime.sdk");
            newPrefs.put("com.nxp.s32ds.cle.runtime.sdk.project.local.sdks", sdksXmlString);
            newPrefs.flush();
            oldPrefs.remove(SDK_PREFERENCE_OLD_KEY_PROJECT_LOCAL_SDKS);
            oldPrefs.flush();
        }
        catch (BackingStoreException bse) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.SdkPreferencesHelper_error_persist_local_sdks, (Object)project.getName()), bse);
        }
    }

    private static String getQualifiedKey(SdkType sdkType) {
        switch (sdkType) {
            case EXTERNAL: {
                return "com.nxp.s32ds.cle.runtime.sdk.external.sdks";
            }
            case IMPORTED: {
                return "com.nxp.s32ds.cle.runtime.sdk.imported.sdks";
            }
            case INTERNAL: {
                return "com.nxp.s32ds.cle.runtime.sdk.internal.sdks";
            }
            case PROJECT_LOCAL: {
                return "com.nxp.s32ds.cle.runtime.sdk.project.local.sdks";
            }
            case WORKSPACE: {
                return "com.nxp.s32ds.cle.runtime.sdk.workspace.sdks";
            }
        }
        return SdkPreferencesHelper.getQualifiedKey("com.nxp.s32ds.cle.runtime.sdk", "unsupportedSdks");
    }

    private static String getQualifiedKey(String qualifier, String key) {
        return qualifier.concat(".").concat(key);
    }
}

