/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core.resource;

import com.nxp.s32ds.cle.ide.internal.sdk.core.IdeSdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.resource.processors.SdkResourceProcessor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkRegistryCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkCore;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class SdkProjectResourcesUtils {
    public static final String BACKUP_SDK_FOLDER_NAME_TEMPLATE = "%s.detach_%d";

    private SdkProjectResourcesUtils() {
    }

    public static IFile getTargetFile(ResourceSdkDescriptor sdkFile, SdkDescriptor sdk, IProject project) {
        return (IFile)SdkProjectResourcesUtils.getTargetResource(sdkFile, sdk, project);
    }

    public static IResource getTargetResource(ResourceSdkDescriptor sdkFile, SdkDescriptor sdk, IProject project) {
        return SdkProjectResourcesUtils.getTargetResource(sdkFile, sdk, project, null);
    }

    public static IResource getTargetResource(ResourceSdkDescriptor sdkResource, SdkDescriptor sdk, IProject project, SdkDescriptor holderSdk) {
        IFile targetResource = null;
        IPath resourcePath = Path.fromOSString((String)sdkResource.getPath());
        String copyPath = sdkResource.getCopyToProjectPath();
        if (copyPath.isEmpty()) {
            copyPath = null;
        }
        String renameTo = sdkResource.getRenameTo();
        if (SdkProjectResourcesUtils.isCopyToProjectRoot(copyPath)) {
            targetResource = SdkProjectResourcesUtils.isRenamed(renameTo) ? project.getFile(renameTo) : project.getFile(resourcePath.lastSegment());
        } else {
            IPath srcRelPath = resourcePath.makeRelativeTo(EnvironmentSdkCore.getResolvedSdkPath((String)sdk.getId()));
            IFolder folder = SdkProjectResourcesUtils.getFolder(srcRelPath, copyPath, sdk, project, holderSdk);
            String lastSegment = srcRelPath.lastSegment();
            if (folder != null && lastSegment != null) {
                if (resourcePath.toFile().isDirectory()) {
                    targetResource = SdkProjectResourcesUtils.isRenamed(renameTo) ? folder.getFolder(renameTo) : folder.getFolder(lastSegment);
                } else {
                    IFile iFile = targetResource = SdkProjectResourcesUtils.isRenamed(renameTo) ? folder.getFile(renameTo) : folder.getFile(lastSegment);
                }
            }
        }
        if (targetResource == null) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to resolve SDK target resource from {0} path.", (Object)sdkResource.getPath()));
        }
        return targetResource;
    }

    public static void createSdkTargetFolder(IFolder sdkTargetFolder, boolean isRealFolder, List<String> modulesFoldersNames) {
        try {
            if (sdkTargetFolder.exists() && sdkTargetFolder.isVirtual() && isRealFolder) {
                sdkTargetFolder.delete(true, null);
            }
            if (!sdkTargetFolder.exists()) {
                sdkTargetFolder.create(isRealFolder ? 1 : 8192, true, null);
            }
            if (modulesFoldersNames != null) {
                modulesFoldersNames.forEach(moduleFolderName -> SdkProjectResourcesUtils.createSdkTargetFolder(sdkTargetFolder.getFolder(moduleFolderName), isRealFolder, null));
            }
        }
        catch (CoreException ce) {
            IdeSdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable to create SDK folder {0}.", (Object)sdkTargetFolder.getName()), ce);
        }
    }

    public static void processSdkTargetResource(ResourceSdkDescriptor sdkResource, SdkDescriptor sdkToProcess, SdkDescriptor holderSdk, boolean isResourseOverriden, IProject project, SdkResourceProcessor processor) {
        IResource targetResource = SdkProjectResourcesUtils.getTargetResource(sdkResource, sdkToProcess, project, holderSdk);
        if (targetResource != null) {
            if (2 == targetResource.getType()) {
                SdkProjectResourcesUtils.processInPathFolders(targetResource, project, processor);
                processor.folder((IFolder)targetResource);
            } else if (1 == targetResource.getType()) {
                SdkProjectResourcesUtils.processInPathFolders(targetResource, project, processor);
                processor.file((IFile)targetResource, Path.fromOSString((String)sdkResource.getPath()), isResourseOverriden);
            }
        }
    }

    public static String getResourcePathString(ResourceSdkDescriptor resource, String sdkId) {
        IPath sdkBasePath = EnvironmentSdkCore.getResolvedSdkPath((String)sdkId);
        if (sdkBasePath == null || sdkBasePath.isEmpty()) {
            return null;
        }
        IPath resourcePath = Path.fromOSString((String)resource.getPath());
        IPath relative = resourcePath.makeRelativeTo(sdkBasePath);
        if (resource.isCopy()) {
            String copyPath = resource.getCopyToProjectPath();
            copyPath = !Objects.toString(copyPath, "").isEmpty() ? copyPath : null;
            String renameTo = resource.getRenameTo();
            if (copyPath != null) {
                String fileName;
                String string = fileName = SdkProjectResourcesUtils.isRenamed(renameTo) ? renameTo : resourcePath.lastSegment();
                if (SdkProjectResourcesUtils.isCopyToProjectRoot(copyPath)) {
                    return SdkProjectResourcesUtils.generateResourcePathString((IPath)new Path(fileName), "ProjDirPath");
                }
                return SdkProjectResourcesUtils.generateResourcePathString((IPath)new Path(String.valueOf(copyPath) + '/' + fileName), "ProjDirPath");
            }
            return SdkProjectResourcesUtils.getResourcePathStringBasedOnSdkEnvironment(sdkId, relative);
        }
        return SdkProjectResourcesUtils.getResourcePathStringBasedOnSdkEnvironment(sdkId, relative);
    }

    public static String generateResourcePathString(IPath path, String name) {
        String pathString = path.toString();
        if (pathString.endsWith("/") || pathString.endsWith("\\")) {
            pathString = pathString.substring(0, pathString.length() - 1);
        }
        return '\"' + VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(name, null) + '/' + pathString + '\"';
    }

    public static void refreshProjectResources(IProject project) {
        if (project != null && project.isAccessible()) {
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException ce) {
                IdeSdkCoreActivator.getInstance().logWarning("Internal error while project refresh", ce);
            }
        }
    }

    public static IStatus cleanupProjectStructure(SdkDescriptor sdkDescriptor, IProject project) {
        try {
            Collection<IPath> resourcePaths = SdkProjectResourcesUtils.collectSdkResources(sdkDescriptor, project);
            HashSet<IFolder> projectFolders = new HashSet<IFolder>();
            for (IPath filePath : resourcePaths) {
                IFile file = project.getFile(filePath);
                if (!file.exists()) continue;
                projectFolders.add((IFolder)file.getParent());
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            Iterator<Object> iterator = projectFolders.iterator();
            while (iterator.hasNext()) {
                IFolder folder;
                IFolder f = folder = (IFolder)iterator.next();
                do {
                    if (!f.exists() || f.members().length != 0) continue;
                    f.delete(true, (IProgressMonitor)new NullProgressMonitor());
                } while (!(f = f.getParent()).equals((Object)project));
            }
        }
        catch (CoreException ce) {
            IStatus errorStatus = IdeSdkCoreActivator.getInstance().createError("Unable to cleanup folders before migration due to error.", ce);
            IdeSdkCoreActivator.getInstance().log(errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    public static IStatus backupProjectStructure(SdkDescriptor sdkDescriptor, IProject project) {
        try {
            IFolder projectBackupFolder = project.getFolder(String.valueOf(project.getName()) + ".bak");
            projectBackupFolder.create(1, true, (IProgressMonitor)new NullProgressMonitor());
            String sdkTargetFolderName = SdkProjectResourcesUtils.getSdkTargetFolderName(sdkDescriptor, project);
            SdkProjectResourcesUtils.backupFolder(project, projectBackupFolder, Path.fromOSString((String)sdkTargetFolderName));
            String sdkId = sdkDescriptor.getId();
            Set projectFoldersPaths = ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId((String)sdkId).stream().map(sdkResource -> SdkProjectResourcesUtils.getTargetResourceFolderPath(sdkResource, sdkDescriptor, project)).filter(Objects::nonNull).collect(Collectors.toSet());
            for (IPath projectFolderPath : projectFoldersPaths) {
                SdkProjectResourcesUtils.backupFolder(project, projectBackupFolder, projectFolderPath);
            }
        }
        catch (CoreException ce) {
            IStatus errorStatus = IdeSdkCoreActivator.getInstance().createError("Unable to backup folders before migration due to error.", ce);
            IdeSdkCoreActivator.getInstance().log(errorStatus);
            return errorStatus;
        }
        return Status.OK_STATUS;
    }

    public static String getSdkTargetFolderName(SdkDescriptor sdkDescriptor, IProject project, String sdkMgmtVersion) {
        String sdkName = sdkDescriptor.getName();
        String sdkVersion = sdkDescriptor.getVersion();
        String sdkTargetFolderName = sdkDescriptor.getTargetFolderName();
        if (!sdkMgmtVersion.isEmpty()) {
            String sdkFolderName = String.format("%s_%s", sdkName, sdkVersion);
            return sdkTargetFolderName.isEmpty() ? sdkFolderName : String.valueOf(sdkTargetFolderName) + File.separator + sdkFolderName;
        }
        return sdkTargetFolderName.isEmpty() ? sdkName : sdkTargetFolderName;
    }

    public static String getSdkTargetFolderName(SdkDescriptor sdkDescriptor, IProject project) {
        String sdkMgmtVersion = SdkRegistryCore.getSdkManagementVersion();
        return SdkProjectResourcesUtils.getSdkTargetFolderName(sdkDescriptor, project, sdkMgmtVersion);
    }

    public static String getSdkTargetModuleFoldersName(SdkDescriptor sdkDescriptor, IProject project) {
        return SdkProjectResourcesUtils.getSdkTargetFolderName(sdkDescriptor, project, "");
    }

    public static String getSdkTargetFolderName(SdkDescriptor sdkDescriptor) {
        String sdkTargetFolderName = sdkDescriptor.getTargetFolderName();
        return sdkTargetFolderName.isEmpty() ? sdkDescriptor.getName() : sdkTargetFolderName;
    }

    public static IFolder getSdkTargetFolder(SdkDescriptor sdkDescriptor, IProject project) {
        return project.getFolder(SdkProjectResourcesUtils.getSdkTargetFolderName(sdkDescriptor, project));
    }

    public static void removeSdkFolderFromProject(SdkDescriptor sdkDescriptor, IProject project) {
        IFolder projectSdkFolder = SdkProjectResourcesUtils.getSdkTargetFolder(sdkDescriptor, project);
        if (projectSdkFolder.isVirtual()) {
            try {
                projectSdkFolder.delete(true, null);
            }
            catch (CoreException ce) {
                IdeSdkCoreActivator.getInstance().logError(ce.getMessage());
            }
        } else {
            if (!projectSdkFolder.exists()) {
                return;
            }
            try {
                String sdkTargetFolderName = SdkProjectResourcesUtils.getSdkTargetFolderName(sdkDescriptor, project);
                IFolder backupFolder = null;
                int counter = 0;
                while ((backupFolder = project.getFolder(String.format(BACKUP_SDK_FOLDER_NAME_TEMPLATE, sdkTargetFolderName, counter++))).exists()) {
                }
                projectSdkFolder.move(backupFolder.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                IdeSdkCoreActivator.getInstance().logError("Backup project SDK folder error: unable to rename folder due to errror", ce);
            }
        }
    }

    private static void backupFolder(IProject project, IFolder projectBackupFolder, IPath folderPath) throws CoreException {
        IFolder folder = project.getFolder(folderPath);
        if (!folder.exists()) {
            return;
        }
        IFolder backupProjectFolder = projectBackupFolder.getFolder(String.valueOf(folderPath.lastSegment()) + ".bak");
        backupProjectFolder.create(true, false, null);
        IPath backupFolderPath = backupProjectFolder.getFullPath();
        List members = Arrays.stream(folder.members()).filter(member -> !member.isLinked() && !member.isVirtual()).collect(Collectors.toList());
        for (IResource member2 : members) {
            IPath destinationPath = backupFolderPath.append(member2.getFullPath().lastSegment());
            member2.move(destinationPath, true, (IProgressMonitor)new NullProgressMonitor());
        }
        folder.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void processInPathFolders(IResource targetResource, IProject project, SdkResourceProcessor processor) {
        IPath srcRelPath = targetResource.getProjectRelativePath();
        if (srcRelPath != null && srcRelPath.segmentCount() > 1) {
            IFolder inPathFolder = project.getFolder(srcRelPath.segment(0));
            processor.folder(inPathFolder);
            int i = 1;
            while (i < srcRelPath.segmentCount() - 1) {
                inPathFolder = inPathFolder.getFolder(srcRelPath.segment(i));
                processor.folder(inPathFolder);
                ++i;
            }
        }
    }

    private static IFolder getFolder(IPath srcRelPath, String copyPath, SdkDescriptor sdk, IProject project, SdkDescriptor holderSdk) {
        IFolder folder = null;
        if (copyPath == null) {
            folder = holderSdk != null ? project.getFolder(SdkProjectResourcesUtils.getSdkTargetFolderName(holderSdk, project)).getFolder(SdkProjectResourcesUtils.getSdkTargetFolderName(sdk, project)) : project.getFolder(SdkProjectResourcesUtils.getSdkTargetFolderName(sdk, project));
            int i = 0;
            while (i < srcRelPath.segmentCount() - 1) {
                folder = folder.getFolder(srcRelPath.segment(i));
                ++i;
            }
        } else {
            folder = project.getFolder(copyPath);
        }
        return folder;
    }

    private static boolean isCopyToProjectRoot(String copyPath) {
        return copyPath != null && (".".equals(copyPath) || "/".equals(copyPath));
    }

    private static boolean isRenamed(String renameTo) {
        return renameTo != null && !renameTo.isEmpty();
    }

    private static String getResourcePathStringBasedOnSdkEnvironment(String sdkId, IPath sdkRootRelativePath) {
        EnvironmentSdkDescriptor environment = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkId);
        return environment != null ? SdkProjectResourcesUtils.generateResourcePathString(sdkRootRelativePath, environment.getName()) : null;
    }

    private static IPath getTargetResourceFolderPath(ResourceSdkDescriptor sdkResource, SdkDescriptor sdk, IProject project) {
        IResource resource;
        if (!sdkResource.getCopyToProjectPath().isEmpty() && (resource = SdkProjectResourcesUtils.getTargetResource(sdkResource, sdk, project)) != null) {
            IPath resourcePath = 1 == resource.getType() ? ((IFolder)resource.getParent()).getProjectRelativePath() : resource.getProjectRelativePath();
            return !resourcePath.isEmpty() ? resourcePath : null;
        }
        return null;
    }

    private static Collection<IPath> collectSdkResources(SdkDescriptor sdk, IProject project) {
        HashSet<IPath> result = new HashSet<IPath>();
        ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkId((String)sdk.getId()).stream().filter(ResourceSdkDescriptor::isCopy).map(resource -> SdkProjectResourcesUtils.getTargetResource(resource, sdk, project)).filter(Objects::nonNull).map(IResource::getProjectRelativePath).forEach(result::add);
        return result;
    }
}

