/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.sections;

import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementation;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiImplementationManager;
import com.freescale.s32ds.debug.ka.osek.view.AbstractOsekView;
import com.freescale.system.browser.model.OSAwarenessData;
import com.freescale.system.browser.ui.AbstractSection;
import com.freescale.system.browser.ui.TabbedWidgetFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.Page;

public abstract class AbstractOsekSection
extends AbstractSection
implements IDebugContextListener {
    protected StackLayout m_stackLayout;
    protected Composite m_stackPanel;
    protected Map<String, AbstractOsekView> m_procToView = new HashMap<String, AbstractOsekView>();

    public AbstractOsekSection() {
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public void createControls(Composite parent, Page page) {
        super.createControls(parent, page);
        TabbedWidgetFactory widgetFactory = this.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(parent);
        final Color fborderColor = Display.getCurrent().getSystemColor(18);
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Composite composite = (Composite)e.widget;
                Rectangle b = composite.getClientArea();
                GC gc = e.gc;
                gc.setForeground(fborderColor);
                gc.drawRectangle(b.x + 5 - 1, b.y + 4, b.width - 10 + 1, b.height - 8);
            }
        });
        this.m_stackPanel = new Composite(composite, 0);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 2);
        fd.top = new FormAttachment(0, 1);
        fd.bottom = new FormAttachment(100, 0);
        this.m_stackPanel.setLayoutData((Object)fd);
        this.m_stackLayout = new StackLayout();
        this.m_stackLayout.topControl = null;
        this.m_stackPanel.setLayout((Layout)this.m_stackLayout);
    }

    public void refresh() {
        super.refresh();
        if (this.m_stackLayout.topControl != null && !this.m_stackLayout.topControl.isDisposed()) {
            ((AbstractOsekView)this.m_stackLayout.topControl).updateView();
        }
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
    }

    public Object getSectionInput() {
        return null;
    }

    protected abstract AbstractOsekView CreateNewOsekView(Composite var1, int var2, OrtiImplementation var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSectionInput(OSAwarenessData input) {
        IRunControl.IExecutionDMContext context = input.getContext();
        if (context == null) return;
        AbstractOsekView view = this.m_procToView.get(context.getSessionId());
        if (view == null) {
            OrtiImplementation ortii = OrtiImplementationManager.getDefault().getOrtiImpl(context);
            if (ortii == null) return;
            view = this.CreateNewOsekView(this.m_stackPanel, 0, ortii);
            this.m_procToView.put(context.getSessionId(), view);
            this.addServiseListener(context.getSessionId());
        } else {
            view.updateView();
        }
        if (this.m_stackLayout.topControl == view) return;
        if (this.m_stackLayout.topControl != null && !this.m_stackLayout.topControl.isDisposed()) {
            this.m_stackLayout.topControl.setVisible(false);
        }
        this.m_stackLayout.topControl = view;
        this.m_stackLayout.topControl.setVisible(true);
        this.m_stackPanel.layout(false);
    }

    private void addServiseListener(String sessionId) {
        final DsfSession session = DsfSession.getSession((String)sessionId);
        AbstractOsekView listener = this.m_procToView.get(sessionId);
        if (session != null) {
            try {
                session.getExecutor().execute((Runnable)new DsfRunnable((Object)listener){
                    private final /* synthetic */ Object val$listener;
                    {
                        this.val$listener = object;
                    }

                    public void run() {
                        session.addServiceEventListener(this.val$listener, null);
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
        }
    }

    public void setActionBarsForTab(IActionBars actionBars) {
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void debugContextChanged(DebugContextEvent event) {
        AbstractOsekView view;
        IStructuredSelection ss;
        String sessionId = null;
        IProcess process = DebugUITools.getCurrentProcess();
        Object element = null;
        ISelection selection = event.getContext();
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (element = ss.getFirstElement()) instanceof GdbLaunch) {
            GdbLaunch launch = (GdbLaunch)element;
            sessionId = launch.getSession().getId();
        }
        if (process != null && process.isTerminated() && (view = this.m_procToView.get(sessionId)) != null) {
            this.m_procToView.remove(sessionId);
            view.dispose();
            view = null;
        }
    }
}

