/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.osek.orti.model;

import com.freescale.s32ds.debug.ka.osek.OsekAwareAdapter;
import com.freescale.s32ds.debug.ka.osek.OsekConsoleLogger;
import com.freescale.s32ds.debug.ka.osek.OsekPlugin;
import com.freescale.s32ds.debug.ka.osek.implementation.IntegerListHolder;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplAttr;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplEnumAttr;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiImplObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObject;
import com.freescale.s32ds.debug.ka.osek.implementation.OrtiObjectAttribute;
import com.freescale.s32ds.debug.ka.osek.implementation.TypeObject;
import com.freescale.s32ds.debug.ka.osek.orti.model.OrtiWellKnownTypes;
import com.freescale.s32ds.debug.ka.osek.orti.model.TraceModel;
import com.freescale.s32ds.debug.ka.osek.utils.OrtiGlobal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class OrtiImplementation {
    private boolean fLogOn = true;
    private OsekConsoleLogger fLogger;
    private OsekAwareAdapter m_osekAwareAdapter;
    private Integer m_sessionID;
    private String m_version;
    private String m_implementationName;
    private TypeObject[] m_objectTree;
    private Map<String, ImplObjectInfo> m_implObjects = new TreeMap<String, ImplObjectInfo>();
    private TraceModel fTrace;
    private Map<String, Object> m_globalLinkTags = new HashMap<String, Object>();

    public OrtiImplementation(OsekAwareAdapter osekAwareAdapter) {
        this.m_osekAwareAdapter = osekAwareAdapter;
        this.fTrace = new TraceModel(this);
    }

    public Object getGlobalObjectForTag(String tag) {
        return this.m_globalLinkTags.get(tag);
    }

    public Integer getSessionID() {
        if (this.m_sessionID == null) {
            this.m_sessionID = 0;
            if (this.m_sessionID != null) {
                this.logMessage("Register new session.");
            }
        }
        return this.m_sessionID;
    }

    public String getVersion() {
        this.m_version = this.getOsekAwareAdapter().GetOrtiVersionString();
        return this.m_version;
    }

    public String getImplementationName() {
        this.m_implementationName = this.getOsekAwareAdapter().GetImplementationName();
        this.m_globalLinkTags.put(this.m_implementationName, this.m_implementationName);
        return this.m_implementationName;
    }

    public TypeObject[] getObjectTree() {
        if (this.m_objectTree == null) {
            this.m_objectTree = this.getOsekAwareAdapter().GetObjectTree();
            if (this.m_objectTree != null) {
                TypeObject[] typeObjectArray = this.m_objectTree;
                int n = this.m_objectTree.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeObject typeo = typeObjectArray[n2];
                    this.m_globalLinkTags.put(typeo.getType(), typeo.getType());
                    String[] stringArray = typeo.getInstances();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String inst = stringArray[n4];
                        this.m_globalLinkTags.put(inst, inst);
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return this.m_objectTree;
    }

    public ImplObjectInfo getImplInfo(String typeName) {
        ImplObjectInfo implInfo = this.m_implObjects.get(typeName);
        if (implInfo == null && this.getImplementationObject(typeName) != null) {
            implInfo = this.m_implObjects.get(typeName);
        }
        return implInfo;
    }

    public OrtiImplObject getImplementationObject(String typeName) {
        OrtiImplObject implObjH;
        ImplObjectInfo implInfo = this.m_implObjects.get(typeName);
        if (implInfo == null && (implObjH = this.getOsekAwareAdapter().GetImplObject(typeName)) != null) {
            implInfo = new ImplObjectInfo();
            implInfo.implObject = implObjH;
            implInfo.ResetUpdateImplAttributes();
            this.m_implObjects.put(typeName, implInfo);
            this.m_globalLinkTags.put(typeName, implObjH);
        }
        if (implInfo != null) {
            return implInfo.implObject;
        }
        return null;
    }

    public OrtiObject[] getObjectTypeList(String typeName) {
        ImplObjectInfo implInfo = this.getImplInfo(typeName);
        if (implInfo != null) {
            OrtiObject[] objList;
            if (implInfo.objects != null && implInfo.objects.length > 0) {
                return implInfo.objects;
            }
            if (this.getImplementationObject(typeName) != null && (objList = this.getOsekAwareAdapter().GetOrtiObjects(typeName)) != null) {
                implInfo.SetObjects(objList);
                return implInfo.objects;
            }
        }
        return null;
    }

    public void updateAttributes(String typeName, int[] attrIDList) {
        ImplObjectInfo implInfo = null;
        implInfo = this.getImplInfo(typeName);
        if (implInfo != null) {
            if (implInfo.objects == null) {
                this.getObjectTypeList(typeName);
            }
            if (attrIDList != null && attrIDList.length > 0) {
                IntegerListHolder results = new IntegerListHolder();
                IntegerListHolder erroneousResultIDs = new IntegerListHolder();
                erroneousResultIDs.value.clear();
                if (this.getOsekAwareAdapter().EvaluateAttributeList(attrIDList, results, erroneousResultIDs) && results.value != null && results.getValue().length > 0) {
                    boolean containsErrors = false;
                    if (erroneousResultIDs.value != null && erroneousResultIDs.getValue().length > 0) {
                        Arrays.sort((Object[])erroneousResultIDs.getValue());
                        containsErrors = true;
                    }
                    OrtiObjectAttribute attribute = null;
                    int i = 0;
                    while (i < results.getValue().length) {
                        attribute = implInfo.GetAttributeByID(attrIDList[i]);
                        if (attribute == null) {
                            assert (false) : "incompatible return ids";
                        } else {
                            attribute.valueChanged = attribute.getValue() - results.getValue()[i] != 0;
                            attribute.setValue(results.getValue()[i]);
                            attribute.erroneous = containsErrors && Arrays.binarySearch((Object[])erroneousResultIDs.getValue(), attribute.attrID) >= 0;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public void updateAttributesForType(String typeName) {
        ImplObjectInfo implInfo = this.getImplInfo(typeName);
        if (implInfo != null) {
            int[] attrIDList = implInfo.GetToUpdateAttrIDList();
            this.updateAttributes(typeName, attrIDList);
        }
    }

    public OsekAwareAdapter getOsekAwareAdapter() {
        return this.m_osekAwareAdapter;
    }

    public void setLogOn(boolean fLogOn) {
        this.fLogOn = fLogOn;
    }

    public boolean isLogOn() {
        return this.fLogOn;
    }

    private OsekConsoleLogger getLogger() {
        if (this.fLogger == null) {
            this.fLogger = OsekPlugin.getDefault().getOsekLogConsole();
        }
        return this.fLogger;
    }

    public void logMessage(String msg) {
        this.getLogger().logMessage(String.format("[%d]%s", this.m_sessionID, msg));
    }

    public void setTrace(TraceModel fTrace) {
        this.fTrace = fTrace;
    }

    public TraceModel getTrace() {
        return this.fTrace;
    }

    public String toString() {
        return "[m_sessionID=" + this.m_sessionID + ", m_implementationName=" + this.m_implementationName + "]";
    }

    public class ImplObjectInfo {
        public OrtiImplObject implObject;
        private OrtiObject[] objects;
        private Map<String, OrtiGlobal.EnumValueShow> m_enumDisplay = new HashMap<String, OrtiGlobal.EnumValueShow>();
        private List<String> m_updateImplAttributes = new LinkedList<String>();
        private boolean m_isAttrListDirty = true;
        private int[] m_toUpdateObjAttrIds;
        private List<String> m_updateObjects = new LinkedList<String>();
        private Map<String, Map<Integer, OrtiImplEnumAttr>> m_enumCache = new HashMap<String, Map<Integer, OrtiImplEnumAttr>>();
        private List<OrtiObjectAttribute> m_toUpdateObjAttr = new LinkedList<OrtiObjectAttribute>();
        private Map<String, Object> m_localLinkTags = new HashMap<String, Object>();
        private Map<Integer, OrtiObjectAttribute> m_allObjAttributes = new HashMap<Integer, OrtiObjectAttribute>();

        public OrtiObjectAttribute GetAttributeByID(Integer id) {
            return this.m_allObjAttributes.get(id);
        }

        private void recomputeToUpdateObjAttrList() {
            if (this.objects != null) {
                this.m_toUpdateObjAttr.clear();
                OrtiObject[] ortiObjectArray = this.objects;
                int n = this.objects.length;
                int n2 = 0;
                while (n2 < n) {
                    OrtiObject obj = ortiObjectArray[n2];
                    if (this.m_updateObjects.contains(obj.name)) {
                        OrtiObjectAttribute[] ortiObjectAttributeArray = obj.getAtributes();
                        int n3 = ortiObjectAttributeArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            OrtiObjectAttribute attr = ortiObjectAttributeArray[n4];
                            if (this.m_updateImplAttributes.contains(attr.implAttribute.name) && !attr.isStatic) {
                                this.m_toUpdateObjAttr.add(attr);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }

        public void toggleObjectAttrUpdate(OrtiObject obj, String implName) {
            OrtiObjectAttribute[] ortiObjectAttributeArray = obj.getAtributes();
            int n = ortiObjectAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrtiObjectAttribute attr = ortiObjectAttributeArray[n2];
                if (attr.implAttribute.name.equals(implName) && !attr.isStatic) {
                    attr.updateValue = !attr.updateValue;
                    this.m_isAttrListDirty = true;
                }
                ++n2;
            }
        }

        public void setObjectAttrUpdate(OrtiObject obj) {
            OrtiObjectAttribute[] ortiObjectAttributeArray = obj.getAtributes();
            int n = ortiObjectAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrtiObjectAttribute attr = ortiObjectAttributeArray[n2];
                if (!attr.isStatic) {
                    attr.updateValue = true;
                    this.m_isAttrListDirty = true;
                }
                ++n2;
            }
        }

        public void SetUpdateImplAttribute(String name, boolean add) {
            if (add) {
                this.m_updateImplAttributes.add(name);
            } else {
                this.m_updateImplAttributes.remove(name);
            }
            this.m_isAttrListDirty = true;
        }

        public void ResetUpdateImplAttributes() {
            if (this.implObject != null) {
                OrtiImplAttr[] ortiImplAttrArray = this.implObject.getAtributes();
                int n = ortiImplAttrArray.length;
                int n2 = 0;
                while (n2 < n) {
                    OrtiImplAttr attr = ortiImplAttrArray[n2];
                    this.SetUpdateImplAttribute(attr.name, true);
                    this.m_localLinkTags.put(attr.name, attr);
                    if (attr.getType() == 1) {
                        this.m_enumDisplay.put(attr.getName(), OrtiGlobal.EnumValueShow.LabelValue);
                    }
                    ++n2;
                }
            }
            this.m_isAttrListDirty = true;
        }

        public void SetUpdateObject(String name, boolean add) {
            if (add) {
                this.m_updateObjects.add(name);
            } else {
                this.m_updateObjects.remove(name);
            }
            this.m_isAttrListDirty = true;
        }

        public Object[] GetUpdateObjects() {
            LinkedList<OrtiObject> updateList = new LinkedList<OrtiObject>();
            OrtiObject[] ortiObjectArray = this.objects;
            int n = this.objects.length;
            int n2 = 0;
            while (n2 < n) {
                OrtiObject obj = ortiObjectArray[n2];
                updateList.add(obj);
                ++n2;
            }
            return updateList.toArray();
        }

        public void SetObjects(OrtiObject[] object_list) {
            if (object_list != null) {
                this.objects = object_list;
                this.m_updateObjects.clear();
                OrtiObject[] ortiObjectArray = this.objects;
                int n = this.objects.length;
                int n2 = 0;
                while (n2 < n) {
                    OrtiObject obj = ortiObjectArray[n2];
                    this.m_updateObjects.add(obj.name);
                    OrtiImplementation.this.m_globalLinkTags.put(obj.name, obj);
                    OrtiObjectAttribute[] ortiObjectAttributeArray = obj.getAtributes();
                    int n3 = ortiObjectAttributeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        OrtiObjectAttribute attr = ortiObjectAttributeArray[n4];
                        if (attr != null) {
                            this.m_allObjAttributes.put(attr.attrID, attr);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }

        public int[] GetToUpdateAttrIDList() {
            if (this.m_isAttrListDirty) {
                this.recomputeToUpdateObjAttrList();
                this.m_toUpdateObjAttrIds = new int[this.m_toUpdateObjAttr.size()];
                int i = 0;
                for (OrtiObjectAttribute objAttr : this.m_toUpdateObjAttr) {
                    this.m_toUpdateObjAttrIds[i++] = objAttr.attrID;
                }
                if (this.m_toUpdateObjAttr.size() > 0) {
                    this.m_isAttrListDirty = false;
                }
            }
            return this.m_toUpdateObjAttrIds;
        }

        public String GetImplAttrDescription(String attrName) {
            String text = "No description.";
            OrtiImplAttr implAttr = null;
            OrtiImplAttr[] ortiImplAttrArray = this.implObject.getAtributes();
            int n = ortiImplAttrArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrtiImplAttr a = ortiImplAttrArray[n2];
                if (attrName.equalsIgnoreCase(a.name)) {
                    implAttr = a;
                }
                ++n2;
            }
            if (implAttr == null) {
                return text;
            }
            StringBuilder strDesc = new StringBuilder();
            strDesc.append("Attribute ");
            strDesc.append(implAttr.name);
            strDesc.append(" description:");
            if (implAttr.getDescription().length() > 0) {
                strDesc.append("\n" + implAttr.getDescription() + "\n");
            }
            strDesc.append("Type: ");
            switch (implAttr.getType()) {
                case 2: {
                    strDesc.append("C type");
                    break;
                }
                case 1: {
                    strDesc.append("Enum");
                    break;
                }
                case 3: {
                    strDesc.append("String");
                }
            }
            strDesc.append("\nTraced:" + (implAttr.isSetToTrace() ? "Yes" : "No"));
            if (implAttr.getTypeID() != 3) {
                strDesc.append("\nC-Type: " + implAttr.getCtype());
            }
            if (implAttr.getTypeID() == 1) {
                strDesc.append("\nEnum mapping:");
                for (OrtiImplEnumAttr enuma : implAttr.getEnumList()) {
                    strDesc.append("\n  " + enuma.getDescription() + " = ");
                    if (!enuma.getFormula().equals(String.valueOf(enuma.getValue()))) {
                        strDesc.append(enuma.getFormula() + " = ");
                    }
                    strDesc.append(OrtiGlobal.FormatIntAttr(enuma.getValue(), enuma.getRepresentBase(), 4));
                    if (enuma.getLinkedObjName().length() <= 0) continue;
                    strDesc.append(" : ");
                    strDesc.append(enuma.getLinkedObjName());
                }
            }
            text = strDesc.toString();
            return text;
        }

        public String GetObjectDescription(OrtiObject obj) {
            StringBuilder desc = new StringBuilder();
            desc.append(obj.name);
            desc.append(" ORTI object description:");
            desc.append("\nType: ");
            desc.append(OrtiObject.ortiType);
            desc.append("\nCurrent attribute state:");
            OrtiObjectAttribute[] ortiObjectAttributeArray = obj.getAtributes();
            int n = ortiObjectAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrtiObjectAttribute attr = ortiObjectAttributeArray[n2];
                desc.append("\n  ");
                desc.append(attr.implAttribute.name);
                desc.append(" : ");
                desc.append(this.GetAttrValueString(attr));
                ++n2;
            }
            return desc.toString();
        }

        public String GetObjectAttrDescription(String objName, String implAttrName) {
            StringBuilder desc = new StringBuilder();
            OrtiObject[] ortiObjectArray = this.objects;
            int n = this.objects.length;
            int n2 = 0;
            while (n2 < n) {
                OrtiObject obj = ortiObjectArray[n2];
                if (obj.name.equals(objName)) {
                    OrtiObjectAttribute[] ortiObjectAttributeArray = obj.getAtributes();
                    int n3 = ortiObjectAttributeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        OrtiObjectAttribute a = ortiObjectAttributeArray[n4];
                        if (a.implAttribute.name.equals(implAttrName)) {
                            desc.append(objName);
                            desc.append(" :: " + implAttrName + " object attribute description:");
                            desc.append("\nStatic: " + (a.isStatic ? "Yes" : "No"));
                            if (a.isStatic) {
                                desc.append("\nValue: " + a.formula);
                            } else {
                                desc.append("\nFormula: " + a.formula);
                                if (a.implAttribute.type == 1) {
                                    desc.append("\nRuntime value: " + this.GetEnumValueString(a));
                                    if (this.implObject.getName().equals(OrtiWellKnownTypes.OS.name()) && a.implAttribute.name.equals("SERVICETRACE")) {
                                        String state = ((long)a.getValue() & 1L) == 0L ? "exit" : "enter";
                                        desc.append("\nService routine state: " + state);
                                    }
                                } else {
                                    desc.append("\nRuntime value: " + this.GetAttrValueString(a));
                                }
                                if (a.erroneous) {
                                    desc.append(" - default value : could not evaluate formula");
                                }
                            }
                        }
                        ++n4;
                    }
                    if (desc.length() == 0) {
                        desc.append(String.format("Object '%s' doesn't declare the '%s' attribute.", objName, implAttrName));
                    }
                }
                ++n2;
            }
            return desc.toString();
        }

        public String GetAttrValueString(OrtiObjectAttribute attribute) {
            if (attribute == null) {
                return OrtiGlobal.NADigit(4);
            }
            String retStr = attribute.implAttribute.type == 3 ? attribute.formula : this.GetAttrValueString(attribute, attribute.getValue());
            return retStr;
        }

        public String GetAttrValueString(OrtiObjectAttribute attribute, int value) {
            String retStr = "";
            if (attribute.implAttribute.type == 2) {
                retStr = OrtiGlobal.FormatIntAttr(value, attribute.getRepresentBase(), attribute.getSize());
                if (attribute.erroneous) {
                    retStr = String.valueOf(retStr) + OrtiGlobal.NADigit(1);
                }
            } else if (attribute.implAttribute.type == 1) {
                retStr = this.GetEnumValueString(attribute, value);
            }
            return retStr;
        }

        private String GetEnumValueString(OrtiObjectAttribute attribute) {
            return this.GetEnumValueString(attribute, attribute.getValue());
        }

        private String GetEnumValueString(OrtiObjectAttribute attribute, int value) {
            StringBuilder retStr = new StringBuilder();
            if (attribute.implAttribute.name.equals("SERVICETRACE")) {
                value &= 0xFFFFFFFE;
            }
            value = (2 << 8 * attribute.getSize() - 1) - 1 & value;
            if (attribute.implAttribute.type == 1) {
                Map<Integer, OrtiImplEnumAttr> enumAttr = this.m_enumCache.get(attribute.implAttribute.name);
                if (enumAttr == null) {
                    OrtiImplAttr[] ortiImplAttrArray = this.implObject.getAtributes();
                    int n = ortiImplAttrArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        OrtiImplAttr implAttr = ortiImplAttrArray[n2];
                        if (implAttr.getType() == 1 && implAttr.name.equals(attribute.implAttribute.name)) {
                            enumAttr = new HashMap<Integer, OrtiImplEnumAttr>();
                            for (OrtiImplEnumAttr implE : implAttr.getEnumList()) {
                                enumAttr.put(implE.getValue(), implE);
                            }
                            this.m_enumCache.put(attribute.implAttribute.name, enumAttr);
                        }
                        ++n2;
                    }
                }
                if (enumAttr != null) {
                    OrtiImplEnumAttr implE = enumAttr.get(value);
                    if (implE != null) {
                        OrtiGlobal.EnumValueShow enumShow = this.m_enumDisplay.get(attribute.implAttribute.name);
                        if (enumShow == null) {
                            enumShow = OrtiGlobal.EnumValueShow.LabelValue;
                        }
                        if (enumShow.equals((Object)OrtiGlobal.EnumValueShow.ValueOnly) || enumShow.equals((Object)OrtiGlobal.EnumValueShow.LabelValue)) {
                            retStr.append(OrtiGlobal.FormatIntAttr(implE.getValue(), attribute.representBase, attribute.getSize()));
                        }
                        if (enumShow.equals((Object)OrtiGlobal.EnumValueShow.LabelOnly) || enumShow.equals((Object)OrtiGlobal.EnumValueShow.LabelValue)) {
                            retStr.append(" '");
                            retStr.append(implE.getDescription());
                            retStr.append("'");
                        }
                    } else {
                        retStr.append("??=");
                        retStr.append(OrtiGlobal.FormatIntAttr(attribute));
                    }
                } else {
                    retStr.append(OrtiGlobal.NADigit(attribute.getSize()));
                }
            }
            return retStr.toString();
        }

        public boolean UpdateObjectList() {
            if (this.implObject != null) {
                OrtiObject[] list = OrtiImplementation.this.getObjectTypeList(this.implObject.getName());
                return list != null;
            }
            return false;
        }

        public void UpdateAttributeValues() {
            OrtiImplementation.this.updateAttributesForType(this.implObject.getName());
        }

        public void UpdateAttributeValues(int[] attrIdList) {
            OrtiImplementation.this.updateAttributes(this.implObject.getName(), attrIdList);
        }

        public List<String> getUpdateImplAttributes() {
            return this.m_updateImplAttributes;
        }

        public List<String> getUpdateObjects() {
            return this.m_updateObjects;
        }

        public Map<String, OrtiGlobal.EnumValueShow> GetEnumDisplay() {
            return this.m_enumDisplay;
        }

        public Object GetObjectForTag(String tag) {
            Object obj = this.m_localLinkTags.get(tag);
            if (obj == null) {
                obj = OrtiImplementation.this.getGlobalObjectForTag(tag);
            }
            return obj;
        }

        public OrtiObject[] GetObjects() {
            if (this.objects == null) {
                OrtiImplementation.this.getObjectTypeList(this.implObject.getName());
            }
            return this.objects;
        }
    }
}

