/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.navigator;

import com.nxp.s32ds.cle.cdt.sdk.ui.internal.navigator.SdkUiNavigatorActivator;
import com.nxp.s32ds.cle.cdt.sdk.ui.navigator.IExtendedIncludeReference;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.module.ModuleSdkDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SdkExplorerLabelProvider
extends ColumnLabelProvider {
    private static final String INCLUDES_FOLDER_ICON = "icons/obj16/hfolder_obj.gif";
    private static final Image INCLUDE_IMAGE = new CElementImageDescriptor(CDTSharedImages.getImageDescriptor((String)"icons/obj16/hfolder_obj.gif"), 2, new Point(16, 16)).createImage();
    private final Map<ITranslationUnit, IASTComment[]> tuCommentsMap = new HashMap<ITranslationUnit, IASTComment[]>();
    private final Map<IFunctionDeclaration, String> functionCommentMap = new HashMap<IFunctionDeclaration, String>();
    private CElementLabelProvider cElementLabelProvider = new CElementLabelProvider(CElementLabelProvider.SHOW_DEFAULT | 0x100 | 1);

    public String getText(Object element) {
        if (element instanceof SdkDescriptor) {
            SdkDescriptor sdkDescriptor = (SdkDescriptor)element;
            return NLS.bind((String)"{0} v {1}", (Object)sdkDescriptor.getName(), (Object)sdkDescriptor.getVersion());
        }
        if (element instanceof ModuleSdkDescriptor) {
            return NLS.bind((String)"{0} (module)", (Object)((ModuleSdkDescriptor)element).getName());
        }
        if (element instanceof IExtendedIncludeReference) {
            return ((IExtendedIncludeReference)element).getRelativePath().toString();
        }
        return this.cElementLabelProvider.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof SdkDescriptor || element instanceof ModuleSdkDescriptor) {
            return INCLUDE_IMAGE;
        }
        return this.cElementLabelProvider.getImage(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof IFunctionDeclaration) {
            try {
                IFunctionDeclaration fd = (IFunctionDeclaration)element;
                String cmmnt = this.functionCommentMap.get(fd);
                if (cmmnt != null) {
                    return cmmnt;
                }
                ITranslationUnit tu = fd.getTranslationUnit();
                int fLoc = fd.getSourceRange().getStartLine();
                IASTComment[] comments = this.tuCommentsMap.get(tu);
                if (comments == null) {
                    comments = tu.getAST(null, 6).getComments();
                    this.tuCommentsMap.put(tu, comments);
                }
                IASTComment[] iASTCommentArray = comments;
                int n = comments.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTComment c = iASTCommentArray[n2];
                    int cLoc = c.getFileLocation().getEndingLineNumber();
                    if (fLoc - cLoc < 3) {
                        String comment = String.valueOf(c.getComment());
                        String value = String.format("%s%n%s : %s", comment, fd.getSignature(), fd.getReturnType());
                        this.functionCommentMap.put(fd, value);
                        return value;
                    }
                    ++n2;
                }
            }
            catch (CoreException ce) {
                SdkUiNavigatorActivator.getInstance().logError("Core exception", ce);
            }
        }
        return super.getToolTipText(element);
    }

    public boolean useNativeToolTip(Object object) {
        return true;
    }
}

