/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.navigator;

import com.nxp.s32ds.cle.cdt.sdk.ui.internal.navigator.SdkUiNavigatorActivator;
import com.nxp.s32ds.cle.cdt.sdk.ui.internal.navigator.processors.ADragSourceProcessor;
import com.nxp.s32ds.ext.ide.utils.OSFamily;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.ISourceManipulation;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;

public class SdkExplorerDragAdapterAssistant
extends CommonDragAdapterAssistant {
    private static final String DERIVATIVE = "derivative.h";
    private static final String INCLUDE = "#include \"";
    private static final String SDK = "\t// SDK";
    private static final String LF = "\r\n";
    private ICElement element;

    public Transfer[] getSupportedTransferTypes() {
        return new Transfer[]{TextTransfer.getInstance()};
    }

    public void dragStart(DragSourceEvent event, IStructuredSelection aSelection) {
        Object selected = aSelection.getFirstElement();
        event.doit = selected instanceof ISourceManipulation;
    }

    public boolean setDragData(DragSourceEvent event, IStructuredSelection aSelection) {
        Object selected = aSelection.getFirstElement();
        if (selected instanceof ICElement) {
            try {
                ICElement ce = (ICElement)selected;
                if (ce instanceof ITranslationUnit) {
                    event.data = "\u0000";
                    if (OSFamily.LINUX.isCurrent()) {
                        event.doit = false;
                    }
                } else {
                    String invocationString = ADragSourceProcessor.getDragSourceProcessor(ce).getFormattedInvocation();
                    event.data = invocationString != null ? invocationString : " ";
                }
                this.updateIndex(ce.getParent());
                this.element = ce;
            }
            catch (CoreException ce) {
                SdkUiNavigatorActivator.getInstance().logError("Core exception", ce);
            }
            return true;
        }
        return false;
    }

    public void dragFinished(DragSourceEvent anEvent, IStructuredSelection aSelection) {
        try {
            ITranslationUnit tu = ((ISourceReference)this.element).getTranslationUnit();
            IWorkingCopy tuToEdit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(SdkExplorerDragAdapterAssistant.getEditorInput());
            IInclude[] includes = tuToEdit.getIncludes();
            String tuPath = tu.getLocation().lastSegment();
            boolean contains = Stream.of(includes).anyMatch(inc -> inc.getIncludeName().equals(tuPath));
            if (!contains) {
                IInclude derivative = tuToEdit.getInclude(DERIVATIVE);
                IASTComment derivativeComment = null;
                boolean isReCreateDerivative = false;
                if (derivative != null) {
                    derivativeComment = SdkExplorerDragAdapterAssistant.getIncludeComment(derivative.getSourceRange().getStartLine(), (ITranslationUnit)tuToEdit);
                    tuToEdit = SdkExplorerDragAdapterAssistant.deleteInclude(derivative, derivativeComment, (ITranslationUnit)tuToEdit);
                    isReCreateDerivative = true;
                }
                IInclude first = includes.length > 0 ? includes[0] : null;
                ICElement before = first != null && !first.equals(derivative) ? first : tuToEdit.getChildren()[0];
                ISourceRange sourceRange = ((ISourceReference)before).getSourceRange();
                String contents = tuToEdit.getBuffer().getContents();
                int startPos = SdkExplorerDragAdapterAssistant.getStartPosition((ITranslationUnit)tuToEdit, sourceRange.getStartPos());
                boolean isCreateStandardInclude = false;
                if (startPos == 0) {
                    isCreateStandardInclude = true;
                } else {
                    int type = Character.getType(contents.codePointAt(startPos - 1));
                    if (type == 13 || type == 15) {
                        isCreateStandardInclude = true;
                    }
                }
                String includeName = tu.getLocation().lastSegment();
                if (isCreateStandardInclude) {
                    IInclude newInclude = tuToEdit.createInclude(includeName, false, before, null);
                    if (isReCreateDerivative) {
                        tuToEdit = SdkExplorerDragAdapterAssistant.createInclude(DERIVATIVE, derivativeComment, newInclude, (ITranslationUnit)tuToEdit);
                    }
                } else {
                    String include = INCLUDE + includeName + '\"';
                    int i = startPos;
                    while (i >= 0) {
                        int type = Character.getType(contents.codePointAt(i));
                        if (type == 13 || type == 15 || i == 0) {
                            StringBuilder sb = new StringBuilder(contents.substring(0, i));
                            if (i > 0) {
                                sb.append(LF);
                            }
                            sb.append(include).append(SDK).append(contents.substring(i));
                            tuToEdit.getBuffer().setContents(sb.toString());
                            tuToEdit.save(null, true);
                            tuToEdit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(SdkExplorerDragAdapterAssistant.getEditorInput());
                            break;
                        }
                        --i;
                    }
                    if (isReCreateDerivative) {
                        tuToEdit = SdkExplorerDragAdapterAssistant.createInclude(DERIVATIVE, derivativeComment, tuToEdit.getInclude(includeName), (ITranslationUnit)tuToEdit);
                    }
                }
                this.updateIndex((ICElement)tuToEdit);
            }
        }
        catch (CoreException ce) {
            SdkUiNavigatorActivator.getInstance().logError("Core exception", ce);
        }
    }

    protected void updateIndex(ICElement icElement) throws CoreException {
        IIndexManager indexManager = CCorePlugin.getIndexManager();
        indexManager.update(new ICElement[]{icElement}, 41);
    }

    private static ITranslationUnit deleteInclude(IInclude includeToDelete, IASTComment includeToDeleteComment, ITranslationUnit translationUnit) throws CModelException {
        if (includeToDeleteComment != null) {
            IASTFileLocation commentFileLocation = includeToDeleteComment.getFileLocation();
            int offset = commentFileLocation.getNodeOffset();
            int length = commentFileLocation.getNodeLength();
            String contents = translationUnit.getBuffer().getContents();
            if (contents != null) {
                StringBuilder sb = new StringBuilder(contents.substring(0, offset));
                sb.append(contents.substring(offset + length));
                translationUnit.getBuffer().setContents(sb.toString());
                translationUnit.save(null, true);
            }
        }
        includeToDelete.delete(true, null);
        translationUnit.save(null, true);
        return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(SdkExplorerDragAdapterAssistant.getEditorInput());
    }

    private static ITranslationUnit createInclude(String includeName, IASTComment includeComment, IInclude beforeInclude, ITranslationUnit translationUnit) throws CModelException {
        IInclude newDerivativeInclude = translationUnit.createInclude(includeName, false, (ICElement)beforeInclude, null);
        if (includeComment != null) {
            ISourceRange sourceRange = newDerivativeInclude.getSourceRange();
            int derivativeEndPos = sourceRange.getStartPos() + sourceRange.getLength();
            String contents = translationUnit.getBuffer().getContents();
            StringBuilder sb = new StringBuilder(contents.substring(0, derivativeEndPos));
            sb.append(' ');
            sb.append(includeComment.getRawSignature());
            sb.append(contents.substring(derivativeEndPos));
            translationUnit.getBuffer().setContents(sb.toString());
            translationUnit.save(null, true);
            translationUnit = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(SdkExplorerDragAdapterAssistant.getEditorInput());
        }
        return translationUnit;
    }

    private static IASTComment getIncludeComment(int includeLineNumber, ITranslationUnit translationUnit) throws CoreException {
        String fileName = translationUnit.getAST().getContainingFilename();
        return Arrays.stream(translationUnit.getAST().getComments()).filter(c -> Objects.nonNull(c.getFileLocation()) && fileName.equals(c.getFileLocation().getFileName()) && includeLineNumber == c.getFileLocation().getStartingLineNumber()).findFirst().orElse(null);
    }

    private static int getStartPosition(ITranslationUnit translationUnit, int startPos) throws CoreException {
        IASTTranslationUnit astTranslationUnit = translationUnit.getAST();
        String fileName = astTranslationUnit.getContainingFilename();
        IASTFileLocation firstCommentLocation = Arrays.stream(astTranslationUnit.getComments()).map(IASTNode::getFileLocation).filter(fl -> SdkExplorerDragAdapterAssistant.isFromFile(fl, fileName)).min((fl1, fl2) -> {
            if (fl1.getNodeOffset() > fl2.getNodeOffset()) {
                return 1;
            }
            if (fl1.getNodeOffset() < fl2.getNodeOffset()) {
                return -1;
            }
            return 0;
        }).orElse(null);
        if (firstCommentLocation != null) {
            IASTFileLocation firstElementLocation;
            int firstCommentOffset = firstCommentLocation.getNodeOffset();
            IASTNode[] elements = astTranslationUnit.getChildren();
            if (elements != null && (firstElementLocation = (IASTFileLocation)Arrays.stream(elements).map(IASTNode::getFileLocation).filter(fl -> SdkExplorerDragAdapterAssistant.isFromFile(fl, fileName) && fl.getNodeOffset() < firstCommentOffset).findFirst().orElse(null)) != null) {
                return startPos;
            }
            return firstCommentOffset + firstCommentLocation.getNodeLength();
        }
        return startPos;
    }

    private static boolean isFromFile(IASTFileLocation astFileLocation, String fileName) {
        return Objects.nonNull(astFileLocation) && fileName.equals(astFileLocation.getFileName());
    }

    private static IEditorInput getEditorInput() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return editor != null ? editor.getEditorInput() : null;
    }
}

