/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.handlers;

import com.nxp.swtools.codemanager.GeneratedCodeStatus;
import com.nxp.swtools.common.ui.utils.dialogs.ShellProvider;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.FileAccessFactory;
import com.nxp.swtools.common.utils.files.IAbstractFileAccess;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.lang.HardReferenceNonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.IConfigChangeContext;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.change.DefaultConfigChangeContext;
import com.nxp.swtools.provider.configuration.sources.IDestinationPathProvider;
import com.nxp.swtools.provider.configuration.sources.ISourceFileGenerationStatus;
import com.nxp.swtools.provider.configuration.sources.ISourceFileProviderWrapper;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.GeneratedProjectFile;
import com.nxp.swtools.provider.configuration.storage.ICustomCopyrightHeaderRead;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.toolchainproject.IGeneratedFilesStatusProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectProvider;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectWithSdk;
import com.nxp.swtools.sdkproject.ToolSourceFileProvider;
import com.nxp.swtools.sdkproject.ToolchainProjectDestinationPathProvider;
import com.nxp.swtools.sdkproject.updateprojectcode.UpdateCodeDialog;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.cdt.CDTProjectUtils;
import com.nxp.swtools.utils.command.handlers.UpdateCodeBlocker;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.progress.ProgressUtils;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.tools.ITool;
import com.nxp.swtools.utils.tools.Tools;
import com.nxp.swtools.utils.wizards.exportWizard.ExportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IEvaluationService;

@NonNullByDefault
public class UpdateCodeHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ENABLE_SERVICE_PROPERTY = "updateProjectCodeEnabled";
    private static final String COMMAND_ENABLE_SERVICE = "com.nxp.swtools.framework.updateProjectCodeEnabled";
    protected static final Logger LOGGER = LogManager.getLogger(UpdateCodeHandler.class);
    private static final int DIALOG_WAIT_TIMEOUT_MS = 1500;

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.isEnabled()) {
            GeneratedCodeStatus instance;
            boolean forceDialog = KEPreferences.showUpdateCodeDialog();
            Command cmd = event.getCommand();
            assert (cmd != null);
            if (cmd.getId().equals("com.nxp.swtools.framework.openProjectUpdateDialogCmd")) {
                forceDialog = true;
            }
            if ((instance = GeneratedCodeStatus.getInstance()).isOutOfSync()) {
                Tools.generateCodeForTools();
                instance.setCodeStatus(false);
            }
            if (forceDialog) {
                Display display = Display.getCurrent();
                assert (display != null);
                UpdateCodeHandler.waitUntilUpdated(SharedConfigurationFactory.getSharedConfigurationSingleton(), 1500);
                UpdateCodeDialog dlg = new UpdateCodeDialog(ShellProvider.getAnyShellParent((Display)display), true);
                if (dlg.open() != 0) {
                    return null;
                }
            }
            this.execUpdateProjectCode(ShellProvider.getAnyShellParent());
            if (SWToolsPlatform.isRunningInMCUXpressoIde() && forceDialog && KEPreferences.returnToDevelopAfterUpdateProject()) {
                try {
                    PerspectivesHelper.showPerspective((String)"com.nxp.mcuxpresso.swo.ui.perspective.MCXDevelopPerspective");
                }
                catch (WorkbenchException e) {
                    LOGGER.log(Level.SEVERE, "Failed to select 'Develop' perspective", e);
                }
            }
        }
        return null;
    }

    void execUpdateProjectCode(final @Nullable Shell shell) {
        UserLogger.getInstance().info(com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_ActionCaption);
        Job job = new Job("Update Code"){

            protected IStatus run(IProgressMonitor monitor) {
                return UpdateCodeHandler.updateCode(SharedConfigurationFactory.getSharedConfigurationSingleton(), shell);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static void waitUntilUpdated(ISharedConfiguration shrdConfig, int timeoutMs) {
        ProgressUtils.runWithTimeout(() -> {
            for (ToolSourceFileProvider toolSrcFileProvider : ToolSourceFileProvider.getToolSourceFileProviders()) {
                StorageTool storageTool = toolSrcFileProvider.getStorageTool();
                if (storageTool == null || !storageTool.isEnabled() || !storageTool.getUpdateCode()) continue;
                ITool tool = Tools.getTool((String)toolSrcFileProvider.getToolId());
                assert (tool != null);
                if (!tool.isProcessorSupported(shrdConfig)) continue;
                tool.waitUntilUpdated(shrdConfig);
            }
        }, (long)timeoutMs);
    }

    private static void addEntriesIntoEclipseProject(ISharedConfiguration shrdConfig, IAbstractFileAccess fileAccess) {
        IProject project;
        if (SWToolsPlatform.isRunningInEclipseIde() && (project = ConfigurationUtils.getEclipseProject((ISharedConfiguration)shrdConfig)) != null && KEPreferences.isGeneratedSourceFolder()) {
            fileAccess.addListener(path -> {
                IFolder newFolder = project.getFolder((IPath)new Path(path.toString()));
                if (newFolder != null) {
                    CDTProjectUtils.addSourceEntry((IProject)project, (IFolder)newFolder);
                    CDTProjectUtils.addIncludeEntry((IProject)project, (String)("${ProjDirPath}/" + path.toString()), (int)16);
                }
            });
        }
    }

    private static void updateToolCode(ISharedConfiguration shrdConfig, ToolSourceFileProvider toolSrcFileProvider, IToolchainProjectWithSdk toolchainProject, IAbstractFileAccess fileAccess, @Nullable Shell shell) {
        ProcessorCore selCore = shrdConfig.getCommonConfig().getSelectedCore();
        assert (selCore != null);
        StorageTool storageTool = toolSrcFileProvider.getStorageTool();
        assert (storageTool != null);
        List overrideRules = shrdConfig.getPreferences().getOutputPathOverrides();
        ToolchainProjectDestinationPathProvider emptyDestPathProvider = new ToolchainProjectDestinationPathProvider(toolchainProject, "", overrideRules);
        ToolchainProjectDestinationPathProvider destPathProvider = new ToolchainProjectDestinationPathProvider(toolchainProject, "board", overrideRules);
        ExportUtils.SetReadOnly makeReadOnly = KEPreferences.areGeneratedReadOnly() ? ExportUtils.SetReadOnly.ENABLE : ExportUtils.SetReadOnly.DISABLE;
        IToolchainProjectProvider projectProvider = shrdConfig.getToolchainProjectProvider();
        assert (projectProvider != null);
        IGeneratedFilesStatusProvider genStatusProvider = projectProvider.getGeneratedFilesStatusProvider();
        assert (genStatusProvider != null);
        ITool tool = Tools.getTool((String)toolSrcFileProvider.getToolId());
        assert (tool != null);
        tool.waitUntilUpdated(shrdConfig);
        ISourceFileProviderWrapper.ISourceGenerateResult genResult = toolSrcFileProvider.getSourceFileProvider().generate(selCore.getID(), true);
        String problem = genResult.getMessage();
        if (genResult.getStatus() != ISourceFileGenerationStatus.GenerationStatus.FATAL) {
            Collection generatedFiles = genResult.getAllGeneratedFiles();
            HashMap<@NonNull K, @NonNull V> generateFiles = new HashMap();
            HashMap<@NonNull K, @NonNull V> generateBinaryFiles = new HashMap();
            ArrayList genPrjFiles = new ArrayList();
            generatedFiles.forEach(sourceFile -> {
                java.nio.file.Path filePath = destPathProvider.getDestPathProjectRelative(sourceFile.getRelFileName());
                IGeneratedFilesStatusProvider.GeneratedFileStatus status = genStatusProvider.getGeneratedFileProjectStatus(filePath, false);
                boolean isFileDerived = genResult.isDerivedSource(sourceFile.getRelFileName());
                if (status == null && isFileDerived) {
                    HardReferenceNonNull foundPath = new HardReferenceNonNull((Object)sourceFile.getRelFilePath());
                    status = genStatusProvider.getProjectFileStatus(tool.getToolId(), foundPath, sourceFile.getAsString());
                }
                assert (status != null) : "Update code handler: generated file status is null";
                String fileName = UtilsFile.getFileNameWithExtension((java.nio.file.Path)filePath);
                boolean fileUpdateEnabled = storageTool.isProjectFileUpdateEnabled(fileName);
                genPrjFiles.add(new GeneratedProjectFile(filePath.toString(), fileUpdateEnabled, isFileDerived));
                if (fileUpdateEnabled && genStatusProvider.isNeededUpdateProjectCode(status)) {
                    assert (status.statusInfo != IGeneratedFilesStatusProvider.GeneratedFileInfo.DELETE);
                    if (sourceFile.isBinary()) {
                        generateBinaryFiles.put(filePath.toString(), sourceFile.getBytes());
                    } else {
                        generateFiles.put(filePath.toString(), sourceFile.getAsString());
                    }
                }
            });
            genStatusProvider.getGeneratedRelPathsToDelete(false, tool.getToolId()).forEach(relFilePath -> {
                String fileName = UtilsFile.getFileNameWithExtension((java.nio.file.Path)relFilePath);
                if (storageTool.isProjectFileUpdateEnabled(fileName) && toolchainProject.deleteFile(relFilePath)) {
                    genStatusProvider.requestUpdate();
                }
            });
            if (storageTool.setGeneratedProjectFiles(genPrjFiles)) {
                shrdConfig.setDirty((IConfigChangeContext)new DefaultConfigChangeContext(IConfigChangeContext.ConfigChangeType.UNKNOWN, toolSrcFileProvider.getToolId(), (Object)storageTool, com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_SetDirty_UpdPrjGenFiles));
            }
            if (!generateFiles.isEmpty() || !generateBinaryFiles.isEmpty()) {
                if (!ExportUtils.exportToFolder((IDestinationPathProvider)emptyDestPathProvider, (Collection)SourceFileProviderFactory.buildSourceFileList(generateFiles, generateBinaryFiles, (ICustomCopyrightHeaderRead)shrdConfig.getPreferences().getCustomCopyright()), (IAbstractFileAccess)fileAccess, (String)KEPreferences.getLineEnding(), (Shell)shell, (boolean)true, (ExportUtils.SetReadOnly)makeReadOnly, (boolean)true)) {
                    UpdateCodeHandler.userLog(Level.SEVERE, toolSrcFileProvider.getToolId(), com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogToolFailedUpdateSrcFiles, shell);
                } else {
                    ArrayList filePaths = new ArrayList(generateFiles.keySet());
                    filePaths.addAll(generateBinaryFiles.keySet());
                    String msg = String.valueOf(com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogToolUpdatedSrcFiles) + CollectionsUtils.formatList(filePaths, (String)", ", null);
                    UpdateCodeHandler.userLog(Level.INFO, toolSrcFileProvider.getToolId(), msg, shell);
                }
            }
        } else {
            UpdateCodeHandler.userLog(Level.SEVERE, toolSrcFileProvider.getToolId(), String.valueOf(com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogToolFailedUpdateSrcFiles) + " - " + problem, shell);
        }
    }

    private static void updateCodeForAllTools(ISharedConfiguration shrdConfig, IToolchainProjectWithSdk toolchainProject, IAbstractFileAccess fileAccess, @Nullable Shell shell) {
        ProcessorCore selCore = shrdConfig.getCommonConfig().getSelectedCore();
        assert (selCore != null);
        IToolchainProjectProvider projectProvider = shrdConfig.getToolchainProjectProvider();
        assert (projectProvider != null);
        IGeneratedFilesStatusProvider genStatusProvider = projectProvider.getGeneratedFilesStatusProvider();
        assert (genStatusProvider != null);
        genStatusProvider.getGeneratedFiles(true);
        for (ToolSourceFileProvider toolSrcFileProvider : ToolSourceFileProvider.getToolSourceFileProviders()) {
            StorageTool storageTool = toolSrcFileProvider.getStorageTool();
            if (storageTool != null && !storageTool.isEnabled()) continue;
            if (storageTool != null && storageTool.getUpdateCode()) {
                ITool tool = Tools.getTool((String)toolSrcFileProvider.getToolId());
                assert (tool != null);
                if (!tool.isProcessorSupported(shrdConfig)) {
                    UpdateCodeHandler.userLog(Level.SEVERE, toolSrcFileProvider.getToolId(), String.valueOf(com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogToolFailedUpdateSrcFiles) + " - Target processor is not supported", shell);
                    continue;
                }
                UpdateCodeHandler.updateToolCode(shrdConfig, toolSrcFileProvider, toolchainProject, fileAccess, shell);
                continue;
            }
            UpdateCodeHandler.userLog(Level.INFO, toolSrcFileProvider.getToolId(), com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogToolUpdateDisabled, shell);
        }
    }

    public static IStatus updateCode(ISharedConfiguration shrdConfig, @Nullable Shell shell) {
        IGeneratedFilesStatusProvider genFilesStsProvider;
        IAbstractFileAccess fileAccess;
        if (shrdConfig.getCommonConfig().getSelectedCore() == null) {
            assert (false);
            return Status.CANCEL_STATUS;
        }
        IToolchainProjectWithSdk toolchainProject = shrdConfig.getToolchainProject();
        if (toolchainProject == null) {
            return Status.CANCEL_STATUS;
        }
        IProject eclipseProject = toolchainProject.getEclipseProject();
        IAbstractFileAccess iAbstractFileAccess = fileAccess = eclipseProject != null ? FileAccessFactory.getEclipseProjectFileAccess((IProject)eclipseProject) : FileAccessFactory.getFileSystemAccess();
        if (SwToolsProduct.isUctProduct()) {
            UpdateCodeHandler.addEntriesIntoEclipseProject(shrdConfig, fileAccess);
        }
        UpdateCodeHandler.updateCodeForAllTools(shrdConfig, toolchainProject, fileAccess, shell);
        IToolchainProjectProvider toolchProvider = shrdConfig.getToolchainProjectProvider();
        IGeneratedFilesStatusProvider iGeneratedFilesStatusProvider = genFilesStsProvider = toolchProvider != null ? toolchProvider.getGeneratedFilesStatusProvider() : null;
        if (genFilesStsProvider != null) {
            genFilesStsProvider.requestUpdate();
        }
        if (SWToolsProperties.isHeadlessOn()) {
            ConfigurationUtils.saveConfiguration(null, (boolean)false);
        } else {
            Display display = Display.getCurrent();
            if (display == null && shell != null) {
                display = shell.getDisplay();
            }
            assert (display != null);
            ConfigurationUtils.saveConfiguration((Shell)ShellProvider.getAnyShellParent((Display)display), (boolean)false);
            UserLogger.info((String)com.nxp.swtools.sdkproject.Messages.get().UpdPrjCode_LogMexUpdated, (String)shrdConfig.getLocationOnDisk(), (Display)display);
        }
        toolchainProject.updateProjectSettings(shrdConfig, genFilesStsProvider != null ? genFilesStsProvider.getGeneratedFiles(true) : null);
        GeneratedCodeStatus.getInstance().setCodeStatus(false);
        return Status.OK_STATUS;
    }

    private static void userLog(Level level, String toolId, String msg, @Nullable Shell shell) {
        assert (level != null);
        if (SWToolsProperties.isHeadlessOn() || Level.SEVERE.equals(level)) {
            LOGGER.log(level, () -> String.valueOf(toolId) + ": " + msg);
        }
        if (!SWToolsProperties.isHeadlessOn()) {
            Display display = shell != null ? shell.getDisplay() : null;
            UserLogger.log((Level)level, (String)msg, (String)toolId, (Display)display);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        ISharedConfiguration sharedConfig = SharedConfigurationFactory.getSharedConfigurationSingleton();
        UpdateCodeBlocker blocker = UpdateCodeBlocker.getReasonBlockingUpdateProjectCode((ISharedConfiguration)sharedConfig);
        if (blocker != null) {
            element.setTooltip(blocker.description);
            if (blocker.isConfigurationProblem) {
                element.setDisabledIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/updateProjectCode_Blocked.png"));
                element.setIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/updateProjectCode_Blocked.png"));
            } else {
                element.setDisabledIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/updateProjectCode_Disabled.png"));
                element.setIcon(ToolsImages.getImageDescriptorWithUrl((String)"icons/updateProjectCode_Disabled.png"));
            }
        } else {
            boolean isPrjUpdNeeded = false;
            if (sharedConfig.isDirty()) {
                isPrjUpdNeeded = true;
                element.setTooltip(Messages.get().UpdateProjectCode_Modified);
            } else {
                Stream genFilesStrm;
                String toolThatNeedsUpdate;
                IGeneratedFilesStatusProvider genStatusProvider;
                IToolchainProjectProvider prjProvider = sharedConfig.getToolchainProjectProvider();
                if (prjProvider != null && (genStatusProvider = prjProvider.getGeneratedFilesStatusProvider()) != null && (toolThatNeedsUpdate = (String)CollectionsUtils.findAny(genFilesStrm = genStatusProvider.getGeneratedFiles(false).stream(), filePath -> {
                    IGeneratedFilesStatusProvider.GeneratedFileStatus fileSts = genStatusProvider.getGeneratedFileProjectStatus(filePath, false);
                    if (fileSts != null && genStatusProvider.isNeededUpdateProjectCode(fileSts)) {
                        return fileSts.isToolUpdateProjectCodeEnabled(UtilsFile.getFileNameWithExtension((String)filePath));
                    }
                    return false;
                })) != null) {
                    isPrjUpdNeeded = true;
                }
                if (isPrjUpdNeeded) {
                    element.setTooltip(Messages.get().UpdateProjectCode_Modified);
                } else {
                    element.setTooltip(Messages.get().UpdateProjectCode_UpToDate);
                }
            }
            element.setIcon(ToolsImages.getImageDescriptorWithUrl((String)(isPrjUpdNeeded ? "icons/updateProjectCode_Dirty.png" : "icons/updateProjectCode_Updated.png")));
        }
        UpdateCodeHandler.updateEnableState();
    }

    private static void updateEnableState() {
        IEvaluationService evaluationService;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (evaluationService = (IEvaluationService)window.getService(IEvaluationService.class)) != null) {
            evaluationService.requestEvaluation(COMMAND_ENABLE_SERVICE);
        }
    }
}

