/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework;

import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.swt.UtilsImage;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.framework.Application;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.CompoundContributionItem;

public class ToolSelect
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        return new IContributionItem[]{new Contribution()};
    }

    private static class Contribution
    extends ContributionItem {
        public void fill(Menu mainMenu, int index) {
            assert (mainMenu != null);
            String selectedTool = Application.getSelectedTool();
            SwToolsProductConfiguration.getRegisteredProductsSorted().stream().filter(tl -> PerspectivesHelper.isPerspectiveRegistered((String)tl.getPerspectiveID())).forEach(tool -> {
                MenuItem menuItem = Contribution.createToolMenu(tool, mainMenu);
                if (menuItem != null && selectedTool.equals(tool.getProductName())) {
                    menuItem.setSelection(true);
                }
            });
        }

        static @Nullable Image getToolSmallIcon(@Nullable String iconLocation) {
            Image small16;
            if (iconLocation == null) {
                return null;
            }
            if (iconLocation.endsWith("32.png") && (small16 = UtilsImage.getCachedImage((String)iconLocation.replace("32.png", "16.png"), (boolean)false)) != null) {
                return small16;
            }
            return UtilsImage.getCachedImage((String)iconLocation, (boolean)false);
        }

        private static @Nullable MenuItem createToolMenu(final @NonNull SwToolsProduct tool, @NonNull Menu toolsMenu) {
            MenuItem menuItemTool = null;
            String toolName = tool.getProductName();
            Image toolMenuIcon = Contribution.getToolSmallIcon(tool.getIconLocation());
            menuItemTool = new MenuItem(toolsMenu, 16);
            menuItemTool.setImage(toolMenuIcon);
            menuItemTool.setText(toolName);
            menuItemTool.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Application.setSelectedTool(tool);
                    Contribution.logAnalytics(tool);
                }
            });
            return menuItemTool;
        }

        protected static void logAnalytics(@NonNull SwToolsProduct tool) {
            ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
            SWToolsPlatform.getAnalytics().logUserAction(configuration.getUUID(), "command", "toolswitch", tool.getProductId());
        }
    }
}

