/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.dcd.model.settings;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.dcd.model.Messages;
import java.math.BigInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public enum ActionType {
    WRITE_VALUE("value", (addrVal, valMsk) -> valMsk, () -> Messages.get().ActionType_WriteValueTooltip),
    WRITE_CLEAR_BITS("clear_bits", (addrVal, valMsk) -> addrVal.and(valMsk.not()), () -> Messages.get().ActionType_WriteClearBitsTooltip),
    WRITE_SET_BITS("set_bits", (addrVal, valMsk) -> addrVal.or((BigInteger)valMsk), () -> Messages.get().ActionType_WriteSetBitsTooltip),
    CHECK_ALL_BITS_CLEAR("all_bits_clear", () -> Messages.get().ActionType_CheckAllBitsClearTooltip),
    CHECK_ALL_BITS_SET("all_bits_set", () -> Messages.get().ActionType_CheckAllBitsSetTooltip),
    CHECK_ANY_BIT_CLEAR("any_bit_clear", () -> Messages.get().ActionType_CheckAnyBitClearTooltip),
    CHECK_ANY_BIT_SET("any_bit_set", () -> Messages.get().ActionType_CheckAnyBitSetTooltip),
    WRITE_CLEAR_AND_SET_BITS("clear_and_set_bits", "clear and set bits", () -> Messages.get().ActionType_WriteClearAndSetBitsTooltip),
    EMPTY("empty", () -> Messages.get().ActionType_EmptyNopTooltip);

    private static final ActionType[] VALUES_ARRAY;
    private String id;
    private String name;
    @Nullable
    private BiFunction<BigInteger, BigInteger, BigInteger> operation;
    private Supplier<String> uiDescription;

    static {
        VALUES_ARRAY = new ActionType[]{WRITE_VALUE, WRITE_CLEAR_BITS, WRITE_SET_BITS, CHECK_ALL_BITS_CLEAR, CHECK_ALL_BITS_SET, CHECK_ANY_BIT_CLEAR, CHECK_ANY_BIT_SET, WRITE_CLEAR_AND_SET_BITS, EMPTY};
    }

    public static @Nullable ActionType getById(String id) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ActionType type = VALUES_ARRAY[i];
            if (type.getId().equals(id)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private ActionType(String id, BiFunction<BigInteger, BigInteger, BigInteger> operation, Supplier<String> uiDescription) {
        this(id, id, operation, uiDescription);
    }

    private ActionType(String id, Supplier<String> uiDescription) {
        this(id, id, null, uiDescription);
    }

    private ActionType(String id, String name, Supplier<String> uiDescription) {
        this(id, name, null, uiDescription);
    }

    private ActionType(@Nullable String id, String name, BiFunction<BigInteger, BigInteger, BigInteger> operation, Supplier<String> uiDescription) {
        this.id = id;
        this.name = name;
        this.operation = operation;
        this.uiDescription = uiDescription;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUiDescription() {
        return UtilsText.safeString((String)this.uiDescription.get());
    }

    @Nullable BiFunction<BigInteger, BigInteger, BigInteger> getOperation() {
        return this.operation;
    }

    public String toString() {
        return "CommandType [id=" + this.id + "]";
    }
}

