/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.collateral.internal.core.parsers;

import com.nxp.s32ds.cle.ide.collateral.internal.core.CollateralCoreActivator;
import com.nxp.s32ds.rcp.collateral.CollateralFeature;
import com.nxp.s32ds.rcp.collateral.CollateralPack;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import com.nxp.s32ds.rcp.collateral.CollateralResource;
import com.nxp.s32ds.rcp.collateral.CollateralResourceType;
import com.nxp.s32ds.rcp.collateral.CollateralTag;
import com.nxp.s32ds.rcp.collateral.core.CollateralFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.osgi.service.prefs.Preferences;

public class CollateralMementoHandler {
    public static void store(Set<String> pathLocations, CollateralRegistry collateralRegistry) {
        XMLMemento mementoRoot = XMLMemento.createWriteRoot((String)"root");
        Set allPacks = collateralRegistry.getAllPacks();
        CollateralMementoHandler.createNodePacks(collateralRegistry, mementoRoot, allPacks);
        CollateralMementoHandler.createNodeResourceTypes(collateralRegistry, mementoRoot);
        CollateralMementoHandler.createNodeCollateralTag(collateralRegistry, mementoRoot);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (StringWriter writer = new StringWriter();){
                mementoRoot.save((Writer)writer);
                CollateralCoreActivator.getInstance().getPreferenceForSoftwareManager().put("stored\u0421ollateralRegistry", writer.toString());
                CollateralCoreActivator.getInstance().savePreferences();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            CollateralCoreActivator.getInstance().logError(e.getMessage());
        }
    }

    private static void createNodeCollateralTag(CollateralRegistry collateralRegistry, XMLMemento mementoRoot) {
        Set collateralTags = collateralRegistry.getAllCollateralTag();
        if (!collateralTags.isEmpty()) {
            IMemento mementoCollateralTags = mementoRoot.createChild("tags");
            for (CollateralTag collateralTag : collateralTags) {
                IMemento mementoCollateralTag = mementoCollateralTags.createChild("tag");
                mementoCollateralTag.putString("id", collateralTag.getId());
                mementoCollateralTag.putString("name", collateralTag.getName());
                mementoCollateralTag.putString("description", collateralTag.getDescription());
                mementoCollateralTag.putString("image", collateralTag.getImagePath());
            }
        }
    }

    private static void createNodeResourceTypes(CollateralRegistry collateralRegistry, XMLMemento mementoRoot) {
        Set allResourceTypes = collateralRegistry.getAllResourceTypes();
        if (!allResourceTypes.isEmpty()) {
            IMemento mementoResourceTypes = mementoRoot.createChild("resourceTypes");
            for (CollateralResourceType collateralResourceType : allResourceTypes) {
                IMemento mementoResourceType = mementoResourceTypes.createChild("resourceType");
                mementoResourceType.putString("id", collateralResourceType.getId());
                mementoResourceType.putString("name", collateralResourceType.getName());
                mementoResourceType.putString("description", collateralResourceType.getDescription());
                mementoResourceType.putString("image", collateralResourceType.getImagePath());
            }
        }
    }

    private static void createNodePacks(CollateralRegistry collateralRegistry, XMLMemento mementoRoot, Set<CollateralPack> allPacks) {
        if (!allPacks.isEmpty()) {
            IMemento mementoPacks = mementoRoot.createChild("packs");
            for (CollateralPack collateralPack : collateralRegistry.getAllPacks()) {
                IMemento mementoPack = mementoPacks.createChild("pack");
                mementoPack.putString("id", collateralPack.getId());
                mementoPack.putString("name", collateralPack.getName());
                mementoPack.putString("description", collateralPack.getDescription());
                mementoPack.putString("image", collateralPack.getImagePath());
                if (collateralPack.getFeatures().isEmpty()) continue;
                IMemento mementoFeatures = mementoPack.createChild("features");
                for (CollateralFeature feature : collateralPack.getFeatures()) {
                    IMemento mementoFeature = mementoFeatures.createChild("feature");
                    mementoFeature.putString("id", feature.getId());
                    mementoFeature.putString("name", feature.getName());
                    mementoFeature.putString("description", feature.getDescription());
                    mementoFeature.putString("image", feature.getImagePath());
                    if (feature.getResources().isEmpty()) continue;
                    IMemento mementoResources = mementoFeature.createChild("resources");
                    for (CollateralResource resource : feature.getResources()) {
                        IMemento mementoResource = mementoResources.createChild("resource");
                        mementoResource.putString("id", resource.getId());
                        mementoResource.putString("name", resource.getName());
                        mementoResource.putString("description", resource.getDescription());
                        mementoResource.putString("image", resource.getImagePath());
                        mementoResource.putString("urlLink", resource.getUrlLink());
                        mementoResource.putString("typeId", resource.getResourceType().getId());
                        if (resource.getTags().isEmpty()) continue;
                        IMemento mementoResourceTags = mementoResource.createChild("tags");
                        for (CollateralTag tag : resource.getTags()) {
                            IMemento mementoResourceTag = mementoResourceTags.createChild("tagId");
                            mementoResourceTag.putString("tagId", tag.getId());
                        }
                    }
                }
            }
        }
    }

    public static void load(CollateralRegistry collateralRegistry) {
        Preferences preferenceForSoftwareManager = CollateralCoreActivator.getInstance().getPreferenceForSoftwareManager();
        CollateralFactory factory = CollateralFactory.INSTANCE;
        HashMap<String, CollateralResourceType> collateralId2CollateralResourceType = new HashMap<String, CollateralResourceType>();
        HashMap<String, CollateralTag> collateralId2CollateralTags = new HashMap<String, CollateralTag>();
        String string = preferenceForSoftwareManager.get("stored\u0421ollateralRegistry", "");
        Throwable throwable = null;
        Object var7_8 = null;
        try (StringReader reader = new StringReader(string);){
            try {
                IMemento mementoPacks;
                IMemento mementoTags;
                int n;
                XMLMemento mementoRoot = XMLMemento.createReadRoot((Reader)reader);
                IMemento mementoResourceTypes = mementoRoot.getChild("resourceTypes");
                if (mementoResourceTypes != null && mementoResourceTypes.getChildren().length > 0) {
                    IMemento[] iMementoArray = mementoResourceTypes.getChildren();
                    n = iMementoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemento memento = iMementoArray[n2];
                        String id = memento.getString("id");
                        String name = memento.getString("name");
                        String description = memento.getString("description");
                        String image = memento.getString("image");
                        CollateralResourceType createResourceType = factory.createResourceType(id, name, description, image);
                        collateralRegistry.addResourceType(createResourceType);
                        collateralId2CollateralResourceType.put(id, createResourceType);
                        ++n2;
                    }
                }
                if ((mementoTags = mementoRoot.getChild("tags")) != null && mementoTags.getChildren().length > 0) {
                    IMemento[] iMementoArray = mementoTags.getChildren();
                    int n3 = iMementoArray.length;
                    n = 0;
                    while (n < n3) {
                        IMemento memento = iMementoArray[n];
                        String id = memento.getString("id");
                        String name = memento.getString("name");
                        String description = memento.getString("description");
                        String image = memento.getString("image");
                        CollateralTag createTag = factory.createTag(id, name, description, image);
                        collateralRegistry.addTag(createTag);
                        collateralId2CollateralTags.put(id, createTag);
                        ++n;
                    }
                }
                if ((mementoPacks = mementoRoot.getChild("packs")) != null && mementoPacks.getChildren().length > 0) {
                    IMemento[] iMementoArray = mementoPacks.getChildren();
                    int n4 = iMementoArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        IMemento memento = iMementoArray[n5];
                        String packId = memento.getString("id");
                        String packName = memento.getString("name");
                        String packDescription = memento.getString("description");
                        String packImage = memento.getString("image");
                        CollateralPack createdPack = factory.createPack(packId, packName, packDescription, packImage);
                        IMemento mementoFeatures = memento.getChild("features");
                        if (mementoFeatures != null && mementoFeatures.getChildren().length > 0) {
                            IMemento[] iMementoArray2 = mementoFeatures.getChildren();
                            int n6 = iMementoArray2.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                IMemento mementoFeature = iMementoArray2[n7];
                                String featureId = mementoFeature.getString("id");
                                String featureName = mementoFeature.getString("name");
                                String featureDescription = mementoFeature.getString("description");
                                String featureImage = mementoFeature.getString("image");
                                CollateralFeature createFeature = factory.createFeature(featureId, featureName, featureDescription, featureImage);
                                collateralRegistry.addCollateralFeatureToPack(createFeature, createdPack);
                                IMemento mementoResources = mementoFeature.getChild("resources");
                                if (mementoResources != null && mementoResources.getChildren().length > 0) {
                                    IMemento[] iMementoArray3 = mementoResources.getChildren();
                                    int n8 = iMementoArray3.length;
                                    int n9 = 0;
                                    while (n9 < n8) {
                                        IMemento mementoResource = iMementoArray3[n9];
                                        String resourceId = mementoResource.getString("id");
                                        String resourceName = mementoResource.getString("name");
                                        String resourceDescription = mementoResource.getString("description");
                                        String resourceImage = mementoResource.getString("image");
                                        String resourceUri = mementoResource.getString("urlLink");
                                        String typeId = mementoResource.getString("typeId");
                                        CollateralResourceType collateralResourceType = (CollateralResourceType)collateralId2CollateralResourceType.get(typeId);
                                        CollateralResource createResource = factory.createResource(resourceId, resourceName, resourceDescription, resourceUri, resourceImage);
                                        collateralRegistry.setCollateralResourceTypeToResource(collateralResourceType, createResource);
                                        collateralRegistry.addCollateralResourceToFeature(createResource, createFeature);
                                        IMemento mementoTagIds = mementoResource.getChild("tags");
                                        if (mementoTagIds != null && mementoTagIds.getChildren().length > 0) {
                                            IMemento[] iMementoArray4 = mementoTagIds.getChildren();
                                            int n10 = iMementoArray4.length;
                                            int n11 = 0;
                                            while (n11 < n10) {
                                                IMemento mementoTagsId = iMementoArray4[n11];
                                                String resourceTagId = mementoTagsId.getString("tagId");
                                                CollateralTag collateralTag = (CollateralTag)collateralId2CollateralTags.get(resourceTagId);
                                                collateralRegistry.addCollateralTagToResource(collateralTag, createResource);
                                                ++n11;
                                            }
                                        }
                                        ++n9;
                                    }
                                }
                                ++n7;
                            }
                        }
                        collateralRegistry.addPack(createdPack);
                        ++n5;
                    }
                }
            }
            catch (WorkbenchException e) {
                CollateralCoreActivator.getInstance().logError(e.getMessage());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

