/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.view.SystemView;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.model.ISystemPromptableObject;
import org.eclipse.rse.ui.view.ContextObject;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ShowInSystemsViewDelegate
implements IViewActionDelegate {
    private IAction _action;
    protected Object _selectedObject;
    private SystemViewPart _systemViewPart;
    static /* synthetic */ Class class$0;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        ISubSystem subSystem;
        ISystemViewElementAdapter adapter;
        SystemViewPart viewPart = this.activateSystemView();
        SystemView systemTree = viewPart.getSystemView();
        TreeItem item = (TreeItem)systemTree.findFirstRemoteItemReference(this._selectedObject, null);
        if (item != null) {
            systemTree.getTree().setSelection(item);
        } else if (this._selectedObject instanceof IAdaptable && (adapter = ShowInSystemsViewDelegate.getAdapter((IAdaptable)this._selectedObject)) != null && (subSystem = adapter.getSubSystem(this._selectedObject)) != null) {
            if (subSystem.getSubSystemConfiguration().supportsFilters()) {
                LinkFromFilterJob job = new LinkFromFilterJob((IAdaptable)this._selectedObject, systemTree);
                job.schedule();
            } else {
                Object[] children = subSystem.getChildren();
                Display.getDefault().asyncExec((Runnable)new ShowChildrenInTree(subSystem, children, null, systemTree, (IAdaptable)this._selectedObject));
            }
        }
    }

    public SystemViewPart activateSystemView() {
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            this._systemViewPart = (SystemViewPart)page.showView("org.eclipse.rse.ui.view.systemView");
            page.bringToTop((IWorkbenchPart)this._systemViewPart);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            SystemBasePlugin.logError("Can not open system view part", e);
        }
        return this._systemViewPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        if (this._action == null) {
            this._action = action;
        }
        if ((sel = (IStructuredSelection)selection).size() == 1) {
            this._selectedObject = sel.getFirstElement();
            if (this._selectedObject instanceof ISystemPromptableObject) {
                this._selectedObject = null;
                this._action.setEnabled(false);
            } else {
                this._action.setEnabled(true);
            }
        } else {
            this._action.setEnabled(false);
        }
    }

    public static ISystemViewElementAdapter getAdapter(IAdaptable adaptable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz);
    }

    private class LinkFromContainerJob
    extends Job {
        private ISubSystem _subSystem;
        private IAdaptable _remoteContainer;
        private IAdaptable _targetRemoteObj;
        private ISystemTree _systemTree;
        private ISystemFilterReference _filterRef;

        public LinkFromContainerJob(IAdaptable remoteContainer, ISystemFilterReference filterRef, IAdaptable targetRemoteObj, ISystemTree systemTree) {
            super(NLS.bind((String)CommonMessages.MSG_RESOLVE_PROGRESS, (Object)ShowInSystemsViewDelegate.getAdapter(remoteContainer).getAbsoluteName(targetRemoteObj)));
            this._remoteContainer = remoteContainer;
            this._subSystem = this.getSubSystem(remoteContainer);
            this._filterRef = filterRef;
            this._targetRemoteObj = targetRemoteObj;
            this._systemTree = systemTree;
        }

        private ISubSystem getSubSystem(IAdaptable adaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz);
            return adapter.getSubSystem(adaptable);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)this._remoteContainer.getAdapter((Class)clazz);
                ContextObject contextObject = new ContextObject(this._remoteContainer, this._subSystem, this._filterRef);
                Object[] children = adapter.getChildren(contextObject, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().asyncExec((Runnable)new ShowChildrenInTree(this._remoteContainer, children, this._filterRef, this._systemTree, this._targetRemoteObj));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    }

    private class LinkFromFilterJob
    extends Job {
        private ISubSystem _subSystem;
        private IAdaptable _targetRemoteObj;
        private ISystemTree _systemTree;

        public LinkFromFilterJob(IAdaptable targetRemoteObject, ISystemTree systemTree) {
            super(NLS.bind((String)CommonMessages.MSG_RESOLVE_PROGRESS, (Object)ShowInSystemsViewDelegate.getAdapter(targetRemoteObject).getAbsoluteName(targetRemoteObject)));
            this._targetRemoteObj = targetRemoteObject;
            this._subSystem = this.getSubSystem(this._targetRemoteObj);
            this._systemTree = systemTree;
        }

        private ISubSystem getSubSystem(IAdaptable adaptable) {
            ISystemViewElementAdapter adapter = ShowInSystemsViewDelegate.getAdapter(adaptable);
            return adapter.getSubSystem(adaptable);
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                ISystemFilterReference ref = this.findMatchingFilterReference(this._targetRemoteObj, monitor);
                if (ref == null) {
                    return Status.OK_STATUS;
                }
                ContextObject contextObject = new ContextObject(ref, this._subSystem, ref);
                Object[] children = ShowInSystemsViewDelegate.getAdapter((IAdaptable)ref).getChildren(contextObject, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().asyncExec((Runnable)new ShowChildrenInTree(ref, children, ref, this._systemTree, this._targetRemoteObj));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }

        private ISystemFilterReference findMatchingFilterReference(IAdaptable targetObj, IProgressMonitor monitor) {
            String remoteObjectName = this.getAbsolutePath(targetObj);
            ISystemFilterPoolReferenceManager refmgr = this._subSystem.getFilterPoolReferenceManager();
            if (refmgr != null) {
                ISystemFilterReference[] refs = refmgr.getSystemFilterReferences(this._subSystem);
                int i = 0;
                while (i < refs.length) {
                    ISystemFilterReference ref = refs[i];
                    if (this.doesFilterEncompass(ref.getReferencedFilter(), remoteObjectName)) {
                        return ref;
                    }
                    ++i;
                }
                ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
                List matches = sr.findFilterReferencesFor((Object)targetObj, this._subSystem, false);
                if (matches != null && matches.size() > 0) {
                    return (ISystemFilterReference)matches.get(0);
                }
                ISystemViewElementAdapter adapter = ShowInSystemsViewDelegate.getAdapter(targetObj);
                Object parent = adapter.getParent(targetObj);
                ISystemFilterReference filterRef = this.findMatchingFilterReference((IAdaptable)parent, monitor);
                if (filterRef != null) {
                    return filterRef;
                }
            }
            return null;
        }

        private String getAbsolutePath(IAdaptable adaptable) {
            ISystemViewElementAdapter adapter = ShowInSystemsViewDelegate.getAdapter(adaptable);
            return adapter.getAbsoluteName(adaptable);
        }

        private boolean doesFilterEncompass(ISystemFilter filter, String remoteObjectAbsoluteName) {
            boolean would = false;
            String[] strings = filter.getFilterStrings();
            if (strings != null) {
                int idx = 0;
                while (!would && idx < strings.length) {
                    if (strings[idx].equals("/*")) {
                        would = true;
                    } else if (strings[idx].equals("./*")) {
                        try {
                            IAdaptable homeObj = (IAdaptable)this._subSystem.getObjectWithAbsoluteName(".", (IProgressMonitor)new NullProgressMonitor());
                            if (homeObj != null) {
                                String homePath = this.getAbsolutePath(homeObj);
                                would = remoteObjectAbsoluteName.startsWith(homePath);
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        would = this.doesFilterStringEncompass(strings[idx], remoteObjectAbsoluteName);
                    }
                    ++idx;
                }
            }
            return would;
        }

        private boolean doesFilterStringEncompass(String filterString, String remoteObjectAbsoluteName) {
            return false;
        }
    }

    private class ShowChildrenInTree
    implements Runnable {
        private Object _parentObject;
        private Object[] _children;
        private ISystemTree _systemTree;
        private IAdaptable _targetRemoteObj;
        private ISystemFilterReference _filterReference;

        public ShowChildrenInTree(Object parentObject, Object[] children, ISystemFilterReference filterReference, ISystemTree systemTree, IAdaptable targetRemoteObj) {
            this._parentObject = parentObject;
            this._children = children;
            this._systemTree = systemTree;
            this._targetRemoteObj = targetRemoteObj;
            this._filterReference = filterReference;
        }

        private String getAbsolutePath(IAdaptable adaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz);
            return adapter.getAbsoluteName(adaptable);
        }

        public void run() {
            TreeItem item;
            AbstractList matches;
            if (this._filterReference != null) {
                this._systemTree.revealAndExpand(this._filterReference.getSubSystem(), this._filterReference.getReferencedFilter());
            } else {
                matches = new ArrayList();
                this._systemTree.findAllRemoteItemReferences(this._parentObject, this._parentObject, matches);
                if (matches.size() > 0) {
                    item = (TreeItem)matches.get(0);
                    item.setExpanded(true);
                }
            }
            matches = new Vector();
            this._systemTree.findAllRemoteItemReferences(this._parentObject, this._parentObject, matches);
            if (((Vector)matches).size() > 0) {
                item = (TreeItem)((Vector)matches).get(0);
                this._systemTree.createTreeItems(item, this._children);
                item.setExpanded(true);
                IAdaptable container = null;
                String targetPath = this.getAbsolutePath(this._targetRemoteObj);
                int i = 0;
                while (i < item.getItemCount()) {
                    TreeItem childItem = item.getItem(i);
                    Object data = childItem.getData();
                    if (data instanceof IAdaptable) {
                        IAdaptable childObj = (IAdaptable)data;
                        String childPath = this.getAbsolutePath(childObj);
                        if (childPath.equals(targetPath)) {
                            this._systemTree.getTree().setSelection(childItem);
                            return;
                        }
                        if (targetPath.startsWith(childPath)) {
                            container = childObj;
                        }
                    }
                    ++i;
                }
                if (container != null) {
                    LinkFromContainerJob job = new LinkFromContainerJob(container, this._filterReference, this._targetRemoteObj, this._systemTree);
                    job.schedule();
                }
            }
        }
    }
}

