/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.data.IFragment;
import com.nxp.swtools.periphs.model.data.Param;
import com.nxp.swtools.resourcetables.model.data.AIfExpr;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Root(name="fragment", strict=false)
@Order(attributes={"id", "apply_to", "if_expr", "for_elements_of"})
public class Fragment
extends AIfExpr
implements IFragment {
    private static final Logger LOGGER = LogManager.getLogger(Fragment.class);
    private LinkedHashMap<String, Param> params;
    @Attribute(name="id", required=false)
    private String id;
    @Attribute(name="apply_to", required=false)
    private String applyTo;
    @Attribute(name="for_elements_of", required=false)
    private String forElementsOf;

    public Fragment(String id, String applyTo, String ifExpr, String forElementsOf) {
        super(ifExpr);
        this.id = id;
        this.applyTo = applyTo;
        this.forElementsOf = forElementsOf;
        this.params = new LinkedHashMap();
    }

    @Deprecated
    protected Fragment() {
        this("", "", "", "");
    }

    public String getId() {
        return this.id;
    }

    @ElementList(type=Param.class, required=false, inline=true)
    private @ElementList(type=Param.class, required=false, inline=true) List<Param> getParamsList() {
        return CollectionsUtils.listFromMapValues(this.params);
    }

    @ElementList(type=Param.class, required=false, inline=true)
    private void setParamsList(List<Param> paramsList) {
        paramsList.stream().forEachOrdered(param -> this.addParam((Param)param));
    }

    public LinkedHashMap<String, Param> getParams() {
        return this.params;
    }

    public void setParams(LinkedHashMap<String, Param> params) {
        this.params = params;
    }

    public String getApplyTo() {
        return this.applyTo;
    }

    public String getForElementsOf() {
        return this.forElementsOf;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setApplyTo(String applyTo) {
        this.applyTo = applyTo;
    }

    public void setForElementsOf(String forElementsOf) {
        this.forElementsOf = forElementsOf;
    }

    public void addParam(Param param) {
        if (this.params.put(param.getId(), param) != null) {
            LOGGER.severe(MessageFormat.format("[DATA] Duplicate element ID {0} detected inside {1} - only last element is used.", param.getId(), this));
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [" + "id" + "=" + this.getId() + ", " + "apply_to" + "=" + this.getApplyTo() + ", " + super.toString() + ", " + "for_elements_of" + "=" + this.getForElementsOf() + ", params=(fst " + 3 + ")=" + CollectionsUtils.firstN(this.params.values(), (int)3) + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.applyTo.hashCode();
        result = 31 * result + super.hashCode();
        result = 31 * result + this.forElementsOf.hashCode();
        result = 31 * result + this.params.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        Fragment other = (Fragment)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.applyTo.equals(other.applyTo)) {
            return false;
        }
        if (!this.forElementsOf.equals(other.forElementsOf)) {
            return false;
        }
        return this.params.equals(other.params);
    }

    @Override
    public String getType() {
        return "fragment";
    }
}

