/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.data.Section;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="code", strict=false)
public class Code {
    private static final Logger LOGGER = LogManager.getLogger(Code.class);
    private LinkedHashMap<String, Section> sections;

    @ElementList(type=Section.class, required=false, inline=true)
    private @ElementList(type=Section.class, required=false, inline=true) List<Section> getSectionsList() {
        return CollectionsUtils.listFromMapValues(this.sections);
    }

    @ElementList(type=Section.class, required=false, inline=true)
    private void setSectionsList(List<Section> newSections) {
        newSections.stream().forEachOrdered(section -> this.addSection((Section)section));
    }

    public Code() {
        this.sections = new LinkedHashMap();
    }

    public Code(Code original) {
        this.sections = new LinkedHashMap<String, Section>(original.getSections());
    }

    public void addSection(Section section) {
        if (this.sections.put(section.getId(), section) != null) {
            LOGGER.severe(MessageFormat.format("[DATA] Duplicate element ID {0} detected inside {1} - only last element is used.", section.getId(), this));
        }
    }

    public LinkedHashMap<String, Section> getSections() {
        return this.sections;
    }

    public @Nullable Section getSection(String target) {
        return this.sections.get(target);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [sections=(fst " + 3 + ")=" + CollectionsUtils.firstN(this.sections.values(), (int)3) + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.sections.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Code other = (Code)obj;
        return this.sections.equals(other.sections);
    }
}

