/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.periphs.model.data.Components;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ActiveComponents
extends Components {
    private static final Logger LOGGER = LogManager.getLogger(ActiveComponents.class);

    public ActiveComponents() {
        super(new HashSet<ConfigurationComponentTypeId>());
    }

    public ActiveComponents(ActiveComponents original) {
        super(original, new HashSet<ConfigurationComponentTypeId>());
    }

    public ActiveComponents(Collection<ConfigurationComponentTypeId> confCompTypeIds) {
        super(new HashSet<ConfigurationComponentTypeId>(confCompTypeIds));
    }

    public void removeConfigurationComponent(IConfigurationComponent oldConfigurationComponent) {
        Iterator it = this.confCompTypeIds.iterator();
        while (it.hasNext()) {
            ConfigurationComponentTypeId typeId = (ConfigurationComponentTypeId)it.next();
            if (typeId.getConfigurationComponent() != oldConfigurationComponent) continue;
            it.remove();
            break;
        }
    }

    public @Nullable IConfigurationComponent getConfigComp(String ID) {
        return (IConfigurationComponent)CollectionsUtils.nullableOptionalGet(this.confCompTypeIds.stream().map(y -> y.getConfigurationComponent()).filter(x -> x.getId().equals(ID)).findFirst());
    }

    public @Nullable ConfigurationComponentTypeId getConfigCompTypeId(StoragePeriphsComponent storage) {
        ConfigurationComponentTypeId configCompTypeId = this.getConfigCompTypeId(storage.getTypeId());
        if (configCompTypeId == null && (configCompTypeId = this.getComponentTypeIdByType(storage.getName())) != null) {
            LOGGER.log(Level.WARNING, "[DATA] Component with type_id: " + storage.getTypeId() + " is not active. Using component with type_id: " + configCompTypeId.getTypeId());
        }
        return configCompTypeId;
    }

    public @Nullable ConfigurationComponentTypeId getComponentTypeIdByType(String type) {
        List matchingComponents = this.confCompTypeIds.stream().filter(x -> x.getType().equals(type)).collect(Collectors.toList());
        if (matchingComponents.size() != 1) {
            return null;
        }
        return (ConfigurationComponentTypeId)matchingComponents.get(0);
    }
}

