/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.gui.utils;

import com.nxp.swtools.bootimage.utils.BinaryTablePreview;
import com.nxp.swtools.bootimage.utils.ColorAndTooltip;
import com.nxp.swtools.bootimage.validation.IProblemUIContainer;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.os.OSDetect;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controller.validation.EfuseProblem;
import com.nxp.swtools.efuse.controller.validation.EfuseProblemsManager;
import com.nxp.swtools.efuse.controls.EnumSettingControl;
import com.nxp.swtools.efuse.controls.IChildControl;
import com.nxp.swtools.efuse.controls.TabSettingNode;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.gui.EfuseUIProblem;
import com.nxp.swtools.efuse.gui.EfuseValidatedTextField;
import com.nxp.swtools.efuse.gui.utils.Messages;
import com.nxp.swtools.efuse.model.EfuseConstants;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IMcu;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.ItemSetting;
import com.nxp.swtools.efuse.xml.settings.FuseStructSetting;
import com.nxp.swtools.efuse.xml.settings.HeaderSetting;
import com.nxp.swtools.efuse.xml.settings.MemberFuseStructSetting;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.validation.engine.GenericProblem;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class EfuseGuiUtils {
    private static boolean saveDialogOpenedFirstTime = true;
    private static final Map<IChildControl, IEventListener> registeredListeners = new HashMap<IChildControl, IEventListener>();
    private static BorderPane eFuseBinaryConfigurationPanel = new BorderPane();
    @Nullable
    private static BinaryTablePreview eFuseBinaryConfigurationTableView;

    public static void refreshUI(Scene scene) {
        if (scene.getRoot() instanceof TabPane) {
            TabPane mainPane = (TabPane)scene.getRoot();
            for (Tab tab : mainPane.getTabs()) {
                if (!(tab instanceof TabSettingNode)) continue;
                ((TabSettingNode)tab).refresh();
            }
        }
    }

    public static void updateNodeState(Node node, ABaseUIComponentSetting setting) {
        node.setVisible(setting.isVisible());
        node.setDisable(setting.isDisabled());
    }

    public static FileDialog createFileDialogChooser(int swtStyle, String fileDialogTitle, String filterPath, List<String> formatExtensions, List<String> filterNames, Shell shell, boolean showOverwrite) {
        FileDialog fileDialogChooser = new FileDialog(shell, swtStyle);
        fileDialogChooser.setFilterPath(filterPath);
        fileDialogChooser.setFilterExtensions(formatExtensions.toArray(new String[formatExtensions.size()]));
        fileDialogChooser.setText(fileDialogTitle);
        if (swtStyle == 8192) {
            fileDialogChooser.setFileName(Messages.DefaultExportFileName);
            fileDialogChooser.setFilterPath(EfuseGuiUtils.getInitialSaveDirectory(UtilsText.safeString((String)System.getProperty("user.home"))));
        }
        fileDialogChooser.setOverwrite(showOverwrite);
        fileDialogChooser.setFilterNames(filterNames.toArray(new String[filterNames.size()]));
        return fileDialogChooser;
    }

    public static List<@NonNull String> createBinaryFormatExtensionsList() {
        ArrayList<@NonNull String> formatExtensions = new ArrayList<String>();
        formatExtensions.add("*.bin");
        formatExtensions.add(EfuseConstants.ALL_TYPES_EXTENSION);
        return formatExtensions;
    }

    public static List<@NonNull String> createBinaryFormatNamesList() {
        ArrayList<@NonNull String> filterNames = new ArrayList<String>();
        filterNames.add(Messages.BinaryFile);
        filterNames.add(Messages.AllTypes);
        return filterNames;
    }

    private static String getInitialSaveDirectory(String initialDirectory) {
        if (saveDialogOpenedFirstTime) {
            if (OSDetect.isWindows()) {
                initialDirectory = "\\\\?\\" + initialDirectory;
            }
            saveDialogOpenedFirstTime = false;
        }
        return initialDirectory;
    }

    public static String concatExtensionToFile(FileDialog fileDialogChooser, String filePath, String defaultExtension) {
        int extensionStartIndex;
        String chosenFilterExtension;
        String fileExtension;
        int filterExtensionIndex = fileDialogChooser.getFilterIndex();
        String[] filterExtensions = fileDialogChooser.getFilterExtensions();
        String chosenExtensionByUser = "";
        if (filterExtensions != null) {
            if (filterExtensionIndex == -1) {
                Optional<String> filteredExtension = Arrays.asList(filterExtensions).stream().filter(e -> defaultExtension.equals(e)).findFirst();
                if (filteredExtension.isPresent()) {
                    chosenExtensionByUser = filteredExtension.get();
                }
            } else {
                chosenExtensionByUser = filterExtensions[filterExtensionIndex];
            }
        }
        if (!(fileExtension = UtilsFile.getFileExtensionWithDot((String)filePath)).equalsIgnoreCase(chosenFilterExtension = UtilsFile.getFileExtensionWithDot((String)chosenExtensionByUser))) {
            fileExtension = "";
        }
        if (UtilsText.isEmpty((String)fileExtension) && !chosenExtensionByUser.equals(EfuseConstants.ALL_TYPES_EXTENSION) && (extensionStartIndex = chosenFilterExtension.lastIndexOf(".") + 1) != -1 && extensionStartIndex < chosenFilterExtension.length()) {
            chosenFilterExtension = chosenFilterExtension.substring(extensionStartIndex);
            filePath = UtilsFile.addFileExtension((String)filePath, (String)chosenFilterExtension);
        }
        return filePath;
    }

    public static boolean shouldOverwriteFile(Shell shell, File selectedFile) {
        if (OSDetect.isWindows()) {
            return true;
        }
        MessageBox overwriteDialog = EfuseGuiUtils.createOverwriteDialog(selectedFile.getName(), shell);
        int buttonOption = overwriteDialog.open();
        return buttonOption == 64;
    }

    private static MessageBox createOverwriteDialog(String fileName, Shell shell) {
        MessageBox overwriteDialog = new MessageBox(shell, 200);
        String overwriteMessage = MessageFormat.format(Messages.Overwrite_Message, fileName);
        overwriteDialog.setMessage(overwriteMessage);
        overwriteDialog.setText(Messages.Confirm_SaveAs);
        return overwriteDialog;
    }

    public static void updateEnumComboBoxesItems() {
        for (Node node : EfuseSceneCreator.getNodes()) {
            EnumSetting enumSetting;
            if (!(node instanceof EnumSettingControl)) continue;
            EnumSettingControl enumSettingControl = (EnumSettingControl)node;
            ComboBox<String> enumCmb = enumSettingControl.getEnumCmb();
            ObservableList<String> enumCmbItems = enumSettingControl.getEnumCmbItems();
            ABaseUIComponentSetting component = EfuseControllerUtils.getUIComponentSettingById((String)enumCmb.getId());
            ArrayList<String> itemsToAdd = new ArrayList<String>();
            ArrayList<String> itemsToRemove = new ArrayList<String>();
            if (!(component instanceof EnumSetting) || !EfuseGuiUtils.shouldUpdateCmbItems(enumSetting = (EnumSetting)component, enumCmb)) continue;
            for (ItemSetting item : enumSetting.getItems()) {
                if (item.isVisible() && !enumCmbItems.contains(item.getLabel())) {
                    itemsToAdd.add(item.getLabel());
                    continue;
                }
                if (item.isVisible() || !enumCmbItems.contains(item.getLabel())) continue;
                itemsToRemove.add(item.getLabel());
            }
            enumSettingControl.getEnumCmbItems().removeAll(itemsToRemove);
            enumSettingControl.getEnumCmbItems().addAll(itemsToAdd);
        }
    }

    private static boolean shouldUpdateCmbItems(EnumSetting enumSetting, ComboBox<String> enumCmb) {
        if (enumSetting.getVisibleItems().size() != enumCmb.getItems().size()) {
            return true;
        }
        for (ItemSetting item : enumSetting.getVisibleItems()) {
            if (enumCmb.getItems().contains((Object)item.getLabel())) continue;
            return true;
        }
        return false;
    }

    public static void registerListenerForControl(final IChildControl control, int eventType) {
        IEventListener settingListener = new IEventListener(){

            public void handle(ToolEvent event) {
                if (event.originator == control) {
                    control.refresh();
                }
            }
        };
        registeredListeners.put(control, settingListener);
        EfuseController.getInstance().addListener(eventType, settingListener);
    }

    public static void removeListenerForControl(IChildControl control) {
        IEventListener eventListener = registeredListeners.remove(control);
        if (eventListener != null) {
            EfuseController.getInstance().removeListener(eventListener);
        }
    }

    public static void setTextFieldError(EfuseValidatedTextField textField, IntegerSetting integerSetting, String problemSource) {
        EfuseProblemsManager eFuseProblemsManager = EfuseController.getInstance().getProblemsManager();
        if (textField.getText().isEmpty()) {
            EfuseProblem emptyValueProblem = eFuseProblemsManager.getEmptyFieldValueProblem(integerSetting, textField.getText(), problemSource);
            if (emptyValueProblem != null) {
                EfuseUIProblem invalidValueProblemUI = new EfuseUIProblem(emptyValueProblem);
                invalidValueProblemUI.setSourceContainer((IProblemUIContainer)textField);
                eFuseProblemsManager.addProblem((GenericProblem)invalidValueProblemUI);
                textField.setTextFieldErrorStyle();
            }
        } else {
            EfuseProblem invalidValueProblem = eFuseProblemsManager.getInvalidFieldValueProblem(integerSetting, textField.getText(), textField.getValidationStatusMessage(), problemSource);
            if (invalidValueProblem != null) {
                EfuseUIProblem invalidValueProblemUI = new EfuseUIProblem(invalidValueProblem);
                invalidValueProblemUI.setSourceContainer((IProblemUIContainer)textField);
                eFuseProblemsManager.addProblem((GenericProblem)invalidValueProblemUI);
                textField.setTextFieldErrorStyle();
            }
        }
    }

    public static void checkAddressLimitProblem(EfuseValidatedTextField integerSettingTxt, IntegerSetting integerSetting, EnumSetting enumSetting) {
        EfuseProblemsManager eFuseProblemsManager = EfuseController.getInstance().getProblemsManager();
        StringBuilder resource = new StringBuilder();
        resource.append(integerSetting.getLabel());
        EfuseProblem addressLimitProblem = eFuseProblemsManager.getAddressLimitProblem(integerSetting, enumSetting, resource.toString());
        if (addressLimitProblem != null) {
            EfuseUIProblem addressLimitProblemUI = new EfuseUIProblem(addressLimitProblem);
            addressLimitProblemUI.setSourceContainer((IProblemUIContainer)integerSettingTxt);
            eFuseProblemsManager.addProblem((GenericProblem)addressLimitProblemUI);
            integerSettingTxt.setTextFieldErrorStyle();
        }
    }

    public static void refreshEfuseBinaryConfigurationTable() {
        Platform.runLater(() -> {
            byte[] binaryContent = EfuseGuiUtils.getEfuseBinaryConfigurationTableContent();
            if (eFuseBinaryConfigurationTableView != null) {
                eFuseBinaryConfigurationTableView.updateTableViewContent(binaryContent, 16, EfuseGuiUtils.getColorAndTooltipMap());
            }
        });
    }

    public static void createEfuseBinaryConfigurationTable() {
        byte[] binaryContent = EfuseGuiUtils.getEfuseBinaryConfigurationTableContent();
        eFuseBinaryConfigurationTableView = new BinaryTablePreview();
        eFuseBinaryConfigurationPanel.setCenter((Node)eFuseBinaryConfigurationTableView.createTableView(binaryContent, "efuse_binary_configuration_table", 16, EfuseGuiUtils.getColorAndTooltipMap()));
    }

    private static byte[] getEfuseBinaryConfigurationTableContent() {
        IMcu mcu = EfuseController.getInstance().getMcu();
        ByteBuffer content = ByteBuffer.allocate(0);
        if (mcu != null) {
            HeaderSetting efuseHeader;
            int contentSize = 0;
            HeaderSetting header = mcu.getEfuseXmlConfig().getSerialBootHeader();
            if (header != null && !header.isDisabled()) {
                contentSize += header.getSizeValueInBytes();
            }
            if ((efuseHeader = mcu.getEfuseXmlConfig().getHeader()) != null) {
                contentSize += efuseHeader.getSizeValueInBytes();
            }
            List fuseWords = mcu.getAllFuseWords();
            for (FuseWord fuseWord : fuseWords) {
                FuseStructSetting fuseStructSetting = fuseWord.getXmlSetting().getFuseStructure();
                if (fuseStructSetting == null) continue;
                contentSize += fuseStructSetting.getSizeValueInBytes();
            }
            byte[] eFuseBinaryConfiguration = EfuseControllerUtils.getEfuseBinaryContent();
            return Arrays.copyOfRange(eFuseBinaryConfiguration, 0, contentSize);
        }
        return content.array();
    }

    private static NavigableMap<Integer, ColorAndTooltip> getColorAndTooltipMap() {
        TreeMap<Integer, ColorAndTooltip> colorAndTooltipMap = new TreeMap<Integer, ColorAndTooltip>();
        IMcu mcu = EfuseController.getInstance().getMcu();
        if (mcu != null) {
            HeaderSetting efuseHeader;
            int addr = 1;
            HeaderSetting header = mcu.getEfuseXmlConfig().getSerialBootHeader();
            if (header != null && !header.isDisabled()) {
                ColorAndTooltip colorAndToolTipForHeader = new ColorAndTooltip(Messages.SerialBootTooltip, Color.BLUE);
                colorAndTooltipMap.put(addr, colorAndToolTipForHeader);
                addr += header.getSizeValueInBytes();
            }
            if ((efuseHeader = mcu.getEfuseXmlConfig().getHeader()) != null) {
                ColorAndTooltip colorAndToolTipForHeader = new ColorAndTooltip(Messages.EfuseTooltip, Color.RED);
                colorAndTooltipMap.put(addr, colorAndToolTipForHeader);
                addr += efuseHeader.getSizeValueInBytes();
            }
            List fuseWords = mcu.getAllFuseWords();
            for (FuseWord fuseWord : fuseWords) {
                FuseStructSetting fuseStructSetting = fuseWord.getXmlSetting().getFuseStructure();
                if (fuseStructSetting == null) continue;
                List<MemberFuseStructSetting> membersList = EfuseGuiUtils.sortMembersListByOffset(new ArrayList<MemberFuseStructSetting>(fuseStructSetting.getMembersList()));
                int currentAddress = 1;
                for (MemberFuseStructSetting member : membersList) {
                    String label = member.getLabel();
                    if (currentAddress == member.getOffset()) {
                        ColorAndTooltip colorAndToolTipForMemberr = new ColorAndTooltip(Messages.ReservedTooltip, Color.LIGHTSLATEGRAY);
                        colorAndTooltipMap.put(addr, colorAndToolTipForMemberr);
                        ++addr;
                        ++currentAddress;
                    }
                    ColorAndTooltip colorAndToolTipForMember = new ColorAndTooltip(label, Color.BLACK);
                    colorAndTooltipMap.put(addr, colorAndToolTipForMember);
                    addr += member.getSizeValueInBytes();
                    currentAddress += member.getSizeValueInBytes();
                }
                currentAddress = 1;
            }
            ColorAndTooltip colorAndToolTipForMember = new ColorAndTooltip(Messages.ReservedTooltip, Color.RED);
            colorAndTooltipMap.put(addr, colorAndToolTipForMember);
        }
        return colorAndTooltipMap;
    }

    public static BorderPane getEfuseBinaryConfigurationTablePane() {
        return eFuseBinaryConfigurationPanel;
    }

    private static List<MemberFuseStructSetting> sortMembersListByOffset(List<MemberFuseStructSetting> membersList) {
        Collections.sort(membersList, new Comparator<MemberFuseStructSetting>(){

            @Override
            public int compare(MemberFuseStructSetting o1, MemberFuseStructSetting o2) {
                int secondOffset;
                int firstOffset = o1.getOffset();
                if (firstOffset > (secondOffset = o2.getOffset())) {
                    return 1;
                }
                if (firstOffset < secondOffset) {
                    return -1;
                }
                return 0;
            }
        });
        return membersList;
    }

    public static void synchronizeStandardFuseWithAdvancedModeFuse(IntegerSetting integerSettingValue, Parent parentControl) {
        String value = integerSettingValue.getCurrentValue();
        if (!NumberFormatValidator.isValidDecimal((String)value) && !NumberFormatValidator.isValidHexadecimal((String)value)) {
            return;
        }
        for (Node node : parentControl.getChildrenUnmodifiable()) {
            FuseWord fuseWord;
            if (!(node instanceof EnumSettingControl)) continue;
            EnumSettingControl enumNode = (EnumSettingControl)node;
            String fuseWordId = enumNode.getEnumSetting().getCurrentValue();
            IMcu mcu = EfuseController.getInstance().getMcu();
            if (mcu == null || !enumNode.getEnumSetting().getId().equals("fuse_word_advanced") || (fuseWord = EfuseUtils.getFuseWordByID((List)mcu.getAllFuseWords(), (String)fuseWordId)) == null) continue;
            EfuseGuiUtils.clearFuseWordFieldsValue(mcu, fuseWord);
            EfuseControllerUtils.setUIComponentsForFuseWord((IMcu)mcu, (FuseWord)fuseWord, (IntegerSetting)integerSettingValue);
            for (FuseField fuseField : fuseWord.getFuseFields()) {
                ABaseUIComponentSetting component = EfuseControllerUtils.getVisibleUIComponentByFuseFieldId((String)fuseField.getXmlSetting().getId());
                if (!(component instanceof EnumSetting)) continue;
                EfuseControllerUtils.updateComponentsState((ABaseUIComponentSetting)component);
            }
        }
    }

    public static void clearFuseWordFieldsValue(IMcu mcu, FuseWord fuseWord) {
        List fuseFields = fuseWord.getFuseFields();
        for (FuseField fuseField : fuseFields) {
            fuseField.setValueToWrite(0L);
            ABaseUIComponentSetting fuseFieldUIComponent = EfuseUtils.getComponentSettingById((IMcu)mcu, (String)fuseField.getXmlSetting().getId());
            if (fuseFieldUIComponent == null) continue;
            EfuseControllerUtils.setUIComponentValue((ABaseUIComponentSetting)fuseFieldUIComponent, (String)("0x" + Long.toHexString(0L)));
        }
    }

    public static List<@NonNull String> createELFFormatExtensionsList() {
        ArrayList<@NonNull String> formatExtensions = new ArrayList<String>();
        formatExtensions.add("*.elf");
        formatExtensions.add(EfuseConstants.ALL_TYPES_EXTENSION);
        return formatExtensions;
    }

    public static List<@NonNull String> createELFFormatNamesList() {
        ArrayList<@NonNull String> filterNames = new ArrayList<String>();
        filterNames.add(Messages.ELFFile);
        filterNames.add(Messages.AllTypes);
        return filterNames;
    }

    public static @Nullable Tab getTabWithId(TabPane tabPane, String id) {
        for (Tab tab : tabPane.getTabs()) {
            if (!id.equals(tab.getId())) continue;
            return tab;
        }
        return null;
    }
}

