/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.efuse.controls.IBaseControl;
import com.nxp.swtools.efuse.controls.StructSettingNode;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.ui.xml.settings.StructSetting;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import org.eclipse.ui.services.IDisposable;

public class TitledPaneStructNode
extends TitledPane
implements IBaseControl,
IDisposable {
    private StructSetting structSetting;
    private GridPane content;

    public TitledPaneStructNode(StructSetting structSetting) {
        this.structSetting = structSetting;
        this.content = new GridPane();
        this.create();
    }

    @Override
    public void create() {
        ColumnConstraints cc = new ColumnConstraints();
        cc.setHgrow(Priority.ALWAYS);
        this.content.getColumnConstraints().add((Object)cc);
        RowConstraints rc = new RowConstraints();
        rc.setVgrow(Priority.ALWAYS);
        this.content.getRowConstraints().add((Object)rc);
        this.setId(this.structSetting.getId());
        this.setAlignment(Pos.TOP_CENTER);
        this.setContentDisplay(ContentDisplay.TOP);
        this.setText(this.structSetting.getLabel());
        this.setFont(new Font("System Bold", 15.0));
        this.setExpanded(true);
        this.setCollapsible(false);
        for (StructSetting childStructSetting : this.structSetting.getStructSettings()) {
            StructSettingNode childStructSettingNode = new StructSettingNode(childStructSetting);
            this.content.add((Node)childStructSettingNode.getRegion(), childStructSetting.getColumn(), childStructSetting.getRow());
            GridPane.setFillWidth((Node)childStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
            GridPane.setFillHeight((Node)childStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
            GridPane.setValignment((Node)childStructSettingNode.getRegion(), (VPos)VPos.TOP);
            EfuseGuiUtils.updateNodeState((Node)childStructSettingNode.getRegion(), (ABaseUIComponentSetting)childStructSetting);
        }
        if (this.structSetting.shouldShowBinaryConfiguration()) {
            EfuseGuiUtils.createEfuseBinaryConfigurationTable();
            this.content.add((Node)EfuseGuiUtils.getEfuseBinaryConfigurationTablePane(), 0, 0);
        }
        this.setContent((Node)this.content);
        EfuseSceneCreator.getNodes().add((Node)this);
        EfuseSceneCreator.getNodes().add((Node)this.content);
    }

    @Override
    public void refresh() {
        EfuseGuiUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        for (Node node : this.content.getChildren()) {
            if (!(node instanceof IBaseControl)) continue;
            ((IBaseControl)node).refresh();
        }
    }

    public void dispose() {
        for (Node node : this.content.getChildren()) {
            if (!(node instanceof IDisposable)) continue;
            ((IDisposable)node).dispose();
        }
        EfuseSceneCreator.getNodes().remove(this);
        EfuseSceneCreator.getNodes().remove(this.content);
        this.getChildren().clear();
        this.content.getChildren().clear();
    }
}

