/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.efuse.controls.IBaseControl;
import com.nxp.swtools.efuse.controls.StructSettingNode;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.ui.xml.settings.StructSetting;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import org.eclipse.ui.services.IDisposable;

public class SplitPaneStructNode
extends SplitPane
implements IBaseControl,
IDisposable {
    private StructSetting structSetting;

    public SplitPaneStructNode(StructSetting structSetting) {
        this.structSetting = structSetting;
        this.create();
    }

    @Override
    public void create() {
        this.setId(this.structSetting.getId());
        this.setDividerPositions(new double[]{0.4f, 0.7f});
        for (StructSetting childStruct : this.structSetting.getStructSettings()) {
            ScrollPane childStructScrollPane = new ScrollPane();
            StructSettingNode structSettingNode = new StructSettingNode(childStruct);
            childStructScrollPane.setContent((Node)structSettingNode.getRegion());
            childStructScrollPane.setFitToWidth(true);
            this.getItems().add((Object)childStructScrollPane);
            EfuseGuiUtils.updateNodeState((Node)childStructScrollPane, (ABaseUIComponentSetting)childStruct);
        }
        EfuseGuiUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        EfuseSceneCreator.getNodes().add((Node)this);
    }

    @Override
    public void refresh() {
        EfuseGuiUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        for (Node child : this.getItems()) {
            Node childContent;
            if (!(child instanceof ScrollPane) || !((childContent = ((ScrollPane)child).getContent()) instanceof IBaseControl)) continue;
            ((IBaseControl)childContent).refresh();
        }
    }

    public void dispose() {
        for (Node child : this.getItems()) {
            Node childContent;
            if (!(child instanceof ScrollPane) || !((childContent = ((ScrollPane)child).getContent()) instanceof IDisposable)) continue;
            ((IDisposable)childContent).dispose();
        }
        EfuseSceneCreator.getNodes().remove(this);
        this.getItems().clear();
    }
}

