/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controls.ArraySettingControl;
import com.nxp.swtools.efuse.controls.BitsSettingControl;
import com.nxp.swtools.efuse.controls.BoolSettingControl;
import com.nxp.swtools.efuse.controls.ButtonSettingControl;
import com.nxp.swtools.efuse.controls.EnumSettingControl;
import com.nxp.swtools.efuse.controls.IBaseControl;
import com.nxp.swtools.efuse.controls.IntegerSettingControl;
import com.nxp.swtools.efuse.controls.StructSettingNode;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.BitsSetting;
import com.nxp.swtools.efuse.ui.xml.settings.BoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.ButtonSetting;
import com.nxp.swtools.efuse.ui.xml.settings.ComponentTypes;
import com.nxp.swtools.efuse.ui.xml.settings.EnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.StructSetting;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import org.eclipse.ui.services.IDisposable;

public class GridPaneStructNode
extends GridPane
implements IBaseControl,
IDisposable {
    private StructSetting structSetting;

    public GridPaneStructNode(StructSetting structSetting) {
        this.structSetting = structSetting;
        this.create();
    }

    @Override
    public void create() {
        this.setHgap(20.0);
        this.setVgap(10.0);
        ColumnConstraints cc = new ColumnConstraints();
        cc.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().add((Object)cc);
        RowConstraints rc = new RowConstraints();
        rc.setVgrow(Priority.ALWAYS);
        this.getRowConstraints().add((Object)rc);
        for (StructSetting childStructSetting : this.structSetting.getStructSettings()) {
            if (childStructSetting.getTypeComponentId().isEmpty()) {
                StructSettingNode childStructSettingNode = new StructSettingNode(childStructSetting);
                this.add((Node)childStructSettingNode.getRegion(), childStructSetting.getColumn(), childStructSetting.getRow());
                GridPane.setFillWidth((Node)childStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
                GridPane.setValignment((Node)childStructSettingNode.getRegion(), (VPos)VPos.TOP);
                continue;
            }
            ComponentTypes componentTypes = EfuseControllerUtils.getComponentTypes();
            ABaseUIComponentSetting structSettingComponentType = componentTypes.getComponentTypeById(childStructSetting.getTypeComponentId());
            if (!(structSettingComponentType instanceof StructSetting)) continue;
            StructSettingNode newStructSettingNode = new StructSettingNode((StructSetting)structSettingComponentType);
            this.add((Node)newStructSettingNode.getRegion(), childStructSetting.getColumn(), childStructSetting.getRow());
            GridPane.setFillWidth((Node)newStructSettingNode.getRegion(), (Boolean)Boolean.TRUE);
        }
        for (BoolSetting boolSetting : this.structSetting.getBoolSettings()) {
            BoolSettingControl boolSettingControl = new BoolSettingControl(boolSetting, (Parent)this);
            this.add((Node)boolSettingControl, boolSetting.getColumn(), boolSetting.getRow());
        }
        for (EnumSetting enumSetting : this.structSetting.getEnumSettings()) {
            EnumSettingControl enumSettingControl = new EnumSettingControl(enumSetting, (Parent)this);
            this.add((Node)enumSettingControl, enumSetting.getColumn(), enumSetting.getRow());
        }
        for (IntegerSetting integerSetting : this.structSetting.getIntegerSettings()) {
            IntegerSettingControl integerSettingControl = new IntegerSettingControl(integerSetting, (Parent)this);
            this.add((Node)integerSettingControl, integerSetting.getColumn(), integerSetting.getRow());
        }
        for (BitsSetting bitsSetting : this.structSetting.getBitsSettings()) {
            BitsSettingControl bitsSettingControl = new BitsSettingControl(bitsSetting, (Parent)this);
            this.add((Node)bitsSettingControl, bitsSetting.getColumn(), bitsSetting.getRow());
        }
        for (ButtonSetting buttonSetting : this.structSetting.getButtonSettings()) {
            ButtonSettingControl buttonSettingControl = new ButtonSettingControl(buttonSetting, (Parent)this);
            this.add((Node)buttonSettingControl, buttonSetting.getColumn(), buttonSetting.getRow());
        }
        for (ArraySetting arraySetting : this.structSetting.getArraySettings()) {
            ArraySettingControl arraySettingControl = new ArraySettingControl(arraySetting, (Parent)this);
            this.add((Node)arraySettingControl, arraySetting.getColumn(), arraySetting.getRow());
        }
        EfuseGuiUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        EfuseSceneCreator.getNodes().add((Node)this);
    }

    @Override
    public void refresh() {
        EfuseGuiUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.structSetting);
        for (Node child : this.getChildren()) {
            if (!(child instanceof IBaseControl)) continue;
            ((IBaseControl)child).refresh();
        }
    }

    public void dispose() {
        for (Node child : this.getChildren()) {
            if (!(child instanceof IDisposable)) continue;
            ((IDisposable)child).dispose();
        }
        EfuseSceneCreator.getNodes().remove(this);
        this.getChildren().clear();
    }
}

