/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controls;

import com.nxp.swtools.efuse.controller.utils.EfuseControllerUtils;
import com.nxp.swtools.efuse.controller.utils.StorageEfuseUtils;
import com.nxp.swtools.efuse.controls.IChildControl;
import com.nxp.swtools.efuse.gui.EfuseSceneCreator;
import com.nxp.swtools.efuse.gui.utils.EfuseActions;
import com.nxp.swtools.efuse.gui.utils.EfuseGuiUtils;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.efuse.ui.xml.settings.BoolSetting;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import org.eclipse.ui.services.IDisposable;

public class BoolSettingControl
extends CheckBox
implements IChildControl,
IDisposable {
    private BoolSetting boolSetting;
    protected Parent parent;

    public BoolSettingControl(BoolSetting boolSetting, Parent parent) {
        this.boolSetting = boolSetting;
        this.parent = parent;
        this.create();
    }

    @Override
    public void create() {
        this.setId(this.boolSetting.getId());
        this.setMnemonicParsing(false);
        this.setText(this.boolSetting.getLabel());
        this.setSelected("true".equalsIgnoreCase(this.boolSetting.getCurrentValue()));
        this.getStyleClass().add((Object)"default-c-style");
        EfuseGuiUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.boolSetting);
        EfuseGuiUtils.registerListenerForControl(this, 4);
        this.selectedProperty().addListener((obs, wasOn, isNowOn) -> {
            String currentValue = this.isSelected() ? "true" : "false";
            this.boolSetting.setCurrentValue(currentValue);
            FuseField associatedFuseField = this.boolSetting.getFuseField();
            if (associatedFuseField != null) {
                associatedFuseField.setValueToWrite(this.isSelected() ? 1L : 0L);
            }
            EfuseActions.executeAction(this.boolSetting.getAction());
            EfuseActions.executeSyncAction(this.boolSetting.getAction(), currentValue);
            EfuseControllerUtils.updateComponentsState((ABaseUIComponentSetting)this.boolSetting);
            EfuseGuiUtils.updateEnumComboBoxesItems();
            Scene scene = this.getScene();
            if (scene != null) {
                EfuseGuiUtils.refreshUI(scene);
            }
            EfuseGuiUtils.createEfuseBinaryConfigurationTable();
            if (EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.STANDARD)) {
                StorageEfuseUtils.updateStorageComponent((Object)this, (ABaseUIComponentSetting)this.boolSetting);
            }
        });
        EfuseSceneCreator.getNodes().add((Node)this);
    }

    @Override
    public void refresh() {
        EfuseGuiUtils.updateNodeState((Node)this, (ABaseUIComponentSetting)this.boolSetting);
        boolean currentBoolSettingValue = this.boolSetting.getCurrentValue().equals("true");
        if (this.isSelected() != currentBoolSettingValue) {
            this.setSelected(currentBoolSettingValue);
        }
    }

    @Override
    public Parent getParentControl() {
        return this.parent;
    }

    @Override
    public void setParentControl(Parent parent) {
        this.parent = parent;
    }

    public void dispose() {
        EfuseGuiUtils.removeListenerForControl(this);
        EfuseSceneCreator.getNodes().add((Node)this);
        this.getChildren().clear();
    }
}

