/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.registry;

import com.nxp.s32ds.ext.rcp.internal.registry.RegistryActivator;
import com.nxp.s32ds.ext.rcp.internal.registry.RegistryMessages;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import com.nxp.s32ds.ext.rcp.registry.ReferenceDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class BaseRegistry {
    protected RegistryActivator getActivator() {
        return RegistryActivator.getInstance();
    }

    protected <D extends EntityDescriptor> void addEntityDescriptor(D descriptor, Map<String, D> map, Class<D> clazz) {
        if (descriptor == null) {
            this.logError(RegistryMessages.BaseRegistry_e_add_null, clazz);
            return;
        }
        String id = descriptor.getId();
        if (id == null) {
            this.logError(RegistryMessages.BaseRegistry_e_add_null_id, clazz, descriptor);
            return;
        }
        if (map == null) {
            this.logError(RegistryMessages.BaseRegistry_e_add_null_map, clazz, descriptor);
            return;
        }
        if (map.containsKey(id)) {
            this.logError(RegistryMessages.BaseRegistry_e_add_duplicated_id, clazz, id);
            return;
        }
        map.put(id, descriptor);
    }

    protected <D extends EntityDescriptor> void removeEntityDescriptor(D descriptor, Map<String, D> map, Class<D> clazz) {
        if (descriptor == null) {
            this.logError(RegistryMessages.BaseRegistry_e_remove_null, clazz);
            return;
        }
        String id = descriptor.getId();
        if (id == null) {
            this.logError(RegistryMessages.BaseRegistry_e_remove_null_id, clazz, descriptor);
            return;
        }
        if (map == null) {
            this.logError(RegistryMessages.BaseRegistry_e_remove_null_map, clazz, descriptor);
            return;
        }
        map.remove(id);
    }

    protected <D extends ReferenceDescriptor> void addReferenceDescriptor(D descriptor, Map<String, Collection<D>> source, Map<String, Collection<D>> target, Class<D> clazz) {
        if (descriptor == null) {
            this.logError(RegistryMessages.BaseRegistry_e_add_null, clazz);
            return;
        }
        String sourceId = descriptor.getSourceId();
        if (sourceId == null) {
            this.logError(RegistryMessages.BaseRegistry_e_add_null_source_id, clazz, descriptor);
            return;
        }
        String targetId = descriptor.getTargetId();
        if (targetId == null) {
            this.logError(RegistryMessages.BaseRegistry_e_add_null_target_id, clazz, descriptor);
            return;
        }
        if (source == null) {
            this.logError(RegistryMessages.BaseRegistry_e_add_null_source_map, clazz, descriptor);
            return;
        }
        if (target == null) {
            this.logError(RegistryMessages.BaseRegistry_e_add_null_target_map, clazz, descriptor);
            return;
        }
        Collection<D> fromSource = source.get(sourceId);
        if (fromSource == null) {
            fromSource = new LinkedHashSet<D>();
            source.put(sourceId, fromSource);
        }
        fromSource.add(descriptor);
        Collection<D> fromTarget = target.get(targetId);
        if (fromTarget == null) {
            fromTarget = new LinkedHashSet<D>();
            target.put(targetId, fromTarget);
        }
        fromTarget.add(descriptor);
    }

    protected <D extends ReferenceDescriptor> void removeReferenceDescriptor(D descriptor, Map<String, Collection<D>> source, Map<String, Collection<D>> target, Class<D> clazz) {
        Collection<D> fromTarget;
        if (descriptor == null) {
            this.logError(RegistryMessages.BaseRegistry_e_remove_null, clazz);
            return;
        }
        String sourceId = descriptor.getSourceId();
        if (sourceId == null) {
            this.logError(RegistryMessages.BaseRegistry_e_remove_null_source_id, clazz, descriptor);
            return;
        }
        String targetId = descriptor.getTargetId();
        if (targetId == null) {
            this.logError(RegistryMessages.BaseRegistry_e_remove_null_target_id, clazz, descriptor);
            return;
        }
        if (source == null) {
            this.logError(RegistryMessages.BaseRegistry_e_remove_null_source_map, clazz, descriptor);
            return;
        }
        if (target == null) {
            this.logError(RegistryMessages.BaseRegistry_e_remove_null_target_map, clazz, descriptor);
            return;
        }
        Collection<D> fromSource = source.get(sourceId);
        if (fromSource != null) {
            fromSource.remove(descriptor);
        }
        if ((fromTarget = target.get(targetId)) != null) {
            fromTarget.remove(descriptor);
        }
    }

    protected <D extends ReferenceDescriptor> List<D> getReferenceDescriptorsBySourceId(String sourceId, Map<String, Collection<D>> source, Class<D> clazz) {
        if (sourceId == null) {
            this.logError(RegistryMessages.BaseRegistry_e_get_null_source_id, clazz);
            return Collections.emptyList();
        }
        if (source == null) {
            this.logError(RegistryMessages.BaseRegistry_e_get_null_source_map, clazz, sourceId);
            return Collections.emptyList();
        }
        Collection<D> targets = source.get(sourceId);
        if (targets == null) {
            return Collections.emptyList();
        }
        return new ArrayList<D>(targets);
    }

    protected <D extends ReferenceDescriptor> List<D> getReferenceDescriptorsByTargetId(String targetId, Map<String, Collection<D>> target, Class<D> clazz) {
        if (targetId == null) {
            this.logError(RegistryMessages.BaseRegistry_e_get_null_target_id, clazz);
            return Collections.emptyList();
        }
        if (target == null) {
            this.logError(RegistryMessages.BaseRegistry_e_get_null_target_map, clazz, targetId);
            return Collections.emptyList();
        }
        Collection<D> sources = target.get(targetId);
        if (sources == null) {
            return Collections.emptyList();
        }
        return new ArrayList<D>(sources);
    }

    private void logError(String message, Object ... arguments) {
        this.getActivator().logError(NLS.bind((String)message, (Object[])arguments));
    }
}

