/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.debugger.svd.ui.launch;

import com.nxp.s32ds.cle.ide.debugger.svd.SvdSource;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSourceType;
import com.nxp.s32ds.cle.ide.debugger.svd.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.debugger.svd.internal.ui.SvdTreeSelectionDialog;
import com.nxp.s32ds.cle.ide.debugger.svd.internal.ui.SvdUiActivator;
import com.nxp.s32ds.cle.ide.debugger.svd.internal.ui.SvdViewerFilterByExistence;
import com.nxp.s32ds.cle.ide.debugger.svd.launch.SvdLaunchConfigurations;
import com.nxp.s32ds.cle.ide.debugger.svd.launch.SvdLaunchParams;
import com.nxp.s32ds.cle.runtime.svd.registry.SvdDescriptor;
import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.ext.ide.ui.dialogs.FilteringElementTreeSelectionDialog;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class SvdLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    public static final String TAB_ID = "com.nxp.s32ds.cle.ide.debugger.svd.ui";
    private static final String[] EXTENSIONS = new String[]{"xml", "spr", "svd"};
    private Button cleanButton;
    private Button askBeforeCleanButton;
    private Text svdFilePathField;
    private Text armFilePathField;
    private Button deviceButton;
    private Button workspaceButton;
    private Button filesystemButton;
    private Button variablesButton;
    private Button armMergeStrategyButton;
    private Label svdFilePathLabel;
    private Label armFilePathLabel;
    private Button useDefaultSvdFilePathButton;
    private String svdFilePath;
    protected SvdLaunchParams svdLaunchParams;
    protected ILaunchConfiguration configuration;
    protected WidgetListener widgetListener = new WidgetListener();
    protected boolean initialization;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setFont(parent.getFont());
        GridDataFactory.swtDefaults().align(4, 2).grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(1).margins(15, 15).applyTo(composite);
        this.createCleanGroup(composite);
        this.createSvdFilePathGroup(composite);
        this.createSvdMergeSettingsGroup(composite);
    }

    private void createCleanGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridDataFactory.swtDefaults().align(4, 2).grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo(composite);
        this.cleanButton = new Button(composite, 32);
        this.cleanButton.setText(Messages.SvdLaunchConfigurationTab_clear_content_of_watch_registers_view);
        GridDataFactory.swtDefaults().align(1, 2).applyTo((Control)this.cleanButton);
        this.cleanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SvdLaunchConfigurationTab.this.initialization) {
                    SvdLaunchConfigurationTab.this.askBeforeCleanButton.setEnabled(SvdLaunchConfigurationTab.this.cleanButton.getSelection());
                    SvdLaunchConfigurationTab.this.scheduleUpdateJob();
                }
            }
        });
        this.askBeforeCleanButton = new Button(composite, 32);
        this.askBeforeCleanButton.setText(Messages.SvdLaunchConfigurationTab_ask_before_clear);
        GridDataFactory.swtDefaults().align(1, 2).applyTo((Control)this.askBeforeCleanButton);
        this.askBeforeCleanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SvdLaunchConfigurationTab.this.initialization) {
                    SvdLaunchConfigurationTab.this.scheduleUpdateJob();
                }
            }
        });
    }

    private void createSvdFilePathGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridDataFactory.swtDefaults().align(4, 2).grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo(composite);
        this.useDefaultSvdFilePathButton = new Button(composite, 32);
        this.useDefaultSvdFilePathButton.setText(Messages.SvdLaunchConfigurationTab_use_default_svd_file);
        GridDataFactory.swtDefaults().span(2, 1).align(1, 2).applyTo((Control)this.useDefaultSvdFilePathButton);
        this.svdFilePathLabel = new Label(composite, 0);
        GridDataFactory.swtDefaults().indent(18, 0).applyTo((Control)this.svdFilePathLabel);
        this.svdFilePathLabel.setText(Messages.SvdLaunchConfigurationTab_svd_source);
        this.svdFilePathField = new Text(composite, 2048);
        GridDataFactory.swtDefaults().align(4, 2).grab(true, false).hint(200, -1).applyTo((Control)this.svdFilePathField);
        this.svdFilePathField.addModifyListener(e -> {
            if (!this.initialization) {
                this.scheduleUpdateJob();
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridLayoutFactory.swtDefaults().numColumns(4).margins(0, 0).applyTo(buttonComposite);
        GridDataFactory.swtDefaults().span(2, 1).align(3, 2).applyTo((Control)buttonComposite);
        buttonComposite.setFont(composite.getFont());
        this.deviceButton = this.createPushButton(buttonComposite, Messages.SvdLaunchConfigurationTab_select_device, null);
        this.deviceButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.workspaceButton = this.createPushButton(buttonComposite, Messages.SvdLaunchConfigurationTab_browse_workspace, null);
        this.workspaceButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.filesystemButton = this.createPushButton(buttonComposite, Messages.SvdLaunchConfigurationTab_browse_file_system, null);
        this.filesystemButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.variablesButton = this.createPushButton(buttonComposite, Messages.SvdLaunchConfigurationTab_variables, null);
        this.variablesButton.addSelectionListener((SelectionListener)this.widgetListener);
        this.useDefaultSvdFilePathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useDefault = SvdLaunchConfigurationTab.this.useDefaultSvdFilePathButton.getSelection();
                SvdLaunchConfigurationTab.this.enableSvdFilePathGroup(!useDefault);
                if (!SvdLaunchConfigurationTab.this.initialization) {
                    SvdLaunchConfigurationTab.this.updateSvdFilePathField();
                    SvdLaunchConfigurationTab.this.scheduleUpdateJob();
                }
            }
        });
    }

    private void createSvdMergeSettingsGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayoutFactory.swtDefaults().numColumns(2).margins(0, 0).applyTo(composite);
        GridDataFactory.swtDefaults().align(4, 2).grab(true, false).applyTo((Control)composite);
        this.armMergeStrategyButton = new Button(composite, 32);
        this.armMergeStrategyButton.setText(Messages.SvdLaunchConfigurationTab_support_arm_registers);
        this.armMergeStrategyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SvdLaunchConfigurationTab.this.initialization) {
                    SvdLaunchConfigurationTab.this.armFilePathLabel.setEnabled(SvdLaunchConfigurationTab.this.armMergeStrategyButton.getSelection());
                    SvdLaunchConfigurationTab.this.scheduleUpdateJob();
                }
            }
        });
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)this.armMergeStrategyButton);
        this.armFilePathLabel = new Label(composite, 0);
        GridDataFactory.swtDefaults().indent(18, 0).applyTo((Control)this.armFilePathLabel);
        this.armFilePathLabel.setText(Messages.SvdLaunchConfigurationTab_arm_svd_source);
        this.armFilePathField = new Text(composite, 2048);
        GridDataFactory.swtDefaults().align(4, 2).grab(true, false).hint(200, -1).applyTo((Control)this.armFilePathField);
        this.armFilePathField.setEnabled(false);
    }

    private void enableSvdFilePathGroup(boolean enabled) {
        this.svdFilePathLabel.setEnabled(enabled);
        this.svdFilePathField.setEnabled(enabled);
        this.deviceButton.setEnabled(enabled);
        this.workspaceButton.setEnabled(enabled);
        this.filesystemButton.setEnabled(enabled);
        this.variablesButton.setEnabled(enabled);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        SvdLaunchParams.applyDefaults((ILaunchConfigurationWorkingCopy)configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block5: {
            this.configuration = configuration;
            try {
                try {
                    this.initialization = true;
                    this.svdLaunchParams = new SvdLaunchParams(configuration);
                    this.initialize();
                }
                catch (CoreException e) {
                    SvdUiActivator.getInstance().log(e.getStatus());
                    this.initialization = false;
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.initialization = false;
                throw throwable;
            }
            this.initialization = false;
        }
        this.setDirty(false);
    }

    protected void initialize() {
        boolean cleanWatchView = this.svdLaunchParams.isCleanWatchView();
        this.cleanButton.setSelection(cleanWatchView);
        this.askBeforeCleanButton.setSelection(this.svdLaunchParams.isAskBeforeClean());
        this.askBeforeCleanButton.setEnabled(cleanWatchView);
        boolean useDefault = this.svdLaunchParams.isUseDefault();
        this.useDefaultSvdFilePathButton.setSelection(useDefault);
        this.enableSvdFilePathGroup(!useDefault);
        this.svdFilePath = this.svdLaunchParams.getSvdPath();
        this.updateSvdFilePathField();
        this.updateArmFilelds();
    }

    private void updateArmFilelds() {
        List svdSources = this.getSourcesStream(SvdSourceType.ARM, SvdSourceType.SPR, SvdSourceType.CSR, SvdSourceType.CSR_SIM).map(s -> s.getUID()).collect(Collectors.toList());
        if (svdSources.isEmpty()) {
            this.armFilePathField.setText(Messages.SvdLaunchConfigurationTab_svd_file_not_found);
            this.armMergeStrategyButton.setEnabled(false);
            this.armMergeStrategyButton.setSelection(false);
        } else {
            this.armMergeStrategyButton.setEnabled(true);
            String mergeStrategy = this.svdLaunchParams.getMergeStrategy();
            if (SvdLaunchParams.MERGE_STRATEGY.ALL.name().equals(mergeStrategy)) {
                this.armMergeStrategyButton.setSelection(true);
            } else {
                this.armMergeStrategyButton.setSelection(false);
            }
            this.armFilePathField.setText(String.join((CharSequence)";", svdSources));
        }
        this.armFilePathLabel.setEnabled(this.armMergeStrategyButton.getSelection());
    }

    private Optional<SvdSource> getSource(SvdSourceType type) {
        return this.getSourcesStream((? super SvdSource s) -> s.getType() == type).findFirst();
    }

    private Stream<SvdSource> getSourcesStream(SvdSourceType ... types) {
        HashSet<SvdSourceType> typesSet = new HashSet<SvdSourceType>(Arrays.asList(types));
        return this.getSourcesStream((? super SvdSource s) -> typesSet.contains(s.getType()));
    }

    private Stream<SvdSource> getSourcesStream(Predicate<? super SvdSource> predicate) {
        return SvdLaunchConfigurations.getDefaultSvdSources((ILaunchConfiguration)this.configuration).getSources().stream().filter(predicate);
    }

    private void updateSvdFilePathField() {
        if (this.useDefaultSvdFilePathButton.getSelection()) {
            this.setDefaultSvdPath();
        } else {
            this.svdFilePathField.setText(this.svdFilePath);
        }
    }

    private void setDefaultSvdPath() {
        Optional<SvdSource> svdSource = this.getSource(SvdSourceType.SVD);
        if (svdSource.isPresent()) {
            this.svdFilePathField.setText(svdSource.get().getUID());
        } else {
            this.svdFilePathField.setText(Messages.SvdLaunchConfigurationTab_svd_file_not_found);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.svdLaunchParams.setCleanWatchView(this.cleanButton.getSelection());
        this.svdLaunchParams.setAskBeforeClean(this.askBeforeCleanButton.getSelection());
        boolean useDefault = this.useDefaultSvdFilePathButton.getSelection();
        this.svdLaunchParams.setUseDefault(useDefault);
        if (!useDefault) {
            this.svdFilePath = this.getSvdFilePathFieldText();
        }
        this.svdLaunchParams.setSvdPath(this.svdFilePath);
        if (this.armMergeStrategyButton.getSelection()) {
            this.svdLaunchParams.setMergeStrategy(SvdLaunchParams.MERGE_STRATEGY.ALL);
        } else {
            this.svdLaunchParams.setMergeStrategy(SvdLaunchParams.MERGE_STRATEGY.NONE);
        }
        this.svdLaunchParams.apply(configuration);
    }

    private String getSvdFilePathFieldText() {
        return this.svdFilePathField.getText().trim();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        if (this.useDefaultSvdFilePathButton.getSelection()) {
            return true;
        }
        String text = this.getSvdFilePathFieldText();
        if (text.isEmpty()) {
            this.setErrorMessage(Messages.SvdLaunchConfigurationTab_svd_path_is_undefined);
            return false;
        }
        try {
            text = SvdLaunchConfigurationTab.performStringSubstitution(text);
        }
        catch (CoreException e) {
            SvdUiActivator.getInstance().log(e.getStatus());
            this.setErrorMessage(e.getStatus().getMessage());
            return false;
        }
        if (SvdLaunchConfigurationTab.isUrl(text)) {
            return true;
        }
        if (SvdLaunchConfigurationTab.isPath(text)) {
            Path path = Paths.get(text, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                this.setErrorMessage(NLS.bind((String)Messages.SvdLaunchConfigurationTab_file_does_not_exist_0, (Object)path.toString()));
                return false;
            }
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                this.setErrorMessage(NLS.bind((String)Messages.SvdLaunchConfigurationTab_path_is_not_a_file_0, (Object)path.toString()));
                return false;
            }
            return true;
        }
        this.setErrorMessage(Messages.SvdLaunchConfigurationTab_svd_source_should_be_valid_url_or_path_to_file);
        return false;
    }

    private static boolean isPath(String text) {
        try {
            Paths.get(text, new String[0]);
            return true;
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
    }

    private static boolean isUrl(String text) {
        try {
            new URL(text);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    private static String performStringSubstitution(String text) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(text);
    }

    public String getName() {
        return Messages.SvdLaunchConfigurationTab_svd_support;
    }

    public Image getImage() {
        return SvdUiActivator.getInstance().getImage("icon_svd_view");
    }

    public String getId() {
        return TAB_ID;
    }

    private void handleFileSystemButtonSelected() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.SvdLaunchConfigurationTab_select_file);
        Path parent = null;
        try {
            String resolved = SvdLaunchConfigurationTab.performStringSubstitution(this.getSvdFilePathFieldText());
            parent = Paths.get(resolved, new String[0]).getParent();
        }
        catch (CoreException e) {
            SvdUiActivator.getInstance().log(e.getStatus());
        }
        catch (InvalidPathException invalidPathException) {}
        if (parent == null) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        } else {
            dialog.setFilterPath(parent.toString());
        }
        dialog.setFilterExtensions(SvdLaunchConfigurationTab.toFilter(EXTENSIONS));
        dialog.setFilterNames(new String[]{Messages.SvdLaunchConfigurationTab_svd_file});
        String result = dialog.open();
        if (result != null) {
            this.svdFilePathField.setText(result);
        }
    }

    private static String[] toFilter(String[] extensions) {
        return new String[]{Arrays.stream(extensions).map(e -> "*." + e).collect(Collectors.joining(";"))};
    }

    private void handleVariablesButtonSelected() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        String result = dialog.getVariableExpression();
        if (result != null) {
            this.svdFilePathField.insert(result);
        }
    }

    private void handleSelectDeviceButtonSelected() {
        String launchId;
        try {
            launchId = this.configuration.getType().getIdentifier();
        }
        catch (CoreException ex) {
            launchId = "";
            SvdUiActivator.getInstance().log(ex.getStatus());
        }
        SvdTreeSelectionDialog dialog = new SvdTreeSelectionDialog(this.getShell(), new SvdViewerFilterByExistence(launchId), Messages.SvdLaunchConfigurationTab_select_core_type_by_device, launchId);
        if (dialog.open() != 0) {
            return;
        }
        SvdDescriptor descriptor = dialog.getSvdDescriptor();
        if (descriptor == null) {
            SvdUiActivator.getInstance().logError(Messages.SvdLaunchConfigurationTab_no_svd_descriptor);
            return;
        }
        this.svdFilePathField.setText(descriptor.getSvdPath());
    }

    private void handleBrowseWorkspaceFileSelected() {
        FilteringElementTreeSelectionDialog dialog = new FilteringElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider(), true);
        dialog.setTitle(Messages.SvdLaunchConfigurationTab_select_file);
        dialog.setMessage(Messages.SvdLaunchConfigurationTab_select_svd_file);
        dialog.setEmptyListMessage(Messages.SvdLaunchConfigurationTab_there_is_no_svd_file);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        List collectFiles = Collections.emptyList();
        try {
            collectFiles = WorkspaceResources.collectFiles((String[])EXTENSIONS);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            dialog.setMessage(status.getMessage());
            SvdUiActivator.getInstance().log(status);
        }
        final HashSet<IResource> resources = new HashSet<IResource>();
        for (IFile file : collectFiles) {
            resources.addAll(SvdLaunchConfigurationTab.collect(file));
        }
        dialog.setAllowMultiple(false);
        dialog.setInitialSelection(null);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || !(selection[0] instanceof IFile)) {
                    return SvdUiActivator.getInstance().createStatus(4, null);
                }
                return Status.OK_STATUS;
            }
        });
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return resources.contains(element);
            }
        });
        int buttonId = dialog.open();
        if (buttonId == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            this.svdFilePathField.setText(SvdLaunchConfigurationTab.getWorkspaceRelative(resource));
        }
    }

    private static Collection<IResource> collect(IFile file) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IFile current = file;
        while (current != null) {
            result.add((IResource)current);
            if (current instanceof IProject) {
                return result;
            }
            current = current.getParent();
        }
        return result;
    }

    private static String getWorkspaceRelative(IResource resource) {
        String expression = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", resource.getProject().getName());
        return String.valueOf(expression) + "/" + resource.getProjectRelativePath();
    }

    protected class WidgetListener
    extends SelectionAdapter {
        protected WidgetListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == SvdLaunchConfigurationTab.this.workspaceButton) {
                SvdLaunchConfigurationTab.this.handleBrowseWorkspaceFileSelected();
            } else if (source == SvdLaunchConfigurationTab.this.filesystemButton) {
                SvdLaunchConfigurationTab.this.handleFileSystemButtonSelected();
            } else if (source == SvdLaunchConfigurationTab.this.variablesButton) {
                SvdLaunchConfigurationTab.this.handleVariablesButtonSelected();
            } else if (source == SvdLaunchConfigurationTab.this.deviceButton) {
                SvdLaunchConfigurationTab.this.handleSelectDeviceButtonSelected();
            }
        }
    }
}

