/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.provider.configuration.storage.tee.AStorageTeeGenericRdc;
import com.nxp.swtools.provider.configuration.storage.tee.AStorageTeeGenericRdcCheckerConfig;
import com.nxp.swtools.provider.configuration.storage.tee.AStorageTeeGenericRdcMasterConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeGenericRdcTemplateConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeMbcConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeMrcConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeTrdcMasterConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeTrdcMasterDomainAssignment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="trdc", strict=false)
public class StorageTeeTrdc
extends AStorageTeeGenericRdc<StorageTeeTrdcMasterConfig, StorageTeeTrdcMasterDomainAssignment> {
    @ElementList(name="masters", entry="master", type=StorageTeeTrdcMasterConfig.class, inline=false, required=true)
    private ArrayList<StorageTeeTrdcMasterConfig> masters = new ArrayList();
    @ElementList(name="access_templates", entry="template", type=StorageTeeGenericRdcTemplateConfig.class, inline=false, required=false)
    private ArrayList<StorageTeeGenericRdcTemplateConfig> templates = new ArrayList();
    @ElementList(name="mbcs", entry="mbc", type=StorageTeeMbcConfig.class, inline=false, required=false)
    private ArrayList<StorageTeeMbcConfig> mbcs = new ArrayList();
    @ElementList(name="mrcs", entry="mrc", type=StorageTeeMrcConfig.class, inline=false, required=false)
    private ArrayList<StorageTeeMrcConfig> mrcs = new ArrayList();

    @Override
    public List<StorageTeeTrdcMasterConfig> getMasterConfigs() {
        return this.masters;
    }

    @Override
    public void setMasterConfigs(List<StorageTeeTrdcMasterConfig> masters) {
        this.masters = new ArrayList<StorageTeeTrdcMasterConfig>(masters);
    }

    public List<StorageTeeGenericRdcTemplateConfig> getTemplates() {
        return this.templates;
    }

    public void setTemplates(List<StorageTeeGenericRdcTemplateConfig> templates) {
        this.templates = new ArrayList<StorageTeeGenericRdcTemplateConfig>(templates);
    }

    public @Nullable StorageTeeMbcConfig findMbcConfig(String checkerId) {
        for (StorageTeeMbcConfig mbc : this.mbcs) {
            if (!Objects.equals(mbc.getCheckerId(), checkerId)) continue;
            return mbc;
        }
        return null;
    }

    public @Nullable StorageTeeMrcConfig findMrcConfig(String checkerId) {
        for (StorageTeeMrcConfig mrc : this.mrcs) {
            if (!Objects.equals(mrc.getCheckerId(), checkerId)) continue;
            return mrc;
        }
        return null;
    }

    public List<StorageTeeMbcConfig> getMbcConfigs() {
        return this.mbcs;
    }

    public void setMbcConfigs(List<StorageTeeMbcConfig> mbcs) {
        this.mbcs = new ArrayList<StorageTeeMbcConfig>(mbcs);
    }

    public List<StorageTeeMrcConfig> getMrcConfigs() {
        return this.mrcs;
    }

    public void setMrcConfigs(List<StorageTeeMrcConfig> mrcs) {
        this.mrcs = new ArrayList<StorageTeeMrcConfig>(mrcs);
    }

    @Override
    public void fillYamlStorable(IYamlStorable yaml) {
        YamlStorableList yamlStorable = new YamlStorableList("trdc", Boolean.FALSE);
        super.fillYamlStorable((IYamlStorable)yamlStorable);
        yaml.addYamlChild((IYamlStorable)yamlStorable);
        YamlStorableList mastersYaml = new YamlStorableList("masters", Boolean.TRUE);
        mastersYaml.setForceSequence(true);
        this.masters.forEach(each -> each.fillYamlStorable((IYamlStorable)mastersYaml));
        yamlStorable.addYamlChild((IYamlStorable)mastersYaml);
        YamlStorableList templatesYaml = new YamlStorableList("access_templates", Boolean.TRUE);
        templatesYaml.setForceSequence(true);
        this.templates.forEach(each -> each.fillYamlStorable((IYamlStorable)templatesYaml));
        yamlStorable.addYamlChild((IYamlStorable)templatesYaml);
        YamlStorableList mbcsYaml = new YamlStorableList("mbcs", Boolean.FALSE);
        this.mbcs.forEach(each -> each.fillYamlStorable((IYamlStorable)mbcsYaml));
        yamlStorable.addYamlChild((IYamlStorable)mbcsYaml);
        YamlStorableList mrcsYaml = new YamlStorableList("mrcs", Boolean.FALSE);
        this.mrcs.forEach(each -> each.fillYamlStorable((IYamlStorable)mrcsYaml));
        yamlStorable.addYamlChild((IYamlStorable)mrcsYaml);
    }

    @Override
    public boolean updateFromYamlStorable(IYamlStorable yaml) {
        if (!yaml.getYamlId().equals("trdc") || !super.updateFromYamlStorable(yaml)) {
            return false;
        }
        ArrayList<Object> mastersLoc = new ArrayList<StorageTeeTrdcMasterConfig>();
        ArrayList<Object> templatesLoc = new ArrayList<StorageTeeGenericRdcTemplateConfig>();
        ArrayList<AStorageTeeGenericRdcCheckerConfig> mbcsLoc = new ArrayList<StorageTeeMbcConfig>();
        ArrayList<AStorageTeeGenericRdcCheckerConfig> mrcsLoc = new ArrayList<StorageTeeMrcConfig>();
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        for (IYamlStorable childYaml : children) {
            AStorageTeeGenericRdcCheckerConfig config;
            Iterator iterator;
            Object config2;
            String yamlId = childYaml.getYamlId();
            if (!(childYaml instanceof YamlStorableList)) continue;
            if (yamlId.equals("masters")) {
                ArrayList<Object> mastersFromYaml = new ArrayList<Object>();
                for (IYamlStorable masterYaml : CollectionsUtils.safeCollection((Collection)childYaml.getYamlChildren())) {
                    if (masterYaml instanceof YamlStorableList) {
                        masterYaml = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)masterYaml), (String)"master");
                    }
                    if (!((AStorageTeeGenericRdcMasterConfig)(config2 = new StorageTeeTrdcMasterConfig())).updateFromYamlStorable(masterYaml)) continue;
                    mastersFromYaml.add(config2);
                }
                mastersLoc = mastersFromYaml;
                continue;
            }
            if (yamlId.equals("access_templates")) {
                ArrayList<Object> templatesFromYaml = new ArrayList<Object>();
                for (IYamlStorable templateYaml : CollectionsUtils.safeCollection((Collection)childYaml.getYamlChildren())) {
                    if (templateYaml instanceof YamlStorableList) {
                        templateYaml = YamlStorableHelper.skipMapLayer((YamlStorableList)((YamlStorableList)templateYaml), (String)"template");
                    }
                    if (!((StorageTeeGenericRdcTemplateConfig)(config2 = new StorageTeeGenericRdcTemplateConfig())).updateFromYamlStorable(templateYaml)) continue;
                    templatesFromYaml.add(config2);
                }
                templatesLoc = templatesFromYaml;
                continue;
            }
            if (yamlId.equals("mbcs")) {
                ArrayList<AStorageTeeGenericRdcCheckerConfig> mbcsFromYaml = new ArrayList<AStorageTeeGenericRdcCheckerConfig>();
                Collection mbcsYamls = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)childYaml, (String)"mbcs");
                iterator = mbcsYamls.iterator();
                while (iterator.hasNext()) {
                    config = new StorageTeeMbcConfig();
                    IYamlStorable mbcYaml = (IYamlStorable)iterator.next();
                    if (!config.updateFromYamlStorable(mbcYaml)) continue;
                    mbcsFromYaml.add(config);
                }
                mbcsLoc = mbcsFromYaml;
                continue;
            }
            if (!yamlId.equals("mrcs")) continue;
            ArrayList<AStorageTeeGenericRdcCheckerConfig> mrcsFromYaml = new ArrayList<AStorageTeeGenericRdcCheckerConfig>();
            Collection mrcsYamls = YamlStorableHelper.getChildrenCheckIdAndSkipMapLayer((IYamlStorable)childYaml, (String)"mrcs");
            iterator = mrcsYamls.iterator();
            while (iterator.hasNext()) {
                config = new StorageTeeMrcConfig();
                IYamlStorable mrcYaml = (IYamlStorable)iterator.next();
                if (!config.updateFromYamlStorable(mrcYaml)) continue;
                mrcsFromYaml.add(config);
            }
            mrcsLoc = mrcsFromYaml;
        }
        this.setMasterConfigs((List<StorageTeeTrdcMasterConfig>)mastersLoc);
        this.setTemplates(templatesLoc);
        this.setMbcConfigs(mbcsLoc);
        this.setMrcConfigs(mrcsLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.masters, this.mbcs, this.mrcs, this.templates);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        assert (obj != null);
        StorageTeeTrdc other = (StorageTeeTrdc)obj;
        return Objects.equals(this.masters, other.masters) && Objects.equals(this.mbcs, other.mbcs) && Objects.equals(this.mrcs, other.mrcs) && Objects.equals(this.templates, other.templates);
    }

    public String toString() {
        return String.format("%s [%s, %s=%s, %s=%s, %s=%s, %s=%s]", StorageTeeTrdc.class.getSimpleName(), super.toString(), "masters", this.masters.subList(0, Math.min(this.masters.size(), 3)), "access_templates", this.templates.subList(0, Math.min(this.templates.size(), 3)), "mbcs", this.mbcs.subList(0, Math.min(this.mbcs.size(), 3)), "mrcs", this.mrcs.subList(0, Math.min(this.mbcs.size(), 3)));
    }
}

