/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.yaml.IYamlConvertible;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableHelper;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeAhb;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeRdc;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeSecurityPeripheralBase;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeTrdc;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeXrdc2;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeXtrdc;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementListUnion;

public class StorageTeeSecurityPeripheralsContainer
implements IYamlConvertible {
    private Map<String, StorageTeeSecurityPeripheralBase> securityPeripherals = new HashMap<String, StorageTeeSecurityPeripheralBase>();

    @ElementListUnion(value={@ElementList(required=false, inline=true, entry="ahb", type=StorageTeeAhb.class), @ElementList(required=false, inline=true, entry="rdc", type=StorageTeeRdc.class), @ElementList(required=false, inline=true, entry="xrdc2", type=StorageTeeXrdc2.class), @ElementList(required=false, inline=true, entry="trdc", type=StorageTeeTrdc.class), @ElementList(required=false, inline=true, entry="xtrdc", type=StorageTeeXtrdc.class)})
    public @ElementListUnion(value={@ElementList(required=false, inline=true, entry="ahb", type=StorageTeeAhb.class), @ElementList(required=false, inline=true, entry="rdc", type=StorageTeeRdc.class), @ElementList(required=false, inline=true, entry="xrdc2", type=StorageTeeXrdc2.class), @ElementList(required=false, inline=true, entry="trdc", type=StorageTeeTrdc.class), @ElementList(required=false, inline=true, entry="xtrdc", type=StorageTeeXtrdc.class)}) @ElementList(required=false, inline=true, entry="ahb", type=StorageTeeAhb.class) @ElementList(required=false, inline=true, entry="rdc", type=StorageTeeRdc.class) @ElementList(required=false, inline=true, entry="xrdc2", type=StorageTeeXrdc2.class) @ElementList(required=false, inline=true, entry="trdc", type=StorageTeeTrdc.class) @ElementList(required=false, inline=true, entry="xtrdc", type=StorageTeeXtrdc.class) List<StorageTeeSecurityPeripheralBase> getSecurityPeripherals() {
        return CollectionsUtils.listFromMapValues(this.securityPeripherals);
    }

    @ElementListUnion(value={@ElementList(required=false, inline=true, entry="ahb", type=StorageTeeAhb.class), @ElementList(required=false, inline=true, entry="rdc", type=StorageTeeRdc.class), @ElementList(required=false, inline=true, entry="xrdc2", type=StorageTeeXrdc2.class), @ElementList(required=false, inline=true, entry="trdc", type=StorageTeeTrdc.class), @ElementList(required=false, inline=true, entry="xtrdc", type=StorageTeeXtrdc.class)})
    public void setSecurityPeripherals(List<StorageTeeSecurityPeripheralBase> securityPeripherals) {
        this.clearSecurityPeripherals();
        this.addSecurityPeripherals(securityPeripherals);
    }

    public @Nullable StorageTeeSecurityPeripheralBase getSecurityPeripheral(@Nullable String id) {
        return this.securityPeripherals.get(UtilsText.safeString((String)id));
    }

    public void clearSecurityPeripherals() {
        this.securityPeripherals.clear();
    }

    public void addSecurityPeripheral(StorageTeeSecurityPeripheralBase securityPeripheral) {
        this.securityPeripherals.put(UtilsText.safeString((String)securityPeripheral.getId()), securityPeripheral);
    }

    public void addSecurityPeripherals(Collection<? extends StorageTeeSecurityPeripheralBase> securityPeripheralStorages) {
        securityPeripheralStorages.forEach(sp -> this.addSecurityPeripheral((StorageTeeSecurityPeripheralBase)sp));
    }

    public int hashCode() {
        return Objects.hash(this.securityPeripherals);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeSecurityPeripheralsContainer other = (StorageTeeSecurityPeripheralsContainer)obj;
        return Objects.equals(this.securityPeripherals, other.securityPeripherals);
    }

    public void fillYamlStorable(IYamlStorable yaml) {
        List<StorageTeeSecurityPeripheralBase> peripherals = this.getSecurityPeripherals();
        if (!peripherals.isEmpty()) {
            peripherals.forEach(sm -> sm.fillYamlStorable(yaml));
        }
    }

    public boolean updateFromYamlStorable(IYamlStorable yaml) {
        this.securityPeripherals.clear();
        Collection children = YamlStorableHelper.getChildrenAndSkipMapLayer((IYamlStorable)yaml);
        for (IYamlStorable childYaml : children) {
            StorageTeeSecurityPeripheralBase securityPeripheral;
            if (!(childYaml instanceof YamlStorableList) || (securityPeripheral = StorageTeeSecurityPeripheralsContainer.createFromYaml(childYaml)) == null) continue;
            this.addSecurityPeripheral(securityPeripheral);
        }
        return true;
    }

    public static @Nullable StorageTeeSecurityPeripheralBase createFromYaml(IYamlStorable yaml) {
        StorageTeeSecurityPeripheralBase result = null;
        switch (yaml.getYamlId()) {
            case "ahb": {
                result = new StorageTeeAhb();
                break;
            }
            case "trdc": {
                result = new StorageTeeTrdc();
                break;
            }
            case "rdc": {
                result = new StorageTeeRdc();
                break;
            }
            case "xrdc2": {
                result = new StorageTeeXrdc2();
                break;
            }
            case "xtrdc": {
                result = new StorageTeeXtrdc();
            }
        }
        if (result != null) {
            result.updateFromYamlStorable(yaml);
        }
        return result;
    }
}

