/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.legacy;

import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.kex.selector.IMcuSelectionWritable;
import com.nxp.swtools.kex.selector.McuSelectionFactory;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.legacy.CompatibilityEntries;
import com.nxp.swtools.provider.configuration.legacy.CompatibilityEntry;
import com.nxp.swtools.provider.configuration.legacy.CompatibilityEntryPackage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;

public final class SharedConfigurationCompatibility {
    public static final String CONFIGURATION_DATA_SUBDIR = "configuration";
    private static final String COMPATIBILITY_XML = "compatibility.xml";
    private static final String COMPATIBILITY_FILE_NAME_REGEX = "compatibility.*\\.xml";
    private static final String KEY_SEPARATOR = "/";
    private static final String XML_FILE_EXTENSION = ".xml";
    final CompatibilityEntries entries = new CompatibilityEntries();
    final Map<String, CompatibilityEntry> processorSet = new HashMap<String, CompatibilityEntry>();
    final Map<String, CompatibilityEntry> boardSet = new HashMap<String, CompatibilityEntry>();
    private static final Logger LOGGER = LogManager.getLogger(SharedConfigurationCompatibility.class);

    public SharedConfigurationCompatibility() {
        this.loadCompatibilityTable();
    }

    public SharedConfigurationCompatibility(InputStream stream) {
        try {
            this.parseXml(stream);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Cannot deserialize compatibility.xml", e);
        }
    }

    private void loadCompatibilityTable() {
        String configurationDirectoryName = String.valueOf(SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools().getDataDir()) + File.separator + CONFIGURATION_DATA_SUBDIR;
        List configurationDirFiles = UtilsFile.findFilesByExtension((String)configurationDirectoryName, (String)XML_FILE_EXTENSION, (int)0);
        boolean fragmentLoaded = false;
        for (Object filePath : configurationDirFiles) {
            File file = new File((String)filePath);
            String fileName = file.getName();
            if (!fileName.matches(COMPATIBILITY_FILE_NAME_REGEX)) continue;
            try {
                Throwable throwable = null;
                Object var9_14 = null;
                try (FileInputStream xmlStream = new FileInputStream(file);){
                    this.parseXml(xmlStream);
                    fragmentLoaded = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, MessageFormat.format("Cannot deserialize {0}", fileName), e);
            }
        }
        if (!fragmentLoaded) {
            try {
                Object filePath;
                filePath = null;
                Iterator iterator = null;
                try (InputStream xmlStream = SharedConfigurationCompatibility.class.getResourceAsStream(COMPATIBILITY_XML);){
                    if (xmlStream != null) {
                        this.parseXml(xmlStream);
                    }
                }
                catch (Throwable throwable) {
                    if (filePath == null) {
                        filePath = throwable;
                    } else if (filePath != throwable) {
                        ((Throwable)filePath).addSuppressed(throwable);
                    }
                    throw filePath;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, MessageFormat.format("Cannot deserialize {0}", COMPATIBILITY_XML), e);
            }
        }
    }

    private void parseXml(InputStream xmlStream) throws Exception {
        AnnotationStrategy strategy = new AnnotationStrategy();
        Persister serializer = new Persister((Strategy)strategy);
        serializer.read((Object)this.entries, xmlStream);
        this.processorSet.clear();
        this.boardSet.clear();
        this.entries.getProcessors().forEach(entry -> {
            CompatibilityEntry compatibilityEntry = this.processorSet.put(String.valueOf(entry.getSourceName()) + KEY_SEPARATOR + entry.getSourceSdk() + KEY_SEPARATOR + UtilsText.safeString((String)entry.getSourcePackage()), (CompatibilityEntry)entry);
        });
        this.entries.getBoards().forEach(entry -> {
            CompatibilityEntry compatibilityEntry = this.boardSet.put(String.valueOf(entry.getSourceName()) + KEY_SEPARATOR + entry.getSourceSdk(), (CompatibilityEntry)entry);
        });
    }

    public void checkAndFixMcuCompatibility(ISharedConfiguration config) {
        IMcuIdentification mcuIdent = config.getCommonConfig().getMcuIdentification();
        CompatibilityEntry entry = this.boardSet.get(String.valueOf(mcuIdent.getBoard()) + KEY_SEPARATOR + mcuIdent.getSdkVersion());
        if (entry != null && config.getCommonConfig() instanceof IMcuSelectionWritable) {
            IMcuSelectionWritable mcuSelection = (IMcuSelectionWritable)config.getCommonConfig();
            mcuSelection.setBoard(entry.getTargetName());
            mcuSelection.setSdkVersion(entry.getTargetSdk());
        }
        if ((entry = this.processorSet.get(String.valueOf(mcuIdent.getMcu()) + KEY_SEPARATOR + mcuIdent.getSdkVersion() + KEY_SEPARATOR + mcuIdent.getPackage())) == null) {
            entry = this.processorSet.get(String.valueOf(mcuIdent.getMcu()) + KEY_SEPARATOR + mcuIdent.getSdkVersion() + KEY_SEPARATOR);
        }
        if (entry != null) {
            String mcuPackage = mcuIdent.getPackage();
            for (CompatibilityEntryPackage p : entry.getPackages()) {
                if (!p.getSourceName().equalsIgnoreCase(mcuPackage)) continue;
                mcuPackage = p.getTargetName();
                break;
            }
            if (Objects.equals(entry.getSourceName(), entry.getTargetName()) && Objects.equals(entry.getSourceSdk(), entry.getTargetSdk()) && Objects.equals(mcuPackage, mcuIdent.getPackage())) {
                return;
            }
            config.setMcuIdentification(McuSelectionFactory.createMcuSelectionIdentification((String)entry.getTargetName(), (String)mcuPackage, (String)entry.getTargetSdk(), (String)config.getCommonConfig().getBoard(), (String)config.getCommonConfig().getKit(), (String)config.getCommonConfig().getMexVariant()));
            LOGGER.info(MessageFormat.format("Switching processor from {0}/{1}/{2} to {3}/{4}/{5}", mcuIdent.getMcu(), mcuIdent.getPackage(), mcuIdent.getSdkVersion(), entry.getTargetName(), mcuPackage, entry.getTargetSdk()));
        }
    }
}

