/* Copyright 2019-2023 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 ****************************************************************************/
	.arch	armv8-a

	.text
	.align	2

	.globl	Current_EL3_SPx_Sync_Handler
	.type	Current_EL3_SPx_Sync_Handler, %function
Current_EL3_SPx_Sync_Handler:
	stp		x29, x30, [sp,#-192]!	/* SP should always be aligned to 16 byte boundary sp[3:0]=0. Otherwise, exception occurs*/
	mov		x29, sp
	str		x0, [x29,#32]
	str		x1, [x29,#40]
	str		x2, [x29,#48]
	str		x3, [x29,#56]
	str		x4, [x29,#64]
	str		x5, [x29,#72]
	str		x6, [x29,#80]
	str		x7, [x29,#88]
	str		x8, [x29,#96]
	str		x9, [x29,#104]
	str		x10, [x29,#112]
	str		x11, [x29,#120]
	str		x12, [x29,#128]
	str		x13, [x29,#136]
	str		x14, [x29,#144]
	str		x15, [x29,#152]
	str		x16, [x29,#160]
	str		x17, [x29,#168]
	str		x18, [x29,#176]

#ifdef __ILP32__
	adrp	x9, :pg_hi21:Current_EL3_SPx_Sync
	add		x9, x9, :lo12:Current_EL3_SPx_Sync
#else
	ldr		x9, =Current_EL3_SPx_Sync
#endif
	blr		x9
	ldr		x0, [x29,#32]
	ldr		x1, [x29,#40]
	ldr		x2, [x29,#48]
	ldr		x3, [x29,#56]
	ldr		x4, [x29,#64]
	ldr		x5, [x29,#72]
	ldr		x6, [x29,#80]
	ldr		x7, [x29,#88]
	ldr		x8, [x29,#96]
	ldr		x9, [x29,#104]
	ldr		x10, [x29,#112]
	ldr		x11, [x29,#120]
	ldr		x12, [x29,#128]
	ldr		x13, [x29,#136]
	ldr		x14, [x29,#144]
	ldr		x15, [x29,#152]
	ldr		x16, [x29,#160]
	ldr		x17, [x29,#168]
	ldr		x18, [x29,#176]
	ldp		x29, x30, [sp],#192
	eret

	.pool
	.size	Current_EL3_SPx_Sync_Handler, . - Current_EL3_SPx_Sync_Handler
