/*******************************************************************************
 Copyright 2023 NXP 

 NXP Confidential and Proprietary. This software is owned or controlled by NXP
 and may only be used strictly in accordance with the applicable license terms.
 By expressly accepting such terms or by downloading, installing, activating
 and/or otherwise using the software, you are agreeing that you have read, and
 that you agree to comply with and are bound by, such license terms. If you do
 not agree to be bound by the applicable license terms, then you may not retain,
 install, activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser.epl.help;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;

import com.freescale.system.browser.epl.ITabbedPageContributorEpl;
import com.freescale.system.browser.epl.ITabbedPageEpl;
import com.freescale.system.browser2.Messages2;
import com.freescale.system.browser2.OSAwarenessData2;

public class TabbedDefaultPageEpl extends Page implements ITabbedPageEpl {
	private Composite cmpControl;
	private Label lblStatus;

	/**
	 * Constructor
	 */
	public TabbedDefaultPageEpl() {
		super();
	}

	/**
	 * Create the page's controls.
	 */
	@Override
	public void createControl(Composite parent) {
		cmpControl = new Composite(parent, SWT.None);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		cmpControl.setLayout(layout);

		lblStatus = new Label(cmpControl, SWT.None);
		lblStatus.setText(Messages2.DefaultPage_No_Context);
		GridDataFactory.swtDefaults().grab(true, false).align(SWT.CENTER, SWT.BEGINNING).applyTo(lblStatus);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.Page#dispose()
	 */
	@Override
	public void dispose() {
		lblStatus = null;
		super.dispose();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.Page#setFocus()
	 */
	@Override
	public void setFocus() {
		if (lblStatus != null) {
			lblStatus.setFocus();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.Page#getControl()
	 */
	@Override
	public Control getControl() {
		return cmpControl; 
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.ISelectionListener#selectionChanged(org.eclipse.ui.IWorkbenchPart, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {}

	/* (non-Javadoc)
	 * @see com.freescale.system.browser.ui.tabbed.ITabbedPage#getContributor()
	 */
	@Override
	public ITabbedPageContributorEpl getContributor() { //
		// this is the default page so there's no contributor
		return null;
	}

	/* (non-Javadoc)
	 * @see com.freescale.system.browser.ui.tabbed.ITabbedPage#setInput(java.lang.Object)
	 */
	@Override
	public void setPageInput(final OSAwarenessData2 input) {
		if (lblStatus == null) {
			return;
		}

		// layout is used to force label size computing again as its width may vary due on text shown
		if (input.getContext() == null) {
			if (!Messages2.DefaultPage_No_Context.equals(lblStatus.getText())) {
				lblStatus.setText(Messages2.DefaultPage_No_Context);
				cmpControl.layout();
			}
		} else {
			if (!Messages2.DefaultPage_No_Info_For_Context.equals(lblStatus.getText())) {
				lblStatus.setText(Messages2.DefaultPage_No_Info_For_Context);
				cmpControl.layout();
			}
		}
	}
}
