/*
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * Copyright 2023 NXP
 * 
 * SPDX-License-Identifier: EPL-1.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *
 * Used:
 *     examples from org.eclipse.swt.snippets.Snippet125
 */

package com.nxp.sa.ui.common.epl;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.jface.viewers.TableViewer;

public class FileChooserDialogEPL {
	
	public static void handleEvent (Event event, TableViewer m_filesTableViewer) {
			Label label = (Label)event.widget;
			Shell shell = label.getShell ();
			switch (event.type) {
				case SWT.MouseDown:
					Event e = new Event ();
					e.item = (TableItem) label.getData ("_TABLEITEM");
					m_filesTableViewer.getTable().setSelection (new TableItem [] {(TableItem) e.item});
					m_filesTableViewer.getTable().notifyListeners (SWT.Selection, e);
					shell.dispose ();
					m_filesTableViewer.getTable().setFocus();
					break;
				case SWT.MouseExit:
					shell.dispose ();
					break;
				default: break;
			}
		}
}
